/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.nodes.transfer;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.fluids.StoredFluidStack;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.FontHelper;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.integration.multipart.TileSonarMultipart;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncCoords;
import sonar.core.network.sync.SyncEnum;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.sync.SyncUUID;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.api.core.items.operator.IOperatorTile;
import sonar.logistics.api.core.items.operator.OperatorMode;
import sonar.logistics.api.core.tiles.connections.EnumCableRenderSize;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.nodes.INode;
import sonar.logistics.api.core.tiles.nodes.NodeTransferMode;
import sonar.logistics.api.core.tiles.nodes.TransferType;
import sonar.logistics.base.channels.BlockConnection;
import sonar.logistics.base.channels.ChannelList;
import sonar.logistics.base.channels.ChannelType;
import sonar.logistics.base.channels.ContainerChannelSelection;
import sonar.logistics.base.channels.GuiChannelSelection;
import sonar.logistics.base.channels.NodeConnection;
import sonar.logistics.base.filters.ContainerFilterList;
import sonar.logistics.base.filters.GuiFilterList;
import sonar.logistics.base.filters.ITransferFilteredTile;
import sonar.logistics.base.guidance.errors.ErrorMessage;
import sonar.logistics.base.listeners.ListenerType;
import sonar.logistics.base.listeners.PL2ListenerList;
import sonar.logistics.base.tiles.IChannelledTile;
import sonar.logistics.core.tiles.base.TileSidedLogistics;
import sonar.logistics.core.tiles.displays.info.types.channels.MonitoredBlockCoords;
import sonar.logistics.core.tiles.displays.info.types.channels.MonitoredEntity;
import sonar.logistics.network.sync.SyncFilterList;

public class TileTransferNode
extends TileSidedLogistics
implements INode,
IOperatorTile,
ITransferFilteredTile,
IFlexibleGui,
IChannelledTile,
IByteBufTile {
    public static final ErrorMessage[] validStates = new ErrorMessage[]{ErrorMessage.NO_NETWORK};
    public PL2ListenerList listeners = new PL2ListenerList(this, ListenerType.ALL.size());
    public SyncTagType.INT priority = new SyncTagType.INT(1);
    public SyncEnum<NodeTransferMode> transferMode = new SyncEnum((Enum[])NodeTransferMode.values(), 2).setDefault((Enum)NodeTransferMode.ADD);
    public SyncFilterList filters = new SyncFilterList(3);
    public ChannelList list = new ChannelList(this.getIdentity(), this.channelType(), 4);
    public SyncTagType.BOOLEAN connection = new SyncTagType.BOOLEAN(5);
    public SyncTagType.BOOLEAN items = (SyncTagType.BOOLEAN)new SyncTagType.BOOLEAN(6).setDefault((Object)true);
    public SyncTagType.BOOLEAN fluids = (SyncTagType.BOOLEAN)new SyncTagType.BOOLEAN(7).setDefault((Object)true);
    public SyncTagType.BOOLEAN energy = (SyncTagType.BOOLEAN)new SyncTagType.BOOLEAN(8).setDefault((Object)true);
    public SyncCoords lastSelected = new SyncCoords(-11);
    public SyncUUID lastSelectedUUID = new SyncUUID(-10);
    public int ticks = 20;

    public TileTransferNode() {
        this.syncList.addParts(new IDirtyPart[]{this.priority, this.transferMode, this.filters, this.list, this.connection, this.items, this.fluids, this.energy});
    }

    @Override
    public boolean performOperation(RayTraceResult rayTrace, OperatorMode mode, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!this.func_145831_w().field_72995_K) {
            this.transferMode.incrementEnum();
            SonarMultipartHelper.sendMultipartUpdateSyncAround((TileSonarMultipart)this, (int)128);
            FontHelper.sendMessage((String)("Transfer Mode: " + this.transferMode.getObject()), (World)this.func_145831_w(), (EntityPlayer)player);
        }
        return true;
    }

    @Override
    public Predicate<ItemStack> getFilter() {
        return s -> this.filters.matches((ItemStack)s, (NodeTransferMode)this.transferMode.getObject());
    }

    public boolean allowed(FluidStack stack) {
        return this.filters.matches(new StoredFluidStack(stack), (NodeTransferMode)this.transferMode.getObject());
    }

    @Override
    public void addConnections(List<NodeConnection> connections) {
        connections.add(this.getConnected());
    }

    @Override
    public int getPriority() {
        return (Integer)this.priority.getObject();
    }

    @Override
    public SyncFilterList getFilters() {
        return this.filters;
    }

    @Override
    public NodeTransferMode getTransferMode() {
        return (NodeTransferMode)this.transferMode.getObject();
    }

    @Override
    public boolean isTransferEnabled(TransferType type) {
        switch (type) {
            case ENERGY: {
                return (Boolean)this.energy.getObject();
            }
            case FLUID: {
                return (Boolean)this.fluids.getObject();
            }
            case GAS: 
            case INFO: {
                break;
            }
            case ITEMS: {
                return (Boolean)this.items.getObject();
            }
        }
        return false;
    }

    @Override
    public void setTransferType(TransferType type, boolean enable) {
        switch (type) {
            case ENERGY: {
                this.energy.setObject((Object)enable);
                break;
            }
            case FLUID: {
                this.fluids.setObject((Object)enable);
                break;
            }
            case GAS: 
            case INFO: {
                break;
            }
            case ITEMS: {
                this.items.setObject((Object)enable);
                break;
            }
        }
        this.sendByteBufPacket(2);
    }

    @Override
    public BlockConnection getConnected() {
        return new BlockConnection(this, new BlockCoords(this.func_174877_v().func_177972_a(this.getCableFace()), this.func_145831_w().field_73011_w.getDimension()), this.getCableFace());
    }

    @Override
    public boolean canConnectToNodeConnection() {
        return (Boolean)this.connection.getObject();
    }

    @Override
    public void incrementTransferMode() {
        this.transferMode.incrementEnum();
        this.sendByteBufPacket(3);
    }

    @Override
    public void addInfo(List<String> info) {
        super.addInfo(info);
        info.add("Transfer Mode: " + this.transferMode.getObject());
    }

    @Override
    public ChannelType channelType() {
        return ChannelType.UNLIMITED;
    }

    @Override
    public ChannelList getChannels() {
        return this.list;
    }

    @Override
    public void sendCoordsToServer(IInfo info, int channelID) {
        if (info instanceof MonitoredBlockCoords) {
            this.lastSelected.setCoords(((MonitoredBlockCoords)info).getCoords());
            this.sendByteBufPacket(-3);
        }
        if (info instanceof MonitoredEntity) {
            this.lastSelectedUUID.setObject(((MonitoredEntity)info).getUUID());
            this.sendByteBufPacket(-4);
        }
    }

    @Override
    public PL2ListenerList getListenerList() {
        return this.listeners;
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case -4: {
                this.lastSelectedUUID.writeToBuf(buf);
                break;
            }
            case -3: {
                this.lastSelected.writeToBuf(buf);
                break;
            }
            case 1: {
                this.list.writeToBuf(buf);
                break;
            }
            case 2: {
                this.items.writeToBuf(buf);
                this.fluids.writeToBuf(buf);
                this.energy.writeToBuf(buf);
                break;
            }
            case 3: {
                this.transferMode.writeToBuf(buf);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case -4: {
                this.lastSelectedUUID.readFromBuf(buf);
                this.list.give(this.lastSelectedUUID.getUUID());
                this.sendByteBufPacket(1);
                break;
            }
            case -3: {
                this.lastSelected.readFromBuf(buf);
                this.list.give(this.lastSelected.getCoords());
                this.sendByteBufPacket(1);
                break;
            }
            case 1: {
                this.list.readFromBuf(buf);
                break;
            }
            case 2: {
                this.items.readFromBuf(buf);
                this.fluids.readFromBuf(buf);
                this.energy.readFromBuf(buf);
                break;
            }
            case 3: {
                this.transferMode.readFromBuf(buf);
                SonarMultipartHelper.sendMultipartUpdateSyncAround((TileSonarMultipart)this, (int)128);
            }
        }
    }

    public boolean hasStandardGui() {
        return true;
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                return new ContainerFilterList(player, this);
            }
            case 1: {
                return new ContainerChannelSelection(this);
            }
        }
        return null;
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                return new GuiFilterList(player, this, id);
            }
            case 1: {
                return new GuiChannelSelection(player, this, 0);
            }
        }
        return null;
    }

    public void onGuiOpened(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                SonarMultipartHelper.sendMultipartSyncToPlayer((TileSonarMultipart)this, (EntityPlayerMP)((EntityPlayerMP)player));
                break;
            }
            case 1: {
                this.sendNetworkCoordMap(player);
                this.list.markDirty();
                SonarMultipartHelper.sendMultipartSyncToPlayer((TileSonarMultipart)this, (EntityPlayerMP)((EntityPlayerMP)player));
            }
        }
    }

    @Override
    public ErrorMessage[] getValidMessages() {
        return validStates;
    }

    @Override
    public EnumCableRenderSize getCableRenderSize(EnumFacing dir) {
        return EnumCableRenderSize.INTERNAL;
    }
}

