/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.readers.items;

import net.minecraft.nbt.NBTTagCompound;
import sonar.core.helpers.NBTHelper;
import sonar.core.utils.SortingDirection;
import sonar.logistics.api.asm.ASMListSorter;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.api.core.tiles.readers.ILogicListSorter;
import sonar.logistics.core.tiles.displays.info.types.items.ItemCount;
import sonar.logistics.core.tiles.displays.info.types.items.MonitoredItemStack;
import sonar.logistics.core.tiles.readers.SortingHelper;
import sonar.logistics.core.tiles.readers.items.InventoryReader;

@ASMListSorter(id="inv_sorter", modid="practicallogistics2")
public class InventorySorter
implements ILogicListSorter<MonitoredItemStack> {
    public SortingDirection direction;
    public InventoryReader.SortingType sorting_type;
    public static final String REGISTRY_NAME = "inv_sorter";

    public InventorySorter() {
    }

    public InventorySorter(SortingDirection direction, InventoryReader.SortingType type) {
        this.direction = direction;
        this.sorting_type = type;
    }

    @Override
    public boolean canSort(Object obj) {
        return obj instanceof ItemCount || obj instanceof MonitoredItemStack;
    }

    @Override
    public AbstractChangeableList<MonitoredItemStack> sortSaveableList(AbstractChangeableList<MonitoredItemStack> updateInfo) {
        return SortingHelper.sortItems(updateInfo, this.getDirection(), this.getType());
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.direction = SortingDirection.values()[nbt.func_74762_e("SdiD")];
        this.sorting_type = InventoryReader.SortingType.values()[nbt.func_74762_e("StiD")];
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        nbt.func_74768_a("SdiD", this.getDirection().ordinal());
        nbt.func_74768_a("StiD", this.getType().ordinal());
        return nbt;
    }

    public SortingDirection getDirection() {
        return this.direction;
    }

    public InventoryReader.SortingType getType() {
        return this.sorting_type;
    }

    @Override
    public String getRegisteredName() {
        return REGISTRY_NAME;
    }
}

