/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.readers.items.handling;

import com.google.common.collect.Lists;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import sonar.core.SonarCore;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.handlers.inventories.handling.ItemTransferHelper;
import sonar.core.network.PacketStackUpdate;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.api.core.tiles.displays.info.lists.IMonitoredValue;
import sonar.logistics.api.core.tiles.readers.IListReader;
import sonar.logistics.base.channels.BlockConnection;
import sonar.logistics.base.channels.EntityConnection;
import sonar.logistics.base.data.generators.items.ITileInventoryProvider;
import sonar.logistics.core.tiles.displays.info.MasterInfoRegistry;
import sonar.logistics.core.tiles.displays.info.types.items.ItemChangeableList;
import sonar.logistics.core.tiles.displays.info.types.items.MonitoredItemStack;
import sonar.logistics.core.tiles.readers.items.handling.ItemNetworkChannels;

public class ItemHelper {
    @Nonnull
    public static IItemHandler getNetworkItemHandler(ILogisticsNetwork network) {
        return network.getNetworkItemHandler().initiliseTransfer();
    }

    public static void transferPlayerInventoryToNetwork(EntityPlayer player, ILogisticsNetwork network, Predicate<ItemStack> filter, int toTransfer) {
        ItemTransferHelper.doSimpleTransfer((Iterable)Lists.newArrayList((Object[])new IItemHandler[]{ItemTransferHelper.getMainInventoryHandler((EntityPlayer)player)}), (Iterable)Lists.newArrayList((Object[])new IItemHandler[]{ItemHelper.getNetworkItemHandler(network)}), filter, (int)toTransfer);
    }

    public static void transferNetworkInventoryToPlayer(EntityPlayer player, ILogisticsNetwork network, Predicate<ItemStack> filter, int toTransfer) {
        ItemTransferHelper.doSimpleTransfer((Iterable)Lists.newArrayList((Object[])new IItemHandler[]{ItemHelper.getNetworkItemHandler(network)}), (Iterable)Lists.newArrayList((Object[])new IItemHandler[]{ItemTransferHelper.getMainInventoryHandler((EntityPlayer)player)}), filter, (int)toTransfer);
    }

    public static ItemStack insertItemStack(ILogisticsNetwork network, ItemStack stack, int toTransfer) {
        return ItemHandlerHelper.insertItem((IItemHandler)ItemHelper.getNetworkItemHandler(network), (ItemStack)stack, (boolean)false);
    }

    public static ItemStack extractItemStack(ILogisticsNetwork network, Predicate<ItemStack> filter, int toTransfer) {
        return ItemTransferHelper.doExtract((Iterable)Lists.newArrayList((Object[])new IItemHandler[]{ItemHelper.getNetworkItemHandler(network)}), filter, (int)toTransfer);
    }

    public static long getItemCount(ItemStack stack, ILogisticsNetwork network) {
        if (network.isValid()) {
            ItemNetworkChannels channels = network.getNetworkChannels(ItemNetworkChannels.class);
            channels.updateLargeInventory = true;
            channels.updateAllChannels();
            channels.updateLargeInventory = false;
            ItemChangeableList updateList = new ItemChangeableList();
            for (Map.Entry entry : channels.channels.entrySet()) {
                AbstractChangeableList list = (AbstractChangeableList)entry.getValue();
                if (list.getList().isEmpty() || !(list instanceof ItemChangeableList)) continue;
                for (IMonitoredValue coordInfo : list.getList()) {
                    updateList.add(((MonitoredItemStack)coordInfo.getSaveableInfo()).copy());
                }
            }
            return updateList.getItemCount(stack);
        }
        return 0L;
    }

    @Deprecated
    public static StoredItemStack getEntityStack(EntityConnection connection, int slot) {
        if (connection.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)connection.entity;
            InventoryPlayer inv = player.field_71071_by;
            if (slot < inv.func_70302_i_()) {
                ItemStack stack = inv.func_70301_a(slot);
                return new StoredItemStack(stack);
            }
        }
        return null;
    }

    @Deprecated
    public static StoredItemStack getTileStack(BlockConnection connection, int slot) {
        TileEntity tile = connection.coords.getTileEntity();
        for (ITileInventoryProvider provider : MasterInfoRegistry.INSTANCE.inventoryProviders) {
            IItemHandler handler = provider.getHandler(tile, connection.face);
            if (handler == null) continue;
            return new StoredItemStack(handler.getStackInSlot(slot));
        }
        return null;
    }

    public static void onNetworkItemInteraction(IListReader reader, ILogisticsNetwork network, AbstractChangeableList<MonitoredItemStack> abstractChangeableList, EntityPlayer player, ItemStack selected, int button) {
        switch (button) {
            case 2: {
                if (selected != null) {
                    ItemHelper.transferNetworkInventoryToPlayer(player, network, IS -> StoredItemStack.isEqualStack((ItemStack)selected, (ItemStack)IS), 64);
                }
                return;
            }
            case 3: {
                ItemHelper.transferPlayerInventoryToNetwork(player, network, IS -> true, Integer.MAX_VALUE);
                return;
            }
            case 4: {
                ItemHelper.transferNetworkInventoryToPlayer(player, network, IS -> abstractChangeableList.values.stream().anyMatch(v -> ((MonitoredItemStack)v.getSaveableInfo()).getStoredStack().equalStack(IS)), Integer.MAX_VALUE);
                return;
            }
        }
        if (!player.field_71071_by.func_70445_o().func_190926_b()) {
            player.field_71071_by.func_70437_b(ItemHelper.insertItemStack(network, player.field_71071_by.func_70445_o(), 64));
            SonarCore.network.sendTo((IMessage)new PacketStackUpdate(player.field_71071_by.func_70445_o()), (EntityPlayerMP)player);
        } else if (player.field_71071_by.func_70445_o().func_190926_b() && selected != null) {
            player.field_71071_by.func_70437_b(ItemHelper.extractItemStack(network, IS -> StoredItemStack.isEqualStack((ItemStack)selected, (ItemStack)IS), 64));
            SonarCore.network.sendTo((IMessage)new PacketStackUpdate(player.field_71071_by.func_70445_o()), (EntityPlayerMP)player);
        }
    }
}

