/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.wireless.receivers;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.integration.multipart.TileSonarMultipart;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncNBTAbstract;
import sonar.core.network.sync.SyncNBTAbstractList;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.api.core.tiles.wireless.EnumWirelessConnectionState;
import sonar.logistics.api.core.tiles.wireless.EnumWirelessSecurity;
import sonar.logistics.api.core.tiles.wireless.IWirelessManager;
import sonar.logistics.api.core.tiles.wireless.emitters.ClientWirelessEmitter;
import sonar.logistics.api.core.tiles.wireless.emitters.IWirelessEmitter;
import sonar.logistics.api.core.tiles.wireless.receivers.IWirelessReceiver;
import sonar.logistics.base.guidance.errors.ErrorMessage;
import sonar.logistics.core.tiles.wireless.base.TileAbstractWireless;
import sonar.logistics.core.tiles.wireless.receivers.ContainerAbstractReceiver;

public abstract class TileAbstractReceiver<E extends IWirelessEmitter, R extends IWirelessReceiver>
extends TileAbstractWireless
implements IWirelessReceiver<E>,
IByteBufTile,
IFlexibleGui {
    public static final ErrorMessage[] validStates = new ErrorMessage[]{ErrorMessage.NO_NETWORK, ErrorMessage.NO_EMITTERS_CONNECTED, ErrorMessage.EMITTERS_OFFLINE};
    public SyncNBTAbstractList<ClientWirelessEmitter> clientEmitters = new SyncNBTAbstractList(ClientWirelessEmitter.class, 2);
    public SyncNBTAbstract<ClientWirelessEmitter> selectedEmitter = new SyncNBTAbstract(ClientWirelessEmitter.class, 4);

    public TileAbstractReceiver() {
        this.syncList.addParts(new IDirtyPart[]{this.clientEmitters, this.selectedEmitter});
    }

    public abstract IWirelessManager<E, R> getWirelessHandler();

    public void addEmitterFromClient(ClientWirelessEmitter emitter) {
        boolean found;
        E tile = this.getWirelessHandler().getEmitter(emitter.getIdentity());
        ClientWirelessEmitter cachedEmitter = this.getCachedEmitter(emitter.getIdentity());
        boolean bl = found = cachedEmitter != null;
        if (!found) {
            this.clientEmitters.addObject((INBTSyncable)emitter);
            this.onEmitterConnected((IWirelessEmitter)tile);
        } else {
            this.clientEmitters.removeObject((INBTSyncable)cachedEmitter);
            this.onEmitterDisconnected((IWirelessEmitter)tile);
        }
        this.sendSyncPacket();
    }

    public List<E> getEmitters() {
        ArrayList<E> emitters = new ArrayList<E>();
        for (ClientWirelessEmitter dataEmitter : this.clientEmitters.getObjects()) {
            E emitter = this.getWirelessHandler().getEmitter(dataEmitter.getIdentity());
            if (emitter == null || !emitter.canPlayerConnect(this.playerUUID.getUUID()).isConnected()) continue;
            emitters.add(emitter);
        }
        return emitters;
    }

    public ClientWirelessEmitter getCachedEmitter(int identity) {
        for (ClientWirelessEmitter entry : this.clientEmitters.getObjects()) {
            if (entry.getIdentity() != identity) continue;
            return entry;
        }
        return null;
    }

    @Override
    public void onEmitterSecurityChanged(E emitter, EnumWirelessSecurity oldSetting) {
        EnumWirelessConnectionState canConnect;
        EnumWirelessConnectionState wasConnected;
        if (this.canEmitterAccessReceiver((IWirelessEmitter)emitter).isConnected() && !(wasConnected = this.canReceiverAccessEmitter((IWirelessEmitter)emitter, oldSetting)).isMatching(canConnect = this.canReceiverAccessEmitter((IWirelessEmitter)emitter, emitter.getSecurity()))) {
            if (canConnect.isConnected()) {
                this.onEmitterConnected((IWirelessEmitter)emitter);
            } else {
                this.onEmitterDisconnected((IWirelessEmitter)emitter);
            }
        }
    }

    @Override
    public EnumWirelessConnectionState canEmitterAccessReceiver(IWirelessEmitter emitter) {
        return EnumWirelessConnectionState.fromBoolean(this.getCachedEmitter(emitter.getIdentity()) != null);
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new ContainerAbstractReceiver(this) : null;
    }

    public void onGuiOpened(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                SonarMultipartHelper.sendMultipartSyncToPlayer((TileSonarMultipart)this, (EntityPlayerMP)((EntityPlayerMP)player));
                this.getWirelessHandler().addViewer(player);
            }
        }
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.selectedEmitter.writeToBuf(buf);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.selectedEmitter.readFromBuf(buf);
                this.addEmitterFromClient(((ClientWirelessEmitter)this.selectedEmitter.getObject()).copy());
            }
        }
    }
}

