/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets;

import io.netty.buffer.ByteBuf;
import mcmultipart.api.multipart.IMultipartTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.PacketMultipart;
import sonar.core.network.PacketMultipartHandler;
import sonar.logistics.core.tiles.displays.gsi.storage.DisplayGSISaveHandler;
import sonar.logistics.core.tiles.displays.tiles.DisplayVectorHelper;
import sonar.logistics.core.tiles.displays.tiles.holographic.TileAdvancedHolographicDisplay;

public class PacketHolographicDisplayScaling
extends PacketMultipart {
    private Vec3d screenScale;
    private Vec3d screenRotation;
    private Vec3d screenOffset;
    private int colour;

    public PacketHolographicDisplayScaling() {
    }

    public PacketHolographicDisplayScaling(TileAdvancedHolographicDisplay display) {
        super(display.getSlotID(), display.func_174877_v());
        this.screenScale = display.getScreenScaling();
        this.screenRotation = display.getScreenRotation();
        this.screenOffset = display.getScreenOffset();
        this.colour = display.getScreenColour();
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        NBTTagCompound nbt = ByteBufUtils.readTag((ByteBuf)buf);
        this.screenScale = DisplayVectorHelper.readVec3d("scale", nbt, NBTHelper.SyncType.SAVE);
        this.screenRotation = DisplayVectorHelper.readVec3d("rotate", nbt, NBTHelper.SyncType.SAVE);
        this.screenOffset = DisplayVectorHelper.readVec3d("offset", nbt, NBTHelper.SyncType.SAVE);
        this.colour = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        NBTTagCompound nbt = new NBTTagCompound();
        DisplayVectorHelper.writeVec3d(this.screenScale, "scale", nbt, NBTHelper.SyncType.SAVE);
        DisplayVectorHelper.writeVec3d(this.screenRotation, "rotate", nbt, NBTHelper.SyncType.SAVE);
        DisplayVectorHelper.writeVec3d(this.screenOffset, "offset", nbt, NBTHelper.SyncType.SAVE);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt);
        buf.writeInt(this.colour);
    }

    public static class Handler
    extends PacketMultipartHandler<PacketHolographicDisplayScaling> {
        public IMessage processMessage(PacketHolographicDisplayScaling message, EntityPlayer player, World world, IMultipartTile part, MessageContext ctx) {
            if (ctx.side == Side.SERVER && part instanceof TileAdvancedHolographicDisplay) {
                SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> {
                    TileAdvancedHolographicDisplay display = (TileAdvancedHolographicDisplay)part;
                    display.screenScale = message.screenScale;
                    display.screenRotation = message.screenRotation;
                    display.screenOffset = message.screenOffset;
                    display.screenColour.setObject((Object)message.colour);
                    display.getGSI().updateScaling();
                    display.getGSI().sendInfoContainerPacket(DisplayGSISaveHandler.DisplayGSISavedData.ALL_DATA);
                    display.func_70296_d();
                    display.getGSI().getWatchers().forEach(watcher -> display.sendSyncPacket((EntityPlayer)watcher, NBTHelper.SyncType.SAVE));
                });
            }
            return null;
        }
    }
}

