/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets.gsi;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import sonar.core.SonarCore;
import sonar.logistics.base.ServerInfoHandler;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.gsi.packets.GSIElementPacketHelper;
import sonar.logistics.core.tiles.displays.info.elements.base.IDisplayElement;

public class PacketGSIElement
implements IMessage {
    public int gsiIdentity;
    public int elementIdentity;
    public NBTTagCompound clickTag;

    public PacketGSIElement() {
    }

    public PacketGSIElement(int gsiIdentity, int elementIdentity, NBTTagCompound clickTag) {
        this.gsiIdentity = gsiIdentity;
        this.elementIdentity = elementIdentity;
        this.clickTag = clickTag;
    }

    public void fromBytes(ByteBuf buf) {
        this.gsiIdentity = buf.readInt();
        this.elementIdentity = buf.readInt();
        this.clickTag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.gsiIdentity);
        buf.writeInt(this.elementIdentity);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.clickTag);
    }

    public static class Handler
    implements IMessageHandler<PacketGSIElement, IMessage> {
        public IMessage onMessage(PacketGSIElement message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> {
                    DisplayGSI gsi;
                    EntityPlayer player = SonarCore.proxy.getPlayerEntity(ctx);
                    if (player != null && (gsi = ServerInfoHandler.instance().getGSIMap().get(message.gsiIdentity)) != null) {
                        IDisplayElement e = gsi.getElementFromIdentity(message.elementIdentity);
                        GSIElementPacketHelper.handler.runGSIElementPacket(gsi, e, player, message.clickTag);
                    }
                });
            }
            return null;
        }
    }
}

