/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets.gsi;

import io.netty.buffer.ByteBuf;
import mcmultipart.api.multipart.IMultipartTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.PacketMultipart;
import sonar.core.network.PacketMultipartHandler;
import sonar.logistics.api.core.tiles.displays.tiles.IDisplay;
import sonar.logistics.api.core.tiles.displays.tiles.ISmallDisplay;
import sonar.logistics.base.ClientInfoHandler;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;

public class PacketGSIStandardDisplayValidate
extends PacketMultipart {
    public NBTTagCompound SAVE_TAG;
    public int GSI_IDENTITY = -1;

    public PacketGSIStandardDisplayValidate() {
    }

    public PacketGSIStandardDisplayValidate(TileAbstractDisplay display, DisplayGSI gsi) {
        super(display.getSlotID(), display.func_174877_v());
        this.GSI_IDENTITY = gsi.getDisplayGSIIdentity();
        this.SAVE_TAG = gsi.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.GSI_IDENTITY = buf.readInt();
        this.SAVE_TAG = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.GSI_IDENTITY);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.SAVE_TAG);
    }

    public static class Handler
    extends PacketMultipartHandler<PacketGSIStandardDisplayValidate> {
        public IMessage processMessage(PacketGSIStandardDisplayValidate message, EntityPlayer player, World world, IMultipartTile part, MessageContext ctx) {
            if (ctx.side == Side.CLIENT && part instanceof ISmallDisplay) {
                SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> {
                    ISmallDisplay display = (ISmallDisplay)part;
                    DisplayGSI gsi = display.getGSI();
                    if (gsi == null) {
                        gsi = new DisplayGSI(display, display.getActualWorld(), display.getInfoContainerID());
                        display.setGSI(gsi);
                    }
                    gsi.readData(message.SAVE_TAG, NBTHelper.SyncType.SAVE);
                    gsi.validate();
                });
            }
            return null;
        }

        public IMessage onFailure(PacketGSIStandardDisplayValidate message, EntityPlayer player, World world, MessageContext ctx) {
            SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> {
                IDisplay display = ClientInfoHandler.instance().displays_tile.get(message.GSI_IDENTITY);
                if (display != null) {
                    display.getGSI().readData(message.SAVE_TAG, NBTHelper.SyncType.SAVE);
                    display.getGSI().validate();
                } else {
                    ClientInfoHandler.instance().invalid_gsi.put(message.GSI_IDENTITY, message.SAVE_TAG);
                }
            });
            return null;
        }
    }
}

