/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.cover;

import codechicken.lib.colour.Colour;
import codechicken.lib.render.CCQuad;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import cofh.core.util.helpers.MathHelper;
import cofh.thermaldynamics.init.TDProps;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class CoverHoleRender {
    public static final CoverTransformer hollowDuct = CoverHoleRender.hollowCover(0.3125f);
    public static final CoverTransformer hollowDuctLarge = CoverHoleRender.hollowCover(0.28125f);
    public static final CoverTransformer hollowDuctTile = CoverHoleRender.hollowCover(0.25f);
    public static final CoverTransformer hollowDuctCryo = CoverHoleRender.octaCover(0.125f, 0.1812f);
    public static final CoverTransformer hollowDuctTransport = CoverHoleRender.octaCover(0.5f * (1.0f - TDProps.largeInnerModelScaling), 0.1812f);

    public static List<CCQuad> holify(List<CCQuad> quads, int side, CoverTransformer transformer) {
        return quads.stream().map(Quad::new).flatMap(quad -> quad.sliceStretchBake(side, transformer).stream()).collect(Collectors.toList());
    }

    public static CoverTransformer hollowCover(float w) {
        return new CoverTransformer(new TransformSquare(0.0f, w, 0.0f, 1.0f), new TransformSquare(1.0f - w, 1.0f, 0.0f, 1.0f), new TransformSquare(w, 1.0f - w, 0.0f, w), new TransformSquare(w, 1.0f - w, 1.0f - w, 1.0f));
    }

    public static CoverTransformer octaCover(float w, float k) {
        return new CoverTransformer(new TransformSquare(0.0f, w, 0.0f, 1.0f), new TransformSquare(1.0f - w, 1.0f, 0.0f, 1.0f), new TransformSquare(w, 1.0f - w, 0.0f, w), new TransformSquare(w, 1.0f - w, 1.0f - w, 1.0f), new TriTransformer(w, w + 0.5f - k, false, false), new TriTransformer(w, w + 0.5f - k, false, true), new TriTransformer(w, w + 0.5f - k, true, false), new TriTransformer(w, w + 0.5f - k, true, true));
    }

    public static CoverTransformer octaCover(float k) {
        return new CoverTransformer(new TriTransformer(0.0f, 0.5f - k, false, false), new TriTransformer(0.0f, 0.5f - k, false, true), new TriTransformer(0.0f, 0.5f - k, true, false), new TriTransformer(0.0f, 0.5f - k, true, true));
    }

    public static class TriTransformer
    implements ITransformer {
        float m;
        float k;
        boolean flipX;
        boolean flipY;

        public String toString() {
            return "TriTransformer{m=" + this.m + ", k=" + this.k + ", flipX=" + this.flipX + ", flipY=" + this.flipY + '}';
        }

        public TriTransformer(float m, float k, boolean flipX, boolean flipY) {
            this.m = m;
            this.k = k;
            this.flipX = flipX;
            this.flipY = flipY;
        }

        @Override
        public boolean shouldTransform(float dx, float dy) {
            if (this.flipX) {
                dx = 1.0f - dx;
            }
            if (this.flipY) {
                dy = 1.0f - dy;
            }
            return dx < this.m || dy < this.m || dx + dy > this.k;
        }

        @Override
        public float transformX(float dx, float dy) {
            if (this.flipX) {
                dx = 1.0f - dx;
            }
            if (dx < this.m) {
                return this.flipX ? 1.0f - this.m : this.m;
            }
            if (this.flipY) {
                dy = 1.0f - dy;
            }
            if (dy < this.m) {
                float d = MathHelper.clamp((float)dx, (float)this.m, (float)(this.k - this.m));
                return this.flipX ? 1.0f - d : d;
            }
            float d = this.k * dx / (dx + dy);
            return this.flipX ? 1.0f - d : d;
        }

        @Override
        public float transformY(float dx, float dy) {
            if (this.flipY) {
                dy = 1.0f - dy;
            }
            if (dy < this.m) {
                return this.flipY ? 1.0f - this.m : this.m;
            }
            if (this.flipX) {
                dx = 1.0f - dx;
            }
            if (dx < this.m) {
                float d = MathHelper.clamp((float)dy, (float)this.m, (float)(this.k - this.m));
                return this.flipY ? 1.0f - d : d;
            }
            float d = this.k * dy / (dy + dx);
            return this.flipY ? 1.0f - d : d;
        }
    }

    public static class TransformSquare
    implements ITransformer {
        float x0;
        float x1;
        float y0;
        float y1;

        public TransformSquare(float x0, float x1, float y0, float y1) {
            this.x0 = x0;
            this.x1 = x1;
            this.y0 = y0;
            this.y1 = y1;
        }

        @Override
        public boolean shouldTransform(float dx, float dy) {
            return dx < this.x0 || dx > this.x1 || dy < this.y0 || dy > this.y1;
        }

        @Override
        public float transformX(float dx, float dy) {
            return MathHelper.clamp((float)dx, (float)this.x0, (float)this.x1);
        }

        @Override
        public float transformY(float dx, float dy) {
            return MathHelper.clamp((float)dy, (float)this.y0, (float)this.y1);
        }

        public String toString() {
            return "TransformSquare{x0=" + this.x0 + ", x1=" + this.x1 + ", y0=" + this.y0 + ", y1=" + this.y1 + '}';
        }
    }

    public static interface ITransformer {
        public boolean shouldTransform(float var1, float var2);

        public float transformX(float var1, float var2);

        public float transformY(float var1, float var2);
    }

    public static class CoverTransformer {
        private ITransformer[] transformers;

        public CoverTransformer(ITransformer ... transformers) {
            this.transformers = transformers;
        }

        public ITransformer[] getTransformers() {
            return this.transformers;
        }
    }

    public static class Quad {
        protected CCQuad quad;

        public Quad(CCQuad quad) {
            this.quad = quad;
        }

        public List<CCQuad> sliceStretchBake(int side, CoverTransformer transformer) {
            float[][] uvTransform = this.getUVTransform(this.quad, side);
            ArrayList<CCQuad> quads = new ArrayList<CCQuad>();
            if (uvTransform == null) {
                quads.add(this.bake());
                return quads;
            }
            for (ITransformer trans : transformer.getTransformers()) {
                Quad slice = this.slice(side, trans, uvTransform);
                if (!slice.notEmpty()) continue;
                quads.add(slice.bake());
            }
            return quads;
        }

        private boolean notEmpty() {
            Vector3 a = this.quad.vertices[0].vec;
            int f = 0;
            boolean flagX = true;
            boolean flagY = true;
            boolean flagZ = true;
            for (int i = 1; i < 4; ++i) {
                Vector3 b = this.quad.vertices[i].vec;
                if (flagX && Math.abs(a.x - b.x) > (double)1.0E-4f) {
                    flagX = false;
                    f = (byte)(f + 1);
                }
                if (flagY && Math.abs(a.y - b.y) > (double)1.0E-4f) {
                    flagY = false;
                    f = (byte)(f + 1);
                }
                if (flagZ && Math.abs(a.z - b.z) > (double)1.0E-4f) {
                    flagZ = false;
                    f = (byte)(f + 1);
                }
                if (f <= true) continue;
                return true;
            }
            return false;
        }

        public Quad slice(int side, ITransformer transformer, float[][] uvTransform) {
            CCQuad v = this.quad.copy();
            int s = side >> 1;
            for (int i = 0; i < 4; ++i) {
                float dy;
                float dx;
                Vector3 vec = v.vertices[i].vec;
                if (s == 0) {
                    dx = (float)vec.x;
                    dy = (float)vec.z;
                } else if (s == 1) {
                    dx = (float)vec.x;
                    dy = (float)vec.y;
                } else {
                    dx = (float)vec.z;
                    dy = (float)vec.y;
                }
                if (!transformer.shouldTransform(dx, dy)) continue;
                float dx2 = transformer.transformX(dx, dy);
                float dy2 = transformer.transformY(dx, dy);
                if (s == 0) {
                    vec.x = dx2;
                    vec.z = dy2;
                } else if (s == 1) {
                    vec.x = dx2;
                    vec.y = dy2;
                } else {
                    vec.z = dx2;
                    vec.y = dy2;
                }
                if (uvTransform == null) continue;
                float[] newTex = new float[8];
                for (int j = 0; j < 8; ++j) {
                    newTex[j] = uvTransform[0][j] + uvTransform[1][j] * dx2 + uvTransform[2][j] * dy2;
                }
                v.vertices[i].uv.u = newTex[0];
                v.vertices[i].uv.v = newTex[1];
                v.colours[i].set((int)MathHelper.clamp((float)newTex[2], (float)0.0f, (float)255.0f), (int)MathHelper.clamp((float)newTex[3], (float)0.0f, (float)255.0f), (int)MathHelper.clamp((float)newTex[4], (float)0.0f, (float)255.0f), (int)MathHelper.clamp((float)newTex[5], (float)0.0f, (float)255.0f));
                v.lightMaps[i] = (int)MathHelper.clamp((float)newTex[6], (float)0.0f, (float)65535.0f) | (int)MathHelper.clamp((float)newTex[7], (float)0.0f, (float)65535.0f) << 16;
            }
            return new Quad(v);
        }

        public CCQuad bake() {
            return this.quad;
        }

        public float[][] getUVTransform(CCQuad quad, int side) {
            int s = side >> 1;
            float n = 0.0f;
            float sx = 0.0f;
            float sy = 0.0f;
            float sxy = 0.0f;
            float sxx = 0.0f;
            float syy = 0.0f;
            float[][] XY = new float[3][8];
            for (int v = 0; v < 4; ++v) {
                float dy;
                float dx;
                Vertex5 vert = quad.vertices[v];
                Colour colour = quad.colours[v];
                n += 1.0f;
                if (s == 0) {
                    dx = (float)vert.vec.x;
                    dy = (float)vert.vec.z;
                } else if (s == 1) {
                    dx = (float)vert.vec.x;
                    dy = (float)vert.vec.y;
                } else {
                    dx = (float)vert.vec.z;
                    dy = (float)vert.vec.y;
                }
                sx += dx;
                sy += dy;
                sxy += dx * dy;
                syy += dy * dy;
                sxx += dx * dx;
                float[] tex = new float[]{(float)vert.uv.u, (float)vert.uv.v, colour.r & 0xFF, colour.g & 0xFF, colour.b & 0xFF, colour.a & 0xFF, quad.lightMaps[v] & 0xFFFF, quad.lightMaps[v] >>> 16 & 0xFFFF};
                for (int j = 0; j < tex.length; ++j) {
                    float[] fArray = XY[0];
                    int n2 = j;
                    fArray[n2] = fArray[n2] + tex[j];
                    float[] fArray2 = XY[1];
                    int n3 = j;
                    fArray2[n3] = fArray2[n3] + tex[j] * dx;
                    float[] fArray3 = XY[2];
                    int n4 = j;
                    fArray3[n4] = fArray3[n4] + tex[j] * dy;
                }
            }
            float v = sxx * syy - sxy * sxy;
            float determinant = n * v - (sxx * sy * sy + syy * sx * sx) + 2.0f * (sxy * sx * sy);
            if (Math.abs(determinant) <= 1.0E-4f) {
                return null;
            }
            determinant = 1.0f / determinant;
            float cy_xy = (sxy * sy - syy * sx) * determinant;
            float cx_xy = (sxy * sx - sxx * sy) * determinant;
            float cx_y = (sx * sy - sxy * n) * determinant;
            float[][] XXI = new float[][]{{v * determinant, cy_xy, cx_xy}, {cy_xy, (syy * n - sy * sy) * determinant, cx_y}, {cx_xy, cx_y, (sxx * n - sx * sx) * determinant}};
            float[][] beta = new float[3][8];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 8; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        float[] fArray = beta[i];
                        int n5 = j;
                        fArray[n5] = fArray[n5] + XXI[i][k] * XY[k][j];
                    }
                }
            }
            return beta;
        }
    }
}

