/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.multiblock;

import java.util.Arrays;

public class Tracker {
    private static final byte MEMORY = 101;
    private static final double AVG_MULTIPLIER = 0.01;
    public static final short LIFESPAN = 3600;
    byte i = 0;
    short life = 0;
    final int[] mem = new int[101];
    final long[] memIn = new long[101];
    final long[] memOut = new long[101];

    public Tracker(int n) {
        Arrays.fill(this.mem, n);
    }

    public void newTick(int n) {
        this.i = (byte)(this.i + 1);
        this.life = (short)(this.life + 1);
        if (this.i >= 101) {
            this.i = 0;
        }
        this.mem[this.i] = n;
        this.memIn[this.i] = 0L;
        this.memOut[this.i] = 0L;
    }

    public void stuffIn(int n) {
        byte by = this.i;
        this.memIn[by] = this.memIn[by] + (long)n;
    }

    public void stuffOut(int n) {
        byte by = this.i;
        this.memOut[by] = this.memOut[by] + (long)n;
    }

    public double avgStuff() {
        double v = 0.0;
        for (int j = 0; j < this.mem.length; ++j) {
            if (this.i == j) continue;
            int m = this.mem[j];
            v += (double)m;
        }
        return v * 0.01;
    }

    public double avgStuffIn() {
        return this.getUnsignedLongAverage(this.memIn);
    }

    public double avgStuffOut() {
        return this.getUnsignedLongAverage(this.memOut);
    }

    public double getUnsignedLongAverage(long[] arr) {
        double v = 0.0;
        for (int j = 0; j < arr.length; ++j) {
            if (j == this.i) continue;
            long m = arr[j];
            if (m < 0L) {
                double dValue = m & Long.MAX_VALUE;
                v += (dValue += 9.223372036854776E18);
                continue;
            }
            v += (double)m;
        }
        return v * 0.01;
    }
}

