/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.container.slot;

import java.util.Collection;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.ItemUtils;
import net.blay09.mods.cookingforblockheads.container.slot.FakeSlot;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class FakeSlotCraftMatrix
extends FakeSlot {
    private static final float ITEM_SWITCH_TIME = 80.0f;
    private final NonNullList<ItemStack> visibleStacks = NonNullList.func_191196_a();
    private float visibleItemTime;
    private int visibleItemIndex;
    private boolean isLocked;
    private boolean available = true;

    public FakeSlotCraftMatrix(int slotId, int x, int y) {
        super(slotId, x, y);
    }

    public void setIngredient(@Nullable NonNullList<ItemStack> ingredients) {
        ItemStack prevLockStack = this.isLocked ? this.func_75211_c() : ItemStack.field_190927_a;
        this.visibleStacks.clear();
        if (ingredients != null) {
            for (ItemStack itemStack : ingredients) {
                if (itemStack.func_190926_b()) continue;
                if (itemStack.func_77952_i() == Short.MAX_VALUE) {
                    NonNullList subItems = NonNullList.func_191196_a();
                    CreativeTabs tab = itemStack.func_77973_b().func_77640_w();
                    if (tab != null) {
                        itemStack.func_77973_b().func_150895_a(tab, subItems);
                    }
                    this.visibleStacks.addAll((Collection)subItems);
                    continue;
                }
                itemStack.func_190920_e(1);
                this.visibleStacks.add((Object)itemStack);
            }
        }
        this.visibleItemTime = 0.0f;
        this.visibleItemIndex = !this.visibleStacks.isEmpty() ? this.field_75222_d % this.visibleStacks.size() : 0;
        this.isLocked = false;
        if (!prevLockStack.func_190926_b()) {
            for (int i = 0; i < this.visibleStacks.size(); ++i) {
                if (!ItemUtils.areItemStacksEqualWithWildcard((ItemStack)this.visibleStacks.get(i), prevLockStack)) continue;
                this.visibleItemIndex = i;
                this.isLocked = true;
            }
        }
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void updateSlot(float partialTicks) {
        if (!this.isLocked) {
            this.visibleItemTime += partialTicks;
            if (this.visibleItemTime >= 80.0f) {
                ++this.visibleItemIndex;
                if (this.visibleItemIndex >= this.visibleStacks.size()) {
                    this.visibleItemIndex = 0;
                }
                this.visibleItemTime = 0.0f;
            }
        }
    }

    @Override
    public ItemStack func_75211_c() {
        return this.visibleStacks.size() > 0 ? (ItemStack)this.visibleStacks.get(this.visibleItemIndex) : ItemStack.field_190927_a;
    }

    @Override
    public boolean func_75216_d() {
        return this.visibleStacks.size() > 0;
    }

    public boolean func_111238_b() {
        return this.visibleStacks.size() > 0;
    }

    public NonNullList<ItemStack> getVisibleStacks() {
        return this.visibleStacks;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean locked) {
        this.isLocked = locked;
    }

    public void scrollDisplayList(int i) {
        this.isLocked = true;
        this.visibleItemIndex += i;
        if (this.visibleItemIndex >= this.visibleStacks.size()) {
            this.visibleItemIndex = 0;
        } else if (this.visibleItemIndex < 0) {
            this.visibleItemIndex = this.visibleStacks.size() - 1;
        }
    }
}

