/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.common.storageformat;

import aroma1997.backup.common.storageformat.BasicBackupInfo;
import aroma1997.backup.common.storageformat.IBackupInfo;
import aroma1997.backup.common.storageformat.IBackupRestoreInfo;
import aroma1997.backup.common.storageformat.IBackupStats;
import aroma1997.backup.common.storageformat.IStorageFormat;
import aroma1997.backup.common.storageformat.StorageFormatRegistry;
import aroma1997.backup.common.util.Environment;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class IncrementalSupportingStorageFormat<I extends BasicBackupInfo>
implements IStorageFormat<IncrementalBackupInfo<I>> {
    private static final String incrementalInfoFile = "incremental.aromabackup";
    private final IStorageFormat<I> parent;

    public IncrementalSupportingStorageFormat(IStorageFormat<I> parent) {
        this.parent = parent;
    }

    @Override
    public List<IncrementalBackupInfo<I>> listBackups(File directory) throws IOException {
        List<I> parentList = this.parent.listBackups(directory);
        ArrayList<IncrementalBackupInfo<I>> ret = new ArrayList<IncrementalBackupInfo<I>>(parentList.size());
        for (BasicBackupInfo info : parentList) {
            ret.add(new IncrementalBackupInfo<BasicBackupInfo>(info, this));
        }
        return ret;
    }

    @Override
    public IncrementalBackupInfo<I> getBackupInfo(String identifier) throws IOException {
        BasicBackupInfo info = (BasicBackupInfo)this.parent.getBackupInfo(identifier);
        if (info == null || !info.isValid()) {
            return null;
        }
        return new IncrementalBackupInfo<BasicBackupInfo>(info, this);
    }

    @Override
    public IncrementalBackupInfo<I> createBackup(IBackupInfo parentBackup, File targetFile, Map<File, String> files, int compression, IBackupStats stats) throws IOException {
        Map<Object, Object> prevFileHashes;
        if (parentBackup == null || (IncrementalSupportingStorageFormat)parentBackup.getStorageFormat() != this) {
            prevFileHashes = Collections.emptyMap();
        } else {
            IncrementalBackupInfo parentInfo = (IncrementalBackupInfo)parentBackup;
            prevFileHashes = IncrementalSupportingStorageFormat.getFileHashes(((BasicBackupInfo)parentInfo.delegate).getStorageFormat(), parentInfo.delegate);
        }
        Map<String, String> newFileHashes = IncrementalSupportingStorageFormat.getFilesToBackup(files.entrySet());
        HashMap<File, String> toBackup = new HashMap<File, String>();
        if (prevFileHashes != null) {
            for (Map.Entry<File, String> e2 : files.entrySet()) {
                String inArchive = e2.getValue();
                String prevHash = (String)prevFileHashes.get(inArchive);
                String currentHash = newFileHashes.get(inArchive);
                if (prevHash != null && prevHash.equals(currentHash)) continue;
                toBackup.put(e2.getKey(), inArchive);
            }
        } else {
            toBackup.putAll(files);
        }
        toBackup.entrySet().removeIf(e -> ((String)e.getValue()).equals(incrementalInfoFile));
        File hashFile = new File(Environment.getEnv().getTmpDir("incrementalTmp"), incrementalInfoFile);
        IncrementalSupportingStorageFormat.writeFileHashes(newFileHashes, hashFile);
        toBackup.put(hashFile, hashFile.getName());
        BasicBackupInfo info = (BasicBackupInfo)this.parent.createBackup(parentBackup, targetFile, toBackup, compression, stats);
        hashFile.delete();
        IncrementalBackupInfo<BasicBackupInfo> ret = new IncrementalBackupInfo<BasicBackupInfo>(info, this);
        ret.setParentBackup(parentBackup);
        ((BasicBackupInfo)ret.delegate).save();
        assert (((BasicBackupInfo)ret.delegate).isValid());
        return ret;
    }

    private static Map<String, String> getFilesToBackup(Collection<Map.Entry<File, String>> files) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map.Entry<File, String> e : files) {
            File file = e.getKey();
            String path = e.getValue();
            if (!file.exists()) continue;
            try {
                ret.put(path, IncrementalSupportingStorageFormat.getHash(file));
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                Environment.getEnv().log("File " + file.getAbsolutePath() + " was scheduled to be added to a backup, but was missing.");
            }
        }
        return ret;
    }

    @Override
    public void restoreBackup(IncrementalBackupInfo<I> backup, final IBackupRestoreInfo target) throws IOException {
        IBackupInfo info;
        IBackupRestoreInfo actualRestoreInfo;
        final Map<String, String> fileHashes = IncrementalSupportingStorageFormat.getFileHashes(this.parent, backup.delegate);
        if (fileHashes == null) {
            actualRestoreInfo = new IBackupRestoreInfo(){

                @Override
                public int getExpectedRestoreFiles() {
                    return target.getExpectedRestoreFiles();
                }

                @Override
                public File getTargetLocation(String path) {
                    return path.equals(IncrementalSupportingStorageFormat.incrementalInfoFile) ? null : target.getTargetLocation(path);
                }
            };
        } else {
            fileHashes.remove(incrementalInfoFile);
            actualRestoreInfo = new IBackupRestoreInfo(){

                @Override
                public int getExpectedRestoreFiles() {
                    return Math.min(fileHashes.size(), target.getExpectedRestoreFiles());
                }

                @Override
                public File getTargetLocation(String path) {
                    if (fileHashes.remove(path) != null) {
                        return target.getTargetLocation(path);
                    }
                    return null;
                }
            };
        }
        this.parent.restoreBackup(backup.delegate, actualRestoreInfo);
        if (actualRestoreInfo.getExpectedRestoreFiles() > 0 && (info = backup.getParentBackup()) != null) {
            info.getStorageFormat().restoreBackup(info, actualRestoreInfo);
        }
    }

    @Override
    public String getFormatIdentifier() {
        return this.parent.getFormatIdentifier();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <I extends IBackupInfo> Map<String, String> getFileHashes(IStorageFormat<I> format, I info) throws IOException {
        assert (info.getStorageFormat() == format);
        final File target = new File(Environment.getEnv().getTmpDir("incrementalTmp"), "incrementalLast.aromabackup");
        format.restoreBackup(info, new IBackupRestoreInfo(){
            boolean found = false;

            @Override
            public int getExpectedRestoreFiles() {
                return this.found ? 0 : 1;
            }

            @Override
            public File getTargetLocation(String path) {
                if (IncrementalSupportingStorageFormat.incrementalInfoFile.equals(path)) {
                    this.found = true;
                    return target;
                }
                return null;
            }
        });
        try (FileInputStream fis = new FileInputStream(target);){
            Properties hashes = new Properties();
            hashes.load(fis);
            Properties properties = hashes;
            return properties;
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static void writeFileHashes(Map<String, String> map, File file) throws IOException {
        Properties properties = new Properties();
        for (Map.Entry<String, String> e : map.entrySet()) {
            properties.setProperty(e.getKey(), e.getValue());
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            properties.store(fos, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getHash(File file) throws FileNotFoundException {
        MessageDigest md;
        if (!file.exists()) throw new FileNotFoundException("Cannot get the hash of a nonexistant file" + file.getAbsolutePath());
        if (!file.isFile()) {
            throw new FileNotFoundException("Cannot get the hash of a nonexistant file" + file.getAbsolutePath());
        }
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] buffer = new byte[4096];
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            int len;
            while ((len = bis.read(buffer)) > 0) {
                md.update(buffer, 0, len);
            }
            byte[] hash = md.digest();
            bis.close();
            String string = IncrementalSupportingStorageFormat.getHexValue(hash);
            return string;
        }
        catch (IOException e) {
            return "";
        }
    }

    private static String getHexValue(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (byte b : data) {
            sb.append(String.format("%02X ", b));
        }
        return sb.toString();
    }

    public static class IncrementalBackupInfo<I extends BasicBackupInfo>
    implements IBackupInfo {
        final I delegate;
        private final IncrementalSupportingStorageFormat<I> parent;

        IncrementalBackupInfo(I delegate, IncrementalSupportingStorageFormat<I> parent) {
            this.delegate = delegate;
            this.parent = parent;
        }

        @Override
        public File getFile() {
            return ((BasicBackupInfo)this.delegate).getFile();
        }

        void setParentBackup(IBackupInfo info) {
            if (info == null) {
                ((BasicBackupInfo)this.delegate).getAdditionalProperties().remove("parent");
            } else {
                ((BasicBackupInfo)this.delegate).getAdditionalProperties().put("parent", info.getIdentifier());
            }
        }

        @Override
        public IBackupInfo getParentBackup() {
            String value = ((BasicBackupInfo)this.delegate).getAdditionalProperties().get("parent");
            if (value == null) {
                return null;
            }
            try {
                return StorageFormatRegistry.INSTANCE.getBackupInfo(value);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public IBackupStats getBackupStats() {
            return ((BasicBackupInfo)this.delegate).getBackupStats();
        }

        public IStorageFormat<IBackupInfo> getStorageFormat() {
            return this.parent;
        }

        @Override
        public String getIdentifier() {
            return this.delegate.getIdentifier();
        }

        @Override
        public void delete(File backupLocation) {
            ((BasicBackupInfo)this.delegate).delete(backupLocation);
        }
    }
}

