/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.corecompressions;

import aroma1997.backup.common.compression.CompressionHelper;
import aroma1997.backup.common.storageformat.BasicBackupInfo;
import aroma1997.backup.common.storageformat.IBackupInfo;
import aroma1997.backup.common.storageformat.IBackupRestoreInfo;
import aroma1997.backup.common.storageformat.IBackupStats;
import aroma1997.backup.common.storageformat.IStorageFormat;
import aroma1997.backup.common.util.IOHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;

public class FolderStorageFormat
implements IStorageFormat<BasicBackupInfo> {
    @Override
    public BasicBackupInfo getBackupInfo(String identifier) throws IOException {
        File file = new File(identifier);
        if (!file.exists() || !file.isDirectory()) {
            return null;
        }
        BasicBackupInfo info = new BasicBackupInfo(file, this);
        if (info.isValid()) {
            info.load();
            return info;
        }
        return null;
    }

    @Override
    public BasicBackupInfo createBackup(IBackupInfo parentBackup, File targetFile, Map<File, String> files, int compression, IBackupStats backupStats) throws IOException {
        if (targetFile.exists()) {
            throw new FileAlreadyExistsException(targetFile.getAbsolutePath() + " already exists.");
        }
        Files.createDirectories(targetFile.toPath(), new FileAttribute[0]);
        for (Map.Entry<File, String> e : files.entrySet()) {
            File current = new File(targetFile, e.getValue());
            if (current.exists()) {
                throw new FileAlreadyExistsException("The file " + current + " is supposed to be created during the backup, but already exists.");
            }
            if (e.getKey().isDirectory()) {
                Files.createDirectories(current.toPath(), new FileAttribute[0]);
                continue;
            }
            Files.createDirectories(current.getParentFile().toPath(), new FileAttribute[0]);
            FileInputStream is = new FileInputStream(e.getKey());
            Throwable throwable = null;
            try {
                FileOutputStream os = new FileOutputStream(current);
                Throwable throwable2 = null;
                try {
                    IOHelper.copy(is, os);
                    os.flush();
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (os == null) continue;
                    if (throwable2 != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    os.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                is.close();
            }
        }
        BasicBackupInfo info = new BasicBackupInfo(targetFile, this, backupStats);
        info.save();
        return info;
    }

    @Override
    public void restoreBackup(BasicBackupInfo backup, IBackupRestoreInfo target) throws IOException {
        File backupFile = backup.getFile();
        for (Map.Entry<File, String> e : CompressionHelper.listFiles(backupFile).entrySet()) {
            File targetFile = target.getTargetLocation(e.getValue());
            if (targetFile != null) {
                Files.createDirectories(targetFile.getParentFile().toPath(), new FileAttribute[0]);
                try (FileInputStream is = new FileInputStream(e.getKey());
                     FileOutputStream os = new FileOutputStream(targetFile);){
                    IOHelper.copy(is, os);
                    os.flush();
                }
            }
            if (target.getExpectedRestoreFiles() > 0) continue;
            break;
        }
    }

    @Override
    public String getFormatIdentifier() {
        return "folder";
    }
}

