/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.corecompressions.compression;

import aroma1997.backup.common.compression.CompressionHelper;
import aroma1997.backup.common.compression.ICompression;
import aroma1997.backup.common.util.IOHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipCompression
implements ICompression {
    public void addFileToZip(String path, File folder, ZipOutputStream zip) throws IOException {
        if (folder.isDirectory()) {
            this.addFolderToZip(path, folder, zip);
        } else {
            FileInputStream in = new FileInputStream(folder);
            zip.putNextEntry(new ZipEntry(path));
            IOHelper.copy(in, zip);
            in.close();
        }
    }

    public void addFolderToZip(String path, File folder, ZipOutputStream zip) throws IOException {
        for (File file : folder.listFiles()) {
            this.addFileToZip(CompressionHelper.appendFilename(path, folder.getName()), file, zip);
        }
    }

    @Override
    public void compress(OutputStream fos, Collection<Map.Entry<File, String>> files, int compression) throws IOException {
        ZipOutputStream zip = new ZipOutputStream(fos);
        zip.setLevel(compression);
        for (Map.Entry<File, String> e : files) {
            if (e.getKey().isFile()) {
                this.addFileToZip(e.getValue(), e.getKey(), zip);
                continue;
            }
            this.addFolderToZip(e.getValue(), e.getKey(), zip);
        }
        zip.flush();
        zip.close();
    }

    @Override
    public void decompress(InputStream is, Function<String, File> location) throws IOException {
        ZipEntry e;
        ZipInputStream zip = new ZipInputStream(is);
        while ((e = zip.getNextEntry()) != null) {
            File target = location.apply(e.getName());
            if (target == null) continue;
            if (e.isDirectory()) {
                Files.createDirectories(target.toPath(), new FileAttribute[0]);
                continue;
            }
            Files.createDirectories(target.getParentFile().toPath(), new FileAttribute[0]);
            FileOutputStream fos = new FileOutputStream(target);
            IOHelper.copy(zip, fos);
            fos.flush();
            fos.close();
        }
        zip.close();
    }
}

