/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.standalone.commands;

import aroma1997.backup.common.storageformat.IBackupInfo;
import aroma1997.backup.common.storageformat.StorageFormatRegistry;
import aroma1997.backup.common.util.IOHelper;
import aroma1997.backup.standalone.command.Command;
import aroma1997.backup.standalone.command.CommandException;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;

public class CommandRestoreBackup
extends Command {
    public CommandRestoreBackup() {
        super("restoreBackup", "restore");
    }

    @Override
    public String getDescr() {
        return this.getName() + " <source backup> <target dir>";
    }

    @Override
    public void execute(String[] args) throws CommandException {
        File target;
        IBackupInfo info;
        if (args.length != 2) {
            throw new CommandException("Invalid amount of arguments.");
        }
        try {
            info = StorageFormatRegistry.INSTANCE.getBackupInfo(args[0]);
            if (info == null) {
                throw new IllegalArgumentException("An invalid backup was specified.");
            }
        }
        catch (IOException e1) {
            IOHelper.printError("Could not check, if backup is valid. Aborting...");
            return;
        }
        File copyto = target = new File(args[1]);
        while (copyto.exists()) {
            copyto = new File(copyto.getAbsolutePath() + "_old");
        }
        try {
            if (target != copyto) {
                Files.move(target.toPath(), copyto.toPath(), new CopyOption[0]);
            }
            info.getStorageFormat().restoreBackup(info, path -> new File(target, path));
        }
        catch (IOException e) {
            IOHelper.printError("Failed to unpack backup.");
            e.printStackTrace();
        }
    }
}

