/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.inventories.handling;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import sonar.core.handlers.inventories.handling.ItemTransferHelper;

public class SimpleChangeableHandler
implements IItemHandler {
    final World world;
    final BlockPos pos;
    final EnumFacing face;
    TileEntity tile;
    IItemHandler handler;

    public SimpleChangeableHandler(World world, BlockPos pos, EnumFacing face) {
        this.world = world;
        this.pos = pos;
        this.face = face;
        this.handler = this.getItemHandler();
    }

    @Nullable
    public IItemHandler getItemHandler() {
        if (this.handler == null || this.tile == null || this.tile.func_145837_r()) {
            this.tile = this.world.func_175625_s(this.pos);
            if (this.tile != null && this.tile.hasCapability(ItemTransferHelper.ITEM_HANDLER_CAPABILITY, this.face)) {
                this.handler = (IItemHandler)this.tile.getCapability(ItemTransferHelper.ITEM_HANDLER_CAPABILITY, this.face);
            }
        }
        return this.handler;
    }

    public int getSlots() {
        return this.handler != null ? this.handler.getSlots() : 0;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.handler != null ? this.handler.getStackInSlot(slot) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.handler != null ? this.handler.insertItem(slot, stack, simulate) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.handler != null ? this.handler.extractItem(slot, amount, simulate) : ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return this.handler != null ? this.handler.getSlotLimit(slot) : 0;
    }

    public boolean isValid() {
        return this.getItemHandler() != null;
    }
}

