/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import sonar.core.SonarCore;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.SyncableList;

public class NBTHelper {
    public static boolean setTileEntityNBT(World worldIn, @Nullable EntityPlayer player, BlockPos pos, NBTTagCompound fakeTag) {
        ItemStack stack = new ItemStack(Blocks.field_150350_a, 1);
        stack.func_77978_p().func_74782_a("BlockEntityTag", (NBTBase)fakeTag);
        return ItemBlock.func_179224_a((World)worldIn, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
    }

    public static void readSyncParts(NBTTagCompound nbt, SyncType type, List<ISyncPart> syncableList) {
        for (ISyncPart part : syncableList) {
            if (part == null || !part.canSync(type)) continue;
            part.readData(nbt, type);
        }
    }

    public static void readSyncParts(NBTTagCompound nbt, SyncType type, SyncableList syncableList) {
        for (ISyncPart part : syncableList.getStandardSyncParts()) {
            if (part == null || !part.canSync(type)) continue;
            part.readData(nbt, type);
        }
    }

    public static NBTTagCompound writeSyncParts(NBTTagCompound nbt, SyncType type, List<ISyncPart> syncableList, boolean forceSync) {
        for (ISyncPart part : syncableList) {
            if (part == null || !forceSync && !type.mustSync() && !part.canSync(type)) continue;
            part.writeData(nbt, type);
        }
        return nbt;
    }

    public static NBTTagCompound writeSyncParts(NBTTagCompound nbt, SyncType type, SyncableList syncableList, boolean forceSync) {
        for (ISyncPart part : (ArrayList)syncableList.getSyncList(type).clone()) {
            if (part == null || !forceSync && !type.mustSync() && !part.canSync(type)) continue;
            part.writeData(nbt, type);
            syncableList.onPartSynced(part);
        }
        syncableList.onPartsSynced();
        return nbt;
    }

    public static ISyncPart getSyncPartByID(ArrayList<ISyncPart> parts, int id) {
        String tag = String.valueOf(id);
        for (ISyncPart part : parts) {
            if (part == null || !part.getTagName().equals(tag)) continue;
            return part;
        }
        return null;
    }

    @Nullable
    public static <T extends INBTSyncable> T instanceNBTSyncable(Class<T> classType, NBTTagCompound tag) {
        try {
            INBTSyncable obj = (INBTSyncable)classType.newInstance();
            obj.readData(tag, SyncType.SAVE);
            return (T)obj;
        }
        catch (IllegalAccessException | InstantiationException e) {
            SonarCore.logger.error("FAILED TO CREATE NEW INSTANCE OF " + classType.getSimpleName());
            return null;
        }
    }

    public static void writeFluidToBuf(FluidStack stack, ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)FluidRegistry.getFluidName((Fluid)stack.getFluid()));
        buf.writeInt(stack.amount);
        if (stack.tag != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)stack.tag);
        } else {
            buf.writeBoolean(false);
        }
    }

    public static FluidStack readFluidFromBuf(ByteBuf buf) {
        String fluidName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        if (fluidName == null || FluidRegistry.getFluid((String)fluidName) == null) {
            return null;
        }
        FluidStack stack = new FluidStack(FluidRegistry.getFluid((String)fluidName), buf.readInt());
        if (buf.readBoolean()) {
            stack.tag = ByteBufUtils.readTag((ByteBuf)buf);
        }
        return stack;
    }

    public static void writeTankInfo(FluidTankInfo tank, NBTTagCompound nbt) {
        tank.fluid.writeToNBT(nbt);
        nbt.func_74768_a("capacity", tank.capacity);
    }

    public static FluidTankInfo readTankInfo(NBTTagCompound nbt) {
        return new FluidTankInfo(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt), nbt.func_74762_e("capacity"));
    }

    public static NBTTagCompound writeDoubleArray(NBTTagCompound tag, double[] array, String tagName) {
        NBTTagList list = new NBTTagList();
        for (double d : array) {
            list.func_74742_a((NBTBase)new NBTTagDouble(d));
        }
        tag.func_74782_a(tagName, (NBTBase)list);
        return tag;
    }

    public static double[] readDoubleArray(NBTTagCompound tag, String tagName, int size) {
        NBTTagList list = tag.func_150295_c(tagName, 6);
        double[] array = new double[size];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            array[i] = list.func_150309_d(i);
        }
        return array;
    }

    public void getAndCheck(Object obj, NBTTagCompound tag, String key, boolean shouldCheck) {
        if (!shouldCheck || tag.func_74764_b(key)) {
            obj = NBTHelper.readNBTBase(tag, tag.func_74781_a(key).func_74732_a(), key);
        }
    }

    public static NBTTagCompound writeNBTBase(NBTTagCompound nbt, int type, Object object, String tagName) {
        if (object == null) {
            SonarCore.logger.error("NBT ERROR: Can't write NULL");
            return nbt;
        }
        if (tagName == null) {
            SonarCore.logger.error("NBT ERROR: Can't write with no TAG NAME");
            return nbt;
        }
        switch (type) {
            case 0: {
                nbt.func_74757_a(tagName, ((Boolean)object).booleanValue());
                break;
            }
            case 1: {
                nbt.func_74774_a(tagName, ((Byte)object).byteValue());
                break;
            }
            case 2: {
                nbt.func_74777_a(tagName, ((Short)object).shortValue());
                break;
            }
            case 3: {
                nbt.func_74768_a(tagName, ((Integer)object).intValue());
                break;
            }
            case 4: {
                nbt.func_74772_a(tagName, ((Long)object).longValue());
                break;
            }
            case 5: {
                nbt.func_74776_a(tagName, ((Float)object).floatValue());
                break;
            }
            case 6: {
                nbt.func_74780_a(tagName, ((Double)object).doubleValue());
                break;
            }
            case 7: {
                nbt.func_74773_a(tagName, (byte[])object);
                break;
            }
            case 8: {
                nbt.func_74778_a(tagName, (String)object);
                break;
            }
            case 9: {
                nbt.func_74782_a(tagName, (NBTBase)object);
                break;
            }
            case 10: {
                nbt.func_74782_a(tagName, (NBTBase)((NBTTagCompound)object));
                break;
            }
            case 11: {
                nbt.func_74783_a(tagName, (int[])object);
            }
        }
        return nbt;
    }

    public static Object readNBTBase(NBTTagCompound nbt, int type, String tagName) {
        switch (type) {
            case 0: {
                return nbt.func_74767_n(tagName);
            }
            case 1: {
                return nbt.func_74771_c(tagName);
            }
            case 2: {
                return nbt.func_74765_d(tagName);
            }
            case 3: {
                return nbt.func_74762_e(tagName);
            }
            case 4: {
                return nbt.func_74763_f(tagName);
            }
            case 5: {
                return Float.valueOf(nbt.func_74760_g(tagName));
            }
            case 6: {
                return nbt.func_74769_h(tagName);
            }
            case 7: {
                return nbt.func_74770_j(tagName);
            }
            case 8: {
                return nbt.func_74779_i(tagName);
            }
            case 10: {
                return nbt.func_74781_a(tagName);
            }
            case 11: {
                return nbt.func_74759_k(tagName);
            }
        }
        return null;
    }

    public static void writeBufBase(ByteBuf buf, int type, Object object, String tagName) {
        switch (type) {
            case 0: {
                buf.writeBoolean(((Boolean)object).booleanValue());
                return;
            }
            case 1: {
                buf.writeByte((int)((Byte)object).byteValue());
                return;
            }
            case 2: {
                buf.writeShort((int)((Short)object).shortValue());
                return;
            }
            case 3: {
                buf.writeInt(((Integer)object).intValue());
                return;
            }
            case 4: {
                buf.writeLong(((Long)object).longValue());
                return;
            }
            case 5: {
                buf.writeFloat(((Float)object).floatValue());
                return;
            }
            case 6: {
                buf.writeDouble(((Double)object).doubleValue());
                return;
            }
            case 7: {
                Byte[] byteArray = (Byte[])object;
                buf.writeInt(byteArray.length);
                for (Byte aByteArray : byteArray) {
                    buf.writeByte((int)aByteArray.byteValue());
                }
                return;
            }
            case 8: {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)object));
                return;
            }
            case 9: {
                ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)((NBTTagCompound)object));
                return;
            }
            case 10: {
                ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)((NBTTagCompound)object));
                return;
            }
            case 11: {
                Integer[] intArray = (Integer[])object;
                buf.writeInt(intArray.length);
                for (Integer anIntArray : intArray) {
                    buf.writeInt(anIntArray.intValue());
                }
                break;
            }
        }
    }

    public static Object readBufBase(ByteBuf buf, int type, String tagName) {
        switch (type) {
            case 0: {
                return buf.readBoolean();
            }
            case 1: {
                return buf.readByte();
            }
            case 2: {
                return buf.readShort();
            }
            case 3: {
                return buf.readInt();
            }
            case 4: {
                return buf.readLong();
            }
            case 5: {
                return Float.valueOf(buf.readFloat());
            }
            case 6: {
                return buf.readDouble();
            }
            case 7: {
                int byteArraySize = buf.readInt();
                byte[] byteArray = new byte[byteArraySize];
                for (int i = 0; i < byteArray.length; ++i) {
                    byteArray[i] = buf.readByte();
                }
                return byteArray;
            }
            case 8: {
                return ByteBufUtils.readUTF8String((ByteBuf)buf);
            }
            case 9: 
            case 10: {
                return ByteBufUtils.readTag((ByteBuf)buf);
            }
            case 11: {
                int intArraySize = buf.readInt();
                int[] intArray = new int[intArraySize];
                for (int i = 0; i < intArray.length; ++i) {
                    intArray[i] = buf.readInt();
                }
                return intArray;
            }
        }
        return null;
    }

    public static enum SyncType {
        SAVE(0),
        DROP(2),
        SPECIAL(3),
        PACKET(4),
        DEFAULT_SYNC(1),
        SYNC_OVERRIDE(1),
        NONE(5);

        private int type;

        private SyncType(int type) {
            this.type = type;
        }

        public int getSubType() {
            return this.type;
        }

        public boolean mustSync() {
            return this == SYNC_OVERRIDE || this == SAVE;
        }

        public boolean isType(SyncType ... types) {
            for (SyncType type : types) {
                if (type.type != this.type) continue;
                return true;
            }
            return false;
        }

        public static boolean isGivenType(SyncType current, SyncType ... types) {
            if (current == null) {
                return false;
            }
            for (SyncType type : types) {
                if (type.type != current.type) continue;
                return true;
            }
            return false;
        }
    }
}

