/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.recipes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import sonar.core.recipes.ISonarRecipeItem;
import sonar.core.recipes.ISonarRecipeObject;
import sonar.core.recipes.RecipeObjectType;

public class RecipeInterchangable
implements ISonarRecipeObject,
ISonarRecipeItem {
    public List<ISonarRecipeObject> validInputs;
    public List<Object> cachedObjects = new ArrayList<Object>();

    public RecipeInterchangable(List<ISonarRecipeObject> validInputs) {
        this.validInputs = validInputs;
        validInputs.forEach(input -> this.cachedObjects.add(input.getValue()));
    }

    @Override
    public Object getValue() {
        return this.cachedObjects;
    }

    @Override
    public boolean isNull() {
        return this.cachedObjects.isEmpty();
    }

    @Override
    public boolean matches(Object object, RecipeObjectType type) {
        for (ISonarRecipeObject recipeObject : this.validInputs) {
            if (!recipeObject.matches(object, type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getOutputStack() {
        ISonarRecipeObject obj = this.validInputs.get(0);
        if (obj instanceof ISonarRecipeItem) {
            return ((ISonarRecipeItem)((Object)obj)).getOutputStack();
        }
        for (Object object : this.cachedObjects) {
            if (!(object instanceof ItemStack)) continue;
            return (ItemStack)object;
        }
        return null;
    }

    @Override
    public List<ItemStack> getJEIValue() {
        ArrayList<ItemStack> values = new ArrayList<ItemStack>();
        this.validInputs.forEach(obj -> values.addAll(obj.getJEIValue()));
        return values;
    }

    @Override
    public int getStackSize() {
        return this.validInputs.get(0).getStackSize();
    }
}

