/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.ynot.oc;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import li.cil.oc.api.Network;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.SidedEnvironment;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import mcjty.lib.varia.WorldTools;
import mcjty.xnet.api.channels.IConnectorSettings;
import mcjty.xnet.api.channels.IControllerContext;
import mcjty.xnet.api.gui.IEditorGui;
import mcjty.xnet.api.gui.IndicatorIcon;
import mcjty.xnet.api.keys.SidedConsumer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import pl.asie.ynot.YNot;
import pl.asie.ynot.enums.OCNetworkMode;
import pl.asie.ynot.oc.OCConnectorSettings;
import pl.asie.ynot.traits.TraitedChannelSettings;

public class OCChannelSettings
extends TraitedChannelSettings {
    @CapabilityInject(value=Environment.class)
    private static Capability<Environment> ENVIRONMENT_CAPABILITY;
    @CapabilityInject(value=SidedEnvironment.class)
    private static Capability<SidedEnvironment> SIDED_ENVIRONMENT_CAPABILITY;
    Node channelNode = new DummyEnvironment(true).node();
    Map<SidedConsumer, NodeEntry> componentNodes = new LinkedHashMap<SidedConsumer, NodeEntry>();
    Map<SidedConsumer, NodeEntry> networkNodes = new LinkedHashMap<SidedConsumer, NodeEntry>();
    boolean shouldCleanCache = true;
    int ticker;

    private Node getNode(TileEntity tile, EnumFacing side) {
        if (tile == null) {
            return null;
        }
        if (tile.hasCapability(SIDED_ENVIRONMENT_CAPABILITY, side)) {
            return ((SidedEnvironment)tile.getCapability(SIDED_ENVIRONMENT_CAPABILITY, side)).sidedNode(side);
        }
        if (tile.hasCapability(ENVIRONMENT_CAPABILITY, side)) {
            return ((Environment)tile.getCapability(ENVIRONMENT_CAPABILITY, side)).node();
        }
        return null;
    }

    private void removeNotPresent(Map<SidedConsumer, NodeEntry> entries, Map<SidedConsumer, IConnectorSettings> connectors, Map<SidedConsumer, IConnectorSettings> routedConnectors) {
        Iterator<SidedConsumer> it = entries.keySet().iterator();
        while (it.hasNext()) {
            SidedConsumer consumer = it.next();
            if (connectors.containsKey(consumer) || routedConnectors.containsKey(consumer)) continue;
            entries.get(consumer).remove();
            it.remove();
        }
    }

    public void tick(int channel, IControllerContext context) {
        if (this.shouldCleanCache) {
            Map connectors = context.getConnectors(channel);
            Map routedConnectors = context.getRoutedConnectors(channel);
            this.removeNotPresent(this.componentNodes, connectors, routedConnectors);
            this.removeNotPresent(this.networkNodes, connectors, routedConnectors);
            World world = context.getControllerWorld();
            this.addNewConnectors(context, world, connectors);
            this.addNewConnectors(context, world, routedConnectors);
            this.ticker = 0;
            this.shouldCleanCache = false;
        }
        for (NodeEntry node : this.componentNodes.values()) {
            node.update(context.getControllerWorld(), context, this.ticker);
        }
        for (NodeEntry node : this.networkNodes.values()) {
            node.update(context.getControllerWorld(), context, this.ticker);
        }
        this.ticker = (this.ticker + 1) % 20;
    }

    private void addNewConnectors(IControllerContext context, World world, Map<SidedConsumer, IConnectorSettings> connectors) {
        for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
            OCConnectorSettings settings = (OCConnectorSettings)entry.getValue();
            NodeEntry oldEntry = this.componentNodes.get(entry.getKey());
            if (oldEntry == null) {
                oldEntry = this.networkNodes.get(entry.getKey());
            }
            if (oldEntry != null && (oldEntry.mode != settings.networkMode.get() || oldEntry.facing != settings.getFacing())) {
                oldEntry.remove();
                this.componentNodes.remove(entry.getKey());
                this.networkNodes.remove(entry.getKey());
                oldEntry = null;
            }
            if (oldEntry != null) continue;
            BlockPos pos = context.findConsumerPosition(entry.getKey().getConsumerId());
            NodeEntry nodeEntry = new NodeEntry(settings, pos = pos.func_177972_a(entry.getKey().getSide()), settings.getFacing(), (OCNetworkMode)((Object)settings.networkMode.get()));
            if (nodeEntry.mode.hasComponent()) {
                this.componentNodes.put(entry.getKey(), nodeEntry);
                continue;
            }
            this.networkNodes.put(entry.getKey(), nodeEntry);
        }
    }

    public void cleanCache() {
        this.shouldCleanCache = true;
    }

    public int getColors() {
        return 0;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(YNot.iconGui, 22, 0, 11, 10);
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public boolean isEnabled(String tag) {
        return true;
    }

    public void createGui(IEditorGui gui) {
    }

    class DummyEnvironment
    extends AbstractManagedEnvironment {
        boolean isChannel;

        DummyEnvironment(boolean isChannel) {
            this.isChannel = isChannel;
            this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).create());
        }

        public void onMessage(Message message) {
            super.onMessage(message);
            if (message.source().host() instanceof DummyEnvironment) {
                return;
            }
            if (message.name().equals("network.message")) {
                for (NodeEntry node : OCChannelSettings.this.networkNodes.values()) {
                    if (node.env == null || ((Object)((Object)this)).equals(node.env)) continue;
                    node.env.node().sendToReachable("network.message", message.data());
                }
                if (!this.isChannel) {
                    OCChannelSettings.this.channelNode.sendToReachable("network.message", message.data());
                }
            }
        }
    }

    public class NodeEntry {
        private final OCConnectorSettings settings;
        private final BlockPos pos;
        private final EnumFacing facing;
        private final OCNetworkMode mode;
        private TileEntity tile;
        private Node node;
        private Environment env;

        public NodeEntry(OCConnectorSettings settings, BlockPos pos, EnumFacing facing, OCNetworkMode mode) {
            this.settings = settings;
            this.pos = pos;
            this.facing = facing;
            this.mode = mode;
            if (mode.hasNetwork() && !mode.hasComponent()) {
                this.env = new DummyEnvironment(false);
            }
        }

        public void remove() {
            if (this.node != null) {
                if (this.mode.hasComponent()) {
                    this.node.disconnect(OCChannelSettings.this.channelNode);
                } else if (this.mode.hasNetwork()) {
                    this.node.disconnect(this.env.node());
                }
                this.tile = null;
                this.node = null;
            }
        }

        public void update(World world, IControllerContext context, int ticker) {
            TileEntity tile;
            Node node;
            if (this.node != null && (!context.matchColor(this.settings.getColorsMask()) || this.tile != null && this.tile.func_145837_r())) {
                this.remove();
            }
            if (this.tile == null && ticker == 0 && WorldTools.chunkLoaded((World)world, (BlockPos)this.pos) && context.matchColor(this.settings.getColorsMask()) && (node = OCChannelSettings.this.getNode(tile = world.func_175625_s(this.pos), this.facing)) != null) {
                this.tile = tile;
                this.node = node;
                if (this.mode.hasComponent()) {
                    if (!node.isNeighborOf(OCChannelSettings.this.channelNode)) {
                        node.connect(OCChannelSettings.this.channelNode);
                    }
                } else if (this.mode.hasNetwork() && this.env != null && !node.isNeighborOf(this.env.node())) {
                    node.connect(this.env.node());
                }
            }
        }
    }
}

