/*
 * Decompiled with CFR 0.152.
 */
package com.mattdahepic.autooredictconv.command.logic;

import com.mattdahepic.mdecore.command.AbstractCommand;
import com.mattdahepic.mdecore.command.ICommandLogic;
import com.mattdahepic.mdecore.helpers.ItemHelper;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreDictionary;

public class FindLogic
implements ICommandLogic {
    public static FindLogic instance = new FindLogic();

    public String getCommandName() {
        return "find";
    }

    public int getPermissionLevel() {
        return -1;
    }

    public String getCommandSyntax() {
        return "/odc find <ore name>";
    }

    public void handleCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You didn't specify a Ore Dictionary name! Use \"/odc help\" for help."));
            return;
        }
        NonNullList itemsUnderOreDict = OreDictionary.getOres((String)args[1]);
        if (!itemsUnderOreDict.isEmpty()) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Ore names under entry " + TextFormatting.AQUA + args[1] + TextFormatting.RESET + " are:"));
            for (ItemStack i : itemsUnderOreDict) {
                sender.func_145747_a((ITextComponent)new TextComponentString(ItemHelper.getNameFromItemStack((ItemStack)i)));
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("There are no items under this name or this name is not registered!"));
        }
    }

    public List<String> getTabCompletionList(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return args.length == 1 ? AbstractCommand.func_71530_a((String[])args, (String[])OreDictionary.getOreNames()) : null;
    }
}

