/*
 * Decompiled with CFR 0.152.
 */
package codechicken.asm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.objectweb.asm.ClassReader;

public class ClassHierarchyManager {
    private static boolean obfuscated = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") == false;
    public static HashMap<String, SuperCache> superclasses = new HashMap();
    private static LaunchClassLoader cl = Launch.classLoader;

    public static String toKey(String name) {
        if (obfuscated) {
            name = FMLDeobfuscatingRemapper.INSTANCE.map(name.replace('.', '/')).replace('/', '.');
        }
        return name;
    }

    public static String unKey(String name) {
        if (obfuscated) {
            name = FMLDeobfuscatingRemapper.INSTANCE.unmap(name.replace('.', '/')).replace('/', '.');
        }
        return name;
    }

    public static boolean classExtends(String name, String superclass) {
        if ((name = ClassHierarchyManager.toKey(name)).equals(superclass = ClassHierarchyManager.toKey(superclass))) {
            return true;
        }
        SuperCache cache = ClassHierarchyManager.declareClass(name);
        if (cache == null) {
            return false;
        }
        cache.flatten();
        return cache.parents.contains(superclass);
    }

    private static SuperCache declareClass(String name) {
        SuperCache cache = superclasses.get(name = ClassHierarchyManager.toKey(name));
        if (cache != null) {
            return cache;
        }
        try {
            byte[] bytes = cl.getClassBytes(ClassHierarchyManager.unKey(name));
            if (bytes != null) {
                cache = ClassHierarchyManager.declareASM(bytes);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cache != null) {
            return cache;
        }
        try {
            cache = ClassHierarchyManager.declareReflection(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return cache;
    }

    private static SuperCache declareReflection(String name) throws ClassNotFoundException {
        Class<?> aclass = Class.forName(name);
        SuperCache cache = ClassHierarchyManager.getOrCreateCache(name);
        if (aclass.isInterface()) {
            cache.superclass = "java.lang.Object";
        } else {
            if (name.equals("java.lang.Object")) {
                return cache;
            }
            cache.superclass = ClassHierarchyManager.toKey(aclass.getSuperclass().getName());
        }
        cache.add(cache.superclass);
        for (Class<?> iclass : aclass.getInterfaces()) {
            cache.add(ClassHierarchyManager.toKey(iclass.getName()));
        }
        return cache;
    }

    private static SuperCache declareASM(@Nonnull byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        String name = ClassHierarchyManager.toKey(reader.getClassName());
        SuperCache cache = ClassHierarchyManager.getOrCreateCache(name);
        cache.superclass = ClassHierarchyManager.toKey(reader.getSuperName().replace('/', '.'));
        cache.add(cache.superclass);
        for (String iclass : reader.getInterfaces()) {
            cache.add(ClassHierarchyManager.toKey(iclass.replace('/', '.')));
        }
        return cache;
    }

    public static void declare(@Nonnull String name, @Nonnull byte[] bytes) {
        if (!superclasses.containsKey(name)) {
            ClassHierarchyManager.declareASM(bytes);
        }
    }

    @Nonnull
    public static SuperCache getOrCreateCache(@Nonnull String name) {
        return superclasses.computeIfAbsent(name, k -> new SuperCache());
    }

    public static String getSuperClass(@Nonnull String name, boolean runtime) {
        SuperCache cache = ClassHierarchyManager.declareClass(name = ClassHierarchyManager.toKey(name));
        if (cache == null) {
            return "java.lang.Object";
        }
        cache.flatten();
        String s = cache.superclass;
        if (!runtime) {
            s = FMLDeobfuscatingRemapper.INSTANCE.unmap(s);
        }
        return s;
    }

    public static class SuperCache {
        String superclass;
        public HashSet<String> parents = new HashSet();
        private boolean flattened;

        public void add(String parent) {
            this.parents.add(parent);
        }

        public void flatten() {
            if (this.flattened) {
                return;
            }
            for (String s : new ArrayList<String>(this.parents)) {
                SuperCache c = ClassHierarchyManager.declareClass(s);
                if (c == null) continue;
                c.flatten();
                this.parents.addAll(c.parents);
            }
            this.flattened = true;
        }
    }
}

