/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.items;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;

public class Rope
implements IHaveConfig {
    public static final IntBounds LENGTH_BOUNDS = new IntBounds(Integer.valueOf(1), Integer.valueOf(80));
    public static final FloatBounds WIDTH_BOUNDS = new FloatBounds(Float.valueOf(1.0f), Float.valueOf(10.0f));
    public static final FloatBounds ELASTICITY_BOUNDS = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(0.95f));
    public static final FloatBounds MOTION_REDUCTION_BOUNDS = new FloatBounds(Float.valueOf(0.6f), Float.valueOf(1.0f));
    public final int segmentsAmount = 16;
    public final ColorARGB color;
    public final int maxLength;
    public final float width;
    public final float elasticity;
    protected final ForgeConfig config;

    public Rope(ForgeConfig config, int maxLength, float width, float elasticity, ColorARGB color) {
        this.config = config;
        this.color = ForgeConfig.getColorARGB((ForgeConfig)config, (String)this.getClassCategory(), (String)"color", (ColorARGB)color, (String)"Defines a color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb)");
        this.maxLength = ForgeConfig.getInt((ForgeConfig)config, (String)this.getClassCategory(), (String)"maxLength", (int)maxLength, (IntBounds)LENGTH_BOUNDS, (String)"Defines the maximal rope length.");
        this.width = ForgeConfig.getFloat((ForgeConfig)config, (String)this.getClassCategory(), (String)"width", (float)width, (FloatBounds)WIDTH_BOUNDS, (String)"Defines rope width.");
        this.elasticity = ForgeConfig.getFloat((ForgeConfig)config, (String)this.getClassCategory(), (String)"elasticity", (float)elasticity, (FloatBounds)ELASTICITY_BOUNDS, (String)"Defines how elastic the rope is.");
    }

    public float getMotionReduction() {
        if (this.elasticity == ELASTICITY_BOUNDS.getMin().floatValue()) {
            return MOTION_REDUCTION_BOUNDS.getMin().floatValue();
        }
        return CommonMath.Approx.down((float)this.elasticity, (FloatBounds)MOTION_REDUCTION_BOUNDS);
    }

    public float getTensionForce(float ropeLength, float realDistance) {
        float diff = realDistance - ropeLength;
        float ropeStrength = this.getRopeStrength();
        return diff * ropeStrength;
    }

    public float getRopeStrength() {
        return CommonMath.Approx.down((float)this.elasticity, (FloatBounds)ELASTICITY_BOUNDS);
    }

    public ForgeConfig getConfig() {
        return this.config;
    }

    public float getMinLength(@Nullable EntityLivingBase shooter, @Nullable Entity target) {
        float shooterSize = shooter != null ? Math.max(shooter.field_70130_N, shooter.field_70131_O) : 0.0f;
        float targetSize = target != null ? Math.max(target.field_70130_N, target.field_70131_O) : 0.0f;
        float minLength = shooterSize + targetSize;
        minLength = (float)((double)minLength / 2.0);
        return minLength;
    }

    public FloatBounds getLengthBounds(@Nullable EntityLivingBase shooter, @Nullable Entity target) {
        float minLength = this.getMinLength(shooter, target);
        return FloatBounds.from((Float)Float.valueOf(minLength), (Float)Float.valueOf(this.maxLength));
    }
}

