/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.block.model.VariantList;
import net.minecraft.client.renderer.block.model.WeightedBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.MultiModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class SimpleModel
implements IModel {
    private static final ModelResourceLocation MISSING = new ModelResourceLocation("builtin/missing", "missing");
    private final List<Variant> variants;
    private final ImmutableList<ResourceLocation> locations;
    private final ImmutableSet<ResourceLocation> textures;
    private final ImmutableList<IModel> models;
    private final IModelState defaultState;

    public SimpleModel(List<ResourceLocation> locations, List<IModel> models, List<Variant> variants, IModelState defaultState) {
        this.variants = variants;
        this.locations = ImmutableList.copyOf(locations);
        this.models = ImmutableList.copyOf(models);
        this.defaultState = defaultState;
        ImmutableSet.Builder texturesBuilder = ImmutableSet.builder();
        for (IModel model : models) {
            texturesBuilder.addAll((Iterable)model.getTextures());
        }
        this.textures = texturesBuilder.build();
    }

    public SimpleModel(ResourceLocation parent, VariantList variants) throws Exception {
        this.variants = variants.func_188114_a();
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList.Builder modelsBuilder = ImmutableList.builder();
        ImmutableList.Builder locationsBuilder = ImmutableList.builder();
        ImmutableSet.Builder texturesBuilder = ImmutableSet.builder();
        for (Variant variant : this.variants) {
            ResourceLocation loc = variant.func_188046_a();
            locationsBuilder.add((Object)loc);
            IModel model = loc.equals((Object)MISSING) ? ModelLoaderRegistry.getMissingModel() : ModelLoaderRegistry.getModel((ResourceLocation)loc);
            model = variant.process(model);
            for (ResourceLocation location : model.getDependencies()) {
                ModelLoaderRegistry.getModelOrMissing((ResourceLocation)location);
            }
            texturesBuilder.addAll((Iterable)model.getTextures());
            modelsBuilder.add((Object)model);
            builder.add((Object)Pair.of((Object)model, (Object)variant.getState()));
        }
        if (this.variants.size() == 0) {
            IModel missing = ModelLoaderRegistry.getMissingModel();
            modelsBuilder.add((Object)missing);
            builder.add((Object)Pair.of((Object)missing, (Object)TRSRTransformation.identity()));
        }
        this.defaultState = new MultiModelState(builder.build());
        this.locations = locationsBuilder.build();
        this.models = modelsBuilder.build();
        this.textures = texturesBuilder.build();
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.copyOf(this.locations);
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableSet.copyOf(this.textures);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        if (this.variants.size() == 1) {
            IModel model = (IModel)this.models.get(0);
            return model.bake(MultiModelState.getPartState((IModelState)state, (IModel)model, (int)0), format, bakedTextureGetter);
        }
        WeightedBakedModel.Builder builder = new WeightedBakedModel.Builder();
        for (int i = 0; i < this.variants.size(); ++i) {
            IModel model = (IModel)this.models.get(i);
            builder.func_177677_a(model.bake(MultiModelState.getPartState((IModelState)state, (IModel)model, (int)i), format, bakedTextureGetter), this.variants.get(i).func_188047_d());
        }
        return builder.func_177676_a();
    }

    public IModelState getDefaultState() {
        return this.defaultState;
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>();
        ArrayList<IModel> models = new ArrayList<IModel>();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Variant variant : this.variants) {
            IModel model;
            ResourceLocation loc = variant.func_188046_a();
            locations.add(loc);
            if (loc.equals((Object)MISSING)) {
                model = ModelLoaderRegistry.getMissingModel();
            } else {
                try {
                    model = ModelLoaderRegistry.getModel((ResourceLocation)loc);
                }
                catch (Exception e) {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            model = variant.process(model);
            for (ResourceLocation location : model.getDependencies()) {
                ModelLoaderRegistry.getModelOrMissing((ResourceLocation)location);
            }
            model = model.retexture(textures);
            models.add(model);
            builder.add((Object)Pair.of((Object)model, (Object)variant.getState()));
        }
        if (models.isEmpty()) {
            IModel missing = ModelLoaderRegistry.getMissingModel();
            models.add(missing);
            builder.add((Object)Pair.of((Object)missing, (Object)TRSRTransformation.identity()));
        }
        return new SimpleModel(locations, models, this.variants, (IModelState)new MultiModelState(builder.build()));
    }
}

