/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.ModuleCore;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.slots.SlotAnalyzer;
import forestry.core.gui.slots.SlotLockable;
import forestry.core.inventory.ItemInventoryAlyzer;
import forestry.core.utils.GeneticsUtil;
import forestry.modules.ModuleHelper;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ContainerAnalyzerProviderHelper {
    private final EntityPlayer player;
    private final ContainerForestry container;
    @Nullable
    private final ItemInventoryAlyzer alyzerInventory;
    private final int analyzerIndex;

    public ContainerAnalyzerProviderHelper(ContainerForestry container, InventoryPlayer playerInventory) {
        this.player = playerInventory.field_70458_d;
        this.container = container;
        ItemInventoryAlyzer alyzerInventory = null;
        int analyzerIndex = -1;
        for (int i = 0; i < playerInventory.func_70302_i_(); ++i) {
            ItemStack stack = playerInventory.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != ModuleCore.getItems().portableAlyzer) continue;
            analyzerIndex = i;
            alyzerInventory = new ItemInventoryAlyzer(playerInventory.field_70458_d, stack);
            Slot slot = container.func_75147_a((IInventory)playerInventory, i);
            if (!(slot instanceof SlotLockable)) break;
            SlotLockable lockable = (SlotLockable)slot;
            lockable.lock();
            break;
        }
        this.analyzerIndex = analyzerIndex;
        this.alyzerInventory = alyzerInventory;
        if (alyzerInventory != null) {
            container.func_75146_a(new SlotAnalyzer(alyzerInventory, 0, -110, 20));
        }
    }

    @Nullable
    public Slot getAnalyzerSlot() {
        if (this.alyzerInventory == null) {
            return null;
        }
        return this.container.func_75147_a(this.alyzerInventory, 0);
    }

    public void analyzeSpecimen(int selectedSlot) {
        ISpeciesRoot speciesRoot;
        if (selectedSlot < 0 || this.alyzerInventory == null) {
            return;
        }
        Slot specimenSlot = this.container.getForestrySlot(selectedSlot);
        ItemStack specimen = specimenSlot.func_75211_c();
        if (specimen.func_190926_b()) {
            return;
        }
        ItemStack convertedSpecimen = GeneticsUtil.convertToGeneticEquivalent(specimen);
        if (!ItemStack.func_77989_b((ItemStack)specimen, (ItemStack)convertedSpecimen)) {
            specimenSlot.func_75215_d(convertedSpecimen);
            specimen = convertedSpecimen;
        }
        if ((speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(specimen)) == null) {
            return;
        }
        IIndividual individual = speciesRoot.getMember(specimen);
        if (individual != null && !individual.isAnalyzed()) {
            boolean requiresEnergy = ModuleHelper.isEnabled("apiculture");
            ItemStack energyStack = this.alyzerInventory.func_70301_a(0);
            if (requiresEnergy && !ItemInventoryAlyzer.isAlyzingFuel(energyStack)) {
                return;
            }
            if (individual.analyze()) {
                IBreedingTracker breedingTracker = speciesRoot.getBreedingTracker(this.player.field_70170_p, this.player.func_146103_bH());
                breedingTracker.registerSpecies(individual.getGenome().getPrimary());
                breedingTracker.registerSpecies(individual.getGenome().getSecondary());
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                individual.writeToNBT(nbttagcompound);
                specimen = specimen.func_77946_l();
                specimen.func_77982_d(nbttagcompound);
                if (requiresEnergy) {
                    this.alyzerInventory.func_70298_a(0, 1);
                }
            }
            specimenSlot.func_75215_d(specimen);
        }
    }
}

