/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import forestry.api.gui.IGuiElement;
import forestry.api.gui.IWindowElement;
import forestry.api.gui.events.GuiEventDestination;
import forestry.core.gui.elements.layouts.VerticalLayout;
import forestry.core.gui.event.EventValueChanged;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class ElementList<V>
extends VerticalLayout {
    private final Map<V, IGuiElement> allOptions = new LinkedHashMap<V, IGuiElement>();
    private final Map<V, IGuiElement> visibleOptions = new LinkedHashMap<V, IGuiElement>();
    private final BiFunction<V, ElementList, IGuiElement> optionFactory;
    @Nullable
    private final V defaultValue;
    @Nullable
    private V value;
    @Nullable
    private Predicate<V> validator;

    public ElementList(int xPos, int yPos, int width, BiFunction<V, ElementList, IGuiElement> optionFactory, @Nullable V defaultValue) {
        super(xPos, yPos, width);
        this.optionFactory = optionFactory;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
    }

    @Nullable
    public V getCurrentValue() {
        return this.value;
    }

    public void setCurrentValue(@Nullable V value) {
        if (value == this.value) {
            return;
        }
        this.value = value;
        IWindowElement window = this.getWindow();
        window.postEvent(new EventValueChanged<V>(this, value), GuiEventDestination.ALL);
    }

    public void updateVisibleOptions() {
        this.elements.clear();
        this.setHeight(0);
        this.visibleOptions.clear();
        for (Map.Entry<V, IGuiElement> entry : this.allOptions.entrySet()) {
            if (this.isVisible(entry.getKey())) {
                this.add(entry.getValue());
                this.visibleOptions.put((IGuiElement)entry.getKey(), entry.getValue());
                continue;
            }
            entry.getValue().setYPosition(0);
        }
        this.setCurrentValue(this.getCurrentValue());
    }

    public boolean isVisible(V value) {
        return this.validator == null || this.validator.test(value);
    }

    public void setValidator(Predicate<V> validator) {
        if (this.validator != validator) {
            this.validator = validator;
            this.updateVisibleOptions();
        }
    }

    public int getIndexOf(@Nullable V value) {
        if (value == null) {
            return -1;
        }
        int index = 0;
        for (V option : this.getOptions()) {
            if (option.equals(value)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int getCurrentIndex() {
        return this.getIndexOf(this.getCurrentValue());
    }

    public void setIndex(int currentIndex) {
        int index = 0;
        for (V option : this.getOptions()) {
            if (index == currentIndex) {
                this.setCurrentValue(option);
                return;
            }
            ++index;
        }
        this.setCurrentValue(this.defaultValue);
    }

    public Collection<V> getOptions() {
        return this.visibleOptions.keySet();
    }

    public void setOptions(Collection<V> options) {
        this.clear();
        this.allOptions.clear();
        for (V option : options) {
            IGuiElement element = this.optionFactory.apply(option, this);
            this.allOptions.put((IGuiElement)option, element);
        }
        this.updateVisibleOptions();
    }
}

