/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements.layouts;

import forestry.api.gui.GuiElementAlignment;
import forestry.api.gui.IElementGroup;
import forestry.api.gui.IElementLayout;
import forestry.api.gui.IElementLayoutHelper;
import forestry.api.gui.IGuiElement;
import forestry.core.gui.elements.layouts.VerticalLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public class ElementLayoutHelper
implements IElementLayoutHelper {
    private final List<IElementLayout> layouts = new ArrayList<IElementLayout>();
    private final IElementLayoutHelper.LayoutFactory layoutFactory;
    private final int width;
    private final int height;
    private final IElementGroup parent;
    private int xOffset;
    private int yOffset;
    @Nullable
    private IElementLayout currentLayout;
    private boolean horizontal;

    public ElementLayoutHelper(IElementLayoutHelper.LayoutFactory layoutFactory, int width, int height, IElementGroup parent) {
        this.layoutFactory = layoutFactory;
        this.width = width;
        this.height = height;
        this.parent = parent;
    }

    @Override
    public boolean add(IGuiElement element) {
        if (this.currentLayout == null) {
            this.currentLayout = this.layoutFactory.createLayout(0, 0);
            this.layouts.add(this.currentLayout);
            this.horizontal = this.currentLayout instanceof VerticalLayout;
        }
        int groupWidth = this.currentLayout.getWidth();
        int groupHeight = this.currentLayout.getHeight();
        int eleWidth = element.getX() + element.getWidth();
        int eleHeight = element.getY() + element.getHeight();
        if (this.horizontal) {
            if (this.yOffset >= this.height) {
                if (this.width != 0 && this.xOffset > this.width) {
                    return false;
                }
                this.xOffset += this.currentLayout.getWidth();
                this.currentLayout = this.layoutFactory.createLayout(0, 0);
                this.layouts.add(this.currentLayout);
                groupHeight = this.currentLayout.getHeight();
            }
            this.yOffset = groupHeight += eleHeight;
        } else {
            if (this.xOffset >= this.width) {
                if (this.height != 0 && this.yOffset > this.height) {
                    return false;
                }
                this.yOffset += this.currentLayout.getHeight();
                this.currentLayout = this.layoutFactory.createLayout(0, 0);
                this.layouts.add(this.currentLayout);
                groupWidth = this.currentLayout.getWidth();
            }
            this.xOffset = groupWidth += eleWidth;
        }
        this.currentLayout.add(element);
        return true;
    }

    @Override
    public void finish(boolean center) {
        for (IGuiElement iGuiElement : this.layouts) {
            if (center) {
                iGuiElement.setAlign(GuiElementAlignment.TOP_CENTER);
            }
            this.parent.add(iGuiElement);
        }
        this.clear();
    }

    @Override
    public void clear() {
        this.layouts.clear();
        this.currentLayout = null;
        this.xOffset = 0;
        this.yOffset = 0;
    }

    @Override
    public Collection<IElementLayout> layouts() {
        return this.layouts;
    }
}

