/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.core.tiles.TileUtil;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class AdjacentTileCache {
    private static final int DELAY_MIN = 20;
    private static final int DELAY_MAX = 2400;
    private static final int DELAY_STEP = 2;
    private final Timer[] timer = new Timer[6];
    private final TileEntity[] cache = new TileEntity[6];
    private final int[] delay = new int[6];
    private final TileEntity source;
    private final Set<ICacheListener> listeners = new LinkedHashSet<ICacheListener>();

    public AdjacentTileCache(TileEntity tile) {
        this.source = tile;
        Arrays.fill(this.delay, 20);
        for (int i = 0; i < this.timer.length; ++i) {
            this.timer[i] = new Timer();
        }
    }

    public void addListener(ICacheListener listener) {
        this.listeners.add(listener);
    }

    @Nullable
    private TileEntity searchSide(EnumFacing side) {
        BlockPos pos;
        World world = this.source.func_145831_w();
        if (world.func_175667_e(pos = this.source.func_174877_v().func_177972_a(side)) && !world.func_175623_d(pos)) {
            return TileUtil.getTile((IBlockAccess)world, pos);
        }
        return null;
    }

    public void refresh() {
        for (EnumFacing side : EnumFacing.values()) {
            this.getTileOnSide(side);
        }
    }

    public void purge() {
        Arrays.fill(this.cache, null);
        Arrays.fill(this.delay, 20);
        for (Timer t : this.timer) {
            t.reset();
        }
        this.changed();
        for (ICacheListener listener : this.listeners) {
            listener.purge();
        }
    }

    public void onNeighborChange() {
        Arrays.fill(this.delay, 20);
    }

    protected void setTile(int side, @Nullable TileEntity tile) {
        if (this.cache[side] != tile) {
            this.cache[side] = tile;
            this.changed();
        }
    }

    private void changed() {
        for (ICacheListener listener : this.listeners) {
            listener.changed();
        }
    }

    private boolean areCoordinatesOnSide(EnumFacing side, TileEntity target) {
        return this.source.func_174877_v().func_177958_n() + side.func_82601_c() == target.func_174877_v().func_177958_n() && this.source.func_174877_v().func_177956_o() + side.func_96559_d() == target.func_174877_v().func_177956_o() && this.source.func_174877_v().func_177952_p() + side.func_82599_e() == target.func_174877_v().func_177952_p();
    }

    @Nullable
    public TileEntity getTileOnSide(EnumFacing side) {
        int s = side.ordinal();
        if (this.cache[s] != null) {
            if (this.cache[s].func_145837_r() || !this.areCoordinatesOnSide(side, this.cache[s])) {
                this.setTile(s, null);
            } else {
                return this.cache[s];
            }
        }
        if (this.timer[s].hasTriggered(this.source.func_145831_w(), this.delay[s])) {
            this.setTile(s, this.searchSide(side));
            if (this.cache[s] == null) {
                this.incrementDelay(s);
            } else {
                this.delay[s] = 20;
            }
        }
        return this.cache[s];
    }

    private void incrementDelay(int side) {
        int n = side;
        this.delay[n] = this.delay[n] + 2;
        if (this.delay[side] > 2400) {
            this.delay[side] = 2400;
        }
    }

    public TileEntity getSource() {
        return this.source;
    }

    private static class Timer {
        private long startTime = Long.MIN_VALUE;

        private Timer() {
        }

        public boolean hasTriggered(World world, int ticks) {
            long currentTime = world.func_82737_E();
            if (currentTime >= (long)ticks + this.startTime || this.startTime > currentTime) {
                this.startTime = currentTime;
                return true;
            }
            return false;
        }

        public void reset() {
            this.startTime = Long.MIN_VALUE;
        }
    }

    public static interface ICacheListener {
        public void changed();

        public void purge();
    }
}

