/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.core.utils.MigrationHelper;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class TileUtil {
    public static void registerTile(Class<? extends TileEntity> tileClass, String key) {
        GameRegistry.registerTileEntity(tileClass, (ResourceLocation)new ResourceLocation("forestry", key));
        MigrationHelper.addTileName(key);
    }

    public static boolean isUsableByPlayer(EntityPlayer player, TileEntity tile) {
        BlockPos pos = tile.func_174877_v();
        World world = tile.func_145831_w();
        return !tile.func_145837_r() && TileUtil.getTile((IBlockAccess)world, pos) == tile && player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0;
    }

    @Nullable
    public static TileEntity getTile(IBlockAccess world, BlockPos pos) {
        if (world instanceof ChunkCache) {
            ChunkCache chunkCache = (ChunkCache)world;
            return chunkCache.func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK);
        }
        return world.func_175625_s(pos);
    }

    @Nullable
    public static <T> T getTile(IBlockAccess world, BlockPos pos, Class<T> tileClass) {
        TileEntity tileEntity = TileUtil.getTile(world, pos);
        if (tileClass.isInstance(tileEntity)) {
            return tileClass.cast(tileEntity);
        }
        return null;
    }

    @Nullable
    public static <T, R> R getResultFromTile(IBlockAccess world, BlockPos pos, Class<T> tileClass, ITileGetResult<T, R> tileGetResult) {
        T tile = TileUtil.getTile(world, pos, tileClass);
        if (tile != null) {
            return tileGetResult.getResult(tile);
        }
        return null;
    }

    public static <T> void actOnTile(IBlockAccess world, BlockPos pos, Class<T> tileClass, ITileAction<T> tileAction) {
        T tile = TileUtil.getTile(world, pos, tileClass);
        if (tile != null) {
            tileAction.actOnTile(tile);
        }
    }

    @Nullable
    public static IItemHandler getInventoryFromTile(@Nullable TileEntity tile, @Nullable EnumFacing side) {
        if (tile == null) {
            return null;
        }
        if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        }
        if (tile instanceof ISidedInventory) {
            return new SidedInvWrapper((ISidedInventory)tile, side);
        }
        if (tile instanceof IInventory) {
            return new InvWrapper((IInventory)tile);
        }
        return null;
    }

    @Nullable
    public static <T> T getInterface(World world, BlockPos pos, Capability<T> capability, @Nullable EnumFacing facing) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null || !tileEntity.hasCapability(capability, facing)) {
            return null;
        }
        return (T)tileEntity.getCapability(capability, facing);
    }

    public static interface ITileAction<T> {
        public void actOnTile(T var1);
    }

    public static interface ITileGetResult<T, R> {
        @Nullable
        public R getResult(T var1);
    }
}

