/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUItemBlock;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxMimic;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.MutableModel;
import com.rwtema.extrautils2.backend.model.PassthruModelItemBlock;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.tile.TileCreativeHarvest;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.blockaccess.BlockAccessMimic;
import com.rwtema.extrautils2.utils.datastructures.ThreadLocalBoolean;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCreativeHarvest
extends XUBlock {
    BoxModel base = new BoxModel(new Box(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f));

    @Override
    public void registerTextures() {
        Textures.register("creative_harvestable");
        this.base = new BoxModel(new Box(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f).setTexture("creative_harvestable"));
    }

    public IBlockState getMimicState(IBlockAccess world, BlockPos pos, boolean returnNull) {
        IBlockState value;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCreativeHarvest && (value = ((TileCreativeHarvest)tile).mimicState.value) != null && value.func_177230_c() != this) {
            return value;
        }
        if (returnNull) {
            return null;
        }
        return this.func_176223_P();
    }

    @Override
    @Nonnull
    public BoxModel getWorldModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        IBlockState mimicState = this.getMimicState(world, pos, true);
        if (mimicState != null) {
            if (mimicState.func_177230_c() == this) {
                return this.base;
            }
            BlockAccessMimic blockAccessMimic = new BlockAccessMimic(world, pos, mimicState);
            AxisAlignedBB bb = mimicState.func_185900_c((IBlockAccess)blockAccessMimic, pos);
            if (bb != field_185505_j) {
                return new BoxModel(new Box((float)bb.field_72340_a, (float)bb.field_72338_b, (float)bb.field_72339_c, (float)bb.field_72336_d, (float)bb.field_72337_e, (float)bb.field_72334_f));
            }
        }
        return this.base;
    }

    @Override
    public BoxModel getRenderModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        IBlockState value;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCreativeHarvest && (value = ((TileCreativeHarvest)tile).mimicState.value) != null && value.func_177230_c() != this) {
            BoxModel model = new BoxModel();
            model.add(new BoxMimic(world, pos, value));
            return model;
        }
        return super.getRenderModel(world, pos, state);
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BoxModel getInventoryModel(@Nullable ItemStack item) {
        return this.base;
    }

    @Override
    public MutableModel createInventoryMutableModel() {
        return super.createInventoryMutableModel();
    }

    @Override
    public EnumActionResult hasEffect(ItemStack stack) {
        NBTTagCompound tag;
        if (stack.func_77942_o() && (tag = stack.func_77978_p()) != null && tag.func_150297_b("creative_block", 10)) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBakedModel createItemBlockPassThruModel(XUItemBlock item) {
        return new PassthruModelItemBlock(item){
            ItemOverrideList list;
            {
                this.list = new ItemOverrideList((List)ImmutableList.of()){
                    ThreadLocalBoolean avoidRecursion;
                    {
                        this.avoidRecursion = new ThreadLocalBoolean(false);
                    }

                    @Nonnull
                    public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                        NBTTagCompound tag;
                        if (!stack.func_77942_o() || (tag = stack.func_77978_p()) == null || !tag.func_150297_b("display_stack", 10)) {
                            return overrideList.handleItemState(originalModel, stack, world, entity);
                        }
                        NBTTagCompound display_stack = tag.func_74775_l("display_stack");
                        ItemStack duplicate = StackHelper.deserializeSafe(display_stack);
                        if (StackHelper.isNull(duplicate) || ((Boolean)this.avoidRecursion.get()).booleanValue()) {
                            return overrideList.handleItemState(originalModel, stack, world, entity);
                        }
                        this.avoidRecursion.set(true);
                        IBakedModel duplicateModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(duplicate);
                        IBakedModel finalModel = duplicateModel.func_188617_f().handleItemState(duplicateModel, duplicate, world, entity);
                        this.avoidRecursion.set(false);
                        return finalModel;
                    }
                };
            }

            @Override
            @Nonnull
            public ItemOverrideList func_188617_f() {
                return this.list;
            }
        };
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileCreativeHarvest();
    }

    @Override
    public void func_180657_a(@Nonnull World worldIn, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, TileEntity te, ItemStack stack) {
        IBlockState mimicState = this.getMimicState((IBlockAccess)worldIn, pos, false);
        mimicState.func_177230_c().func_180657_a(worldIn, player, pos, mimicState, null, stack);
    }

    public float func_149638_a(Entity exploder) {
        return 1.0E8f;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        if (player.field_71075_bZ.field_75098_d) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        return true;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        IBlockState mimicState = this.getMimicState((IBlockAccess)worldIn, pos, true);
        if (mimicState != null) {
            return mimicState.func_185887_b(worldIn, pos);
        }
        return super.func_176195_g(blockState, worldIn, pos);
    }

    public float func_180647_a(IBlockState state, @Nonnull EntityPlayer player, @Nonnull World worldIn, @Nonnull BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileCreativeHarvest) {
            IBlockState mimicState = ((TileCreativeHarvest)tile).mimicState.value;
            boolean pickupable = ((TileCreativeHarvest)tile).pickupable.value;
            if (mimicState != null) {
                float v;
                try {
                    worldIn.func_180501_a(pos, mimicState, 0);
                    v = mimicState.func_185903_a(player, worldIn, pos);
                    worldIn.func_180501_a(pos, this.func_176223_P(), 0);
                    ((TileCreativeHarvest)Objects.requireNonNull(worldIn.func_175625_s((BlockPos)pos))).mimicState.value = mimicState;
                    ((TileCreativeHarvest)Objects.requireNonNull(worldIn.func_175625_s((BlockPos)pos))).pickupable.value = pickupable;
                }
                catch (RuntimeException err) {
                    worldIn.func_180501_a(pos, this.func_176223_P(), 0);
                    TileEntity tileEntity = worldIn.func_175625_s(pos);
                    if (tileEntity instanceof TileCreativeHarvest) {
                        ((TileCreativeHarvest)tileEntity).mimicState.value = mimicState;
                        ((TileCreativeHarvest)tileEntity).pickupable.value = pickupable;
                    }
                    throw err;
                }
                return v;
            }
        }
        return super.func_180647_a(state, player, worldIn, pos);
    }

    public boolean canHarvestBlock(IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        IBlockState mimicState = this.getMimicState(world, pos, true);
        if (mimicState == null) {
            return super.canHarvestBlock(world, pos, player);
        }
        BlockAccessMimic blockAccessMimic = new BlockAccessMimic();
        blockAccessMimic.setBase(world);
        blockAccessMimic.myPos = pos;
        blockAccessMimic.state = mimicState;
        return ForgeHooks.canHarvestBlock((Block)mimicState.func_177230_c(), (EntityPlayer)player, (IBlockAccess)blockAccessMimic, (BlockPos)pos);
    }

    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        IBlockState mimicState = this.getMimicState((IBlockAccess)worldObj, blockPosition, true);
        if (mimicState != null) {
            worldObj.func_175739_a(EnumParticleTypes.BLOCK_DUST, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, numberOfParticles, 0.0, 0.0, 0.0, (double)0.15f, new int[]{Block.func_176210_f((IBlockState)mimicState)});
            return true;
        }
        return super.addLandingEffects(state, worldObj, blockPosition, iblockstate, entity, numberOfParticles);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        BlockPos pos = target.func_178782_a();
        IBlockState mimicState = this.getMimicState((IBlockAccess)worldObj, pos, true);
        if (mimicState != null) {
            this.addBlockHitEffects(pos, target.field_178784_b, mimicState, worldObj);
            return true;
        }
        return super.addHitEffects(state, worldObj, target, manager);
    }

    @SideOnly(value=Side.CLIENT)
    public void addBlockHitEffects(BlockPos pos, EnumFacing side, IBlockState iblockstate, World world) {
        if (iblockstate.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
            int i = pos.func_177958_n();
            int j = pos.func_177956_o();
            int k = pos.func_177952_p();
            float f = 0.1f;
            AxisAlignedBB axisalignedbb = iblockstate.func_185900_c((IBlockAccess)world, pos);
            double d0 = (double)i + world.field_73012_v.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
            double d1 = (double)j + world.field_73012_v.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
            double d2 = (double)k + world.field_73012_v.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
            if (side == EnumFacing.DOWN) {
                d1 = (double)j + axisalignedbb.field_72338_b - (double)0.1f;
            }
            if (side == EnumFacing.UP) {
                d1 = (double)j + axisalignedbb.field_72337_e + (double)0.1f;
            }
            if (side == EnumFacing.NORTH) {
                d2 = (double)k + axisalignedbb.field_72339_c - (double)0.1f;
            }
            if (side == EnumFacing.SOUTH) {
                d2 = (double)k + axisalignedbb.field_72334_f + (double)0.1f;
            }
            if (side == EnumFacing.WEST) {
                d0 = (double)i + axisalignedbb.field_72340_a - (double)0.1f;
            }
            if (side == EnumFacing.EAST) {
                d0 = (double)i + axisalignedbb.field_72336_d + (double)0.1f;
            }
            Minecraft.func_71410_x().field_71452_i.func_78873_a(this.createDiggingParticle(pos, iblockstate, world, d0, d1, d2, 0.0, 0.0, 0.0).func_70543_e(0.2f).func_70541_f(0.6f));
        }
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public ParticleDigging createDiggingParticle(BlockPos pos, IBlockState iblockstate, World world, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn) {
        return ((ParticleDigging)new ParticleDigging.Factory().func_178902_a(0, world, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, new int[]{Block.func_176210_f((IBlockState)iblockstate)})).func_174846_a(pos);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        IBlockState mimicState = this.getMimicState((IBlockAccess)world, pos, true);
        if (mimicState != null) {
            this.addBlockDestroyEffects(pos, mimicState, world);
            return true;
        }
        return super.addDestroyEffects(world, pos, manager);
    }

    @SideOnly(value=Side.CLIENT)
    public void addBlockDestroyEffects(BlockPos pos, IBlockState state, World world) {
        BlockAccessMimic mimicWorld = new BlockAccessMimic();
        mimicWorld.setBase((IBlockAccess)world);
        mimicWorld.myPos = pos;
        mimicWorld.state = state;
        state = state.func_185899_b((IBlockAccess)mimicWorld, pos);
        for (int j = 0; j < 4; ++j) {
            for (int k = 0; k < 4; ++k) {
                for (int l = 0; l < 4; ++l) {
                    double d0 = (double)pos.func_177958_n() + ((double)j + 0.5) / 4.0;
                    double d1 = (double)pos.func_177956_o() + ((double)k + 0.5) / 4.0;
                    double d2 = (double)pos.func_177952_p() + ((double)l + 0.5) / 4.0;
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)this.createDiggingParticle(pos, state, world, d0, d1, d2, d0 - (double)pos.func_177958_n() - 0.5, d1 - (double)pos.func_177956_o() - 0.5, d2 - (double)pos.func_177952_p() - 0.5));
                }
            }
        }
    }

    @Override
    @Nonnull
    public String getOverrideStackDisplayName(ItemStack stack, String name) {
        NBTTagCompound tag;
        if (!stack.func_77942_o() || (tag = stack.func_77978_p()) == null || !tag.func_150297_b("display_stack", 10)) {
            return name;
        }
        NBTTagCompound display_stack = tag.func_74775_l("display_stack");
        ItemStack duplicate = StackHelper.deserializeSafe(display_stack);
        if (StackHelper.isNull(duplicate)) {
            return name;
        }
        return Lang.translateArgs("%s (Infinite)", duplicate.func_82833_r());
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        NBTTagCompound tag;
        if (!stack.func_77942_o() || (tag = stack.func_77978_p()) == null || !tag.func_150297_b("display_stack", 10)) {
            return;
        }
        NBTTagCompound display_stack = tag.func_74775_l("display_stack");
        ItemStack duplicate = StackHelper.deserializeSafe(display_stack);
        if (StackHelper.isNull(duplicate)) {
            return;
        }
        tooltip.add(Lang.translate("Can be mined infinitely without being destroyed."));
        tooltip.add(Lang.translate("Shift-right-click with an empty hand to pick up."));
    }

    @Override
    public boolean canRenderInLayer(IBlockState state, @Nonnull BlockRenderLayer layer) {
        return true;
    }
}

