/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.quarry;

import com.rwtema.extrautils2.backend.ClientRunnable;
import com.rwtema.extrautils2.network.NetworkHandler;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.network.XUPacketServerToClient;
import com.rwtema.extrautils2.power.energy.XUEnergyStorage;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileClock
extends TilePower
implements ITickable {
    public static final long DAY_LENGTH = 24000L;
    public NBTSerializable.NBTBoolean powered = this.registerNBT("powered", new NBTSerializable.NBTBoolean(false));
    public NBTSerializable.NBTBoolean moving = this.registerNBT("moving", new NBTSerializable.NBTBoolean(false));
    public NBTSerializable.Int targetTime = this.registerNBT("target_time", new NBTSerializable.Int(-1));
    public XUEnergyStorage energy = this.registerNBT("energy", new XUEnergyStorage(1000000));
    int SPEED = 288;

    @Override
    public void onPowerChanged() {
    }

    @Override
    public float getPower() {
        return 0.0f;
    }

    public void func_73660_a() {
        if (this.moving.value) {
            // empty if block
        }
    }

    @Override
    public void addToDescriptionPacket(XUPacketBuffer packet) {
        this.powered.writeToPacket(packet);
        this.moving.writeToPacket(packet);
        this.targetTime.writeToPacket(packet);
    }

    @Override
    public void handleDescriptionPacket(XUPacketBuffer packet) {
        this.powered.readFromPacket(packet);
        this.moving.readFromPacket(packet);
        this.targetTime.readFromPacket(packet);
    }

    @Override
    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        super.onNeighborBlockChange(worldIn, pos, state, neighborBlock);
        this.powered.value = worldIn.func_175687_A(pos) > 0;
    }

    @NetworkHandler.XUPacket
    public static class TimeHandlerPacket
    extends XUPacketServerToClient {
        @Override
        public void writeData() throws Exception {
        }

        @Override
        public void readData(EntityPlayer player) {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Runnable doStuffClient() {
            return new ClientRunnable(){

                @Override
                @SideOnly(value=Side.CLIENT)
                public void run() {
                }
            };
        }
    }

    public static class TimeHandler {
        WeakHashMap<World, Ticker> data = new WeakHashMap();

        private class Ticker {
            private Ticker() {
            }
        }
    }
}

