/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.datastructures;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.utils.datastructures.IPacketSerializable;
import com.rwtema.extrautils2.utils.datastructures.ISimpleBitSet;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemHandlerHelper;

public class NBTSerializable {
    public static NBTPrimitive getLowestNeeded(int value) {
        byte byteVal = (byte)value;
        if (value == byteVal) {
            return new NBTTagByte(byteVal);
        }
        short shortVal = (short)value;
        if (value == shortVal) {
            return new NBTTagShort(shortVal);
        }
        return new NBTTagInt(value);
    }

    public static NBTPrimitive getLowestNeeded(long value) {
        byte byteVal = (byte)value;
        if (value == (long)byteVal) {
            return new NBTTagByte(byteVal);
        }
        short shortVal = (short)value;
        if (value == (long)shortVal) {
            return new NBTTagShort(shortVal);
        }
        int intVal = (int)value;
        if (value == (long)intVal) {
            return new NBTTagInt(intVal);
        }
        return new NBTTagLong(value);
    }

    public static NBTTagCompound saveData(NBTTagCompound compound, Map<String, INBTSerializable> nbtHandlers) {
        nbtHandlers.forEach((key, value) -> compound.func_74782_a(key, value.serializeNBT()));
        return compound;
    }

    public static void loadData(NBTTagCompound compound, Map<String, INBTSerializable> nbtHandlers) {
        nbtHandlers.forEach((key, value) -> {
            NBTBase tag;
            if (compound.func_74764_b(key) && (tag = compound.func_74781_a(key)) != null) {
                value.deserializeNBT(tag);
            }
        });
    }

    public static class NBTUUID
    implements INBTSerializable<NBTTagString>,
    IPacketSerializable {
        public UUID value = null;

        public NBTTagString serializeNBT() {
            return new NBTTagString(this.value.toString());
        }

        public void deserializeNBT(NBTTagString nbt) {
            this.value = UUID.fromString(nbt.func_150285_a_());
        }

        @Override
        public void writeToPacket(XUPacketBuffer t) {
            t.writeString(this.value.toString());
        }

        @Override
        public void readFromPacket(XUPacketBuffer t) {
            this.value = UUID.fromString(t.readString());
        }
    }

    public static class NBTEnumIntMap<T extends Enum<T>>
    implements INBTSerializable<NBTTagList> {
        public final TObjectIntHashMap<T> map = new TObjectIntHashMap(10, 0.5f, 0);
        private final Class<T> clazz;

        public NBTEnumIntMap(Class<T> clazz) {
            this.clazz = clazz;
        }

        public NBTTagList serializeNBT() {
            NBTTagList list = new NBTTagList();
            this.map.forEachEntry((a, b) -> {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74778_a("value", a.name());
                compound.func_74768_a("amount", b);
                list.func_74742_a((NBTBase)compound);
                return true;
            });
            return list;
        }

        public void deserializeNBT(NBTTagList list) {
            this.map.clear();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                T value = Enum.valueOf(this.clazz, compound.func_74779_i("value"));
                int amount = compound.func_74762_e("amount");
                this.map.put(value, amount);
            }
        }
    }

    public static final class NBTChunkPos
    implements INBTSerializable<NBTTagLong>,
    IPacketSerializable {
        public int x;
        public int z;

        public NBTChunkPos() {
        }

        public NBTChunkPos(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NBTChunkPos that = (NBTChunkPos)o;
            return this.x == that.x && this.z == that.z;
        }

        public int hashCode() {
            int result = this.x;
            result = 31 * result + this.z;
            return result;
        }

        public NBTTagLong serializeNBT() {
            long c = (long)this.x << 32 | (long)this.z & 0xFFFFFFFFL;
            return new NBTTagLong(c);
        }

        public void deserializeNBT(NBTTagLong nbt) {
            long c = nbt.func_150291_c();
            this.x = (int)(c >> 32);
            this.z = (int)c;
        }

        @Override
        public void writeToPacket(XUPacketBuffer t) {
            long c = (long)this.x << 32 | (long)this.z & 0xFFFFFFFFL;
            t.writeLong(c);
        }

        @Override
        public void readFromPacket(XUPacketBuffer t) {
            long c = t.readLong();
            this.x = (int)(c >> 32);
            this.z = (int)c;
        }
    }

    public static final class NBTBlockState
    implements INBTSerializable<NBTTagCompound>,
    IPacketSerializable {
        @Nullable
        public IBlockState value;

        @Nullable
        public static IBlockState getBlockState(ResourceLocation location, int meta) {
            Block block;
            if (Block.field_149771_c.func_148742_b().contains(location)) {
                block = (Block)Block.field_149771_c.func_82594_a((Object)location);
            } else {
                location = new ResourceLocation(location.func_110624_b().toLowerCase(Locale.ENGLISH), location.func_110623_a().toLowerCase(Locale.ENGLISH));
                if (Block.field_149771_c.func_148742_b().contains(location)) {
                    block = (Block)Block.field_149771_c.func_82594_a((Object)location);
                } else {
                    return null;
                }
            }
            return block.func_176203_a(meta);
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            if (this.value != null) {
                ResourceLocation nameForObject = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.value.func_177230_c());
                nbt.func_74778_a("block", nameForObject.toString());
                nbt.func_74768_a("meta", this.value.func_177230_c().func_176201_c(this.value));
            }
            return nbt;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            if (!nbt.func_150297_b("block", 8)) {
                this.value = null;
            } else {
                ResourceLocation location = new ResourceLocation(nbt.func_74779_i("block"));
                int meta = nbt.func_74762_e("meta");
                this.value = NBTBlockState.getBlockState(location, meta);
            }
        }

        @Override
        public void writeToPacket(XUPacketBuffer t) {
            t.writeNBT(this.serializeNBT());
        }

        @Override
        public void readFromPacket(XUPacketBuffer t) {
            NBTTagCompound nbt = t.readNBT();
            if (nbt == null) {
                this.value = null;
            } else {
                this.deserializeNBT(nbt);
            }
        }
    }

    public static class NBTCollectionSerializable<E extends INBTSerializable<? extends NBTBase>, C extends Collection<E>>
    implements INBTSerializable<NBTTagList> {
        public final C collection;
        private final Supplier<E> blankVersionSupplier;

        public NBTCollectionSerializable(C collection, Supplier<E> blankVersionSupplier) {
            this.collection = collection;
            this.blankVersionSupplier = blankVersionSupplier;
        }

        public NBTTagList serializeNBT() {
            NBTTagList list = new NBTTagList();
            for (INBTSerializable e : this.collection) {
                NBTBase t = e.serializeNBT();
                list.func_74742_a(t);
            }
            return list;
        }

        public void deserializeNBT(NBTTagList nbt) {
            this.collection.clear();
            int n = nbt.func_74745_c();
            for (int i = 0; i < n; ++i) {
                INBTSerializable e = (INBTSerializable)this.blankVersionSupplier.get();
                NBTBase base = nbt.func_179238_g(i);
                e.deserializeNBT(base);
                this.collection.add((INBTSerializable)e);
            }
        }
    }

    public static class NBTCollection<E, C extends Collection<E>, T extends NBTBase>
    implements INBTSerializable<NBTTagList> {
        public final C collection;
        public final Function<E, T> serializer;
        public final Function<T, E> deserializer;

        public NBTCollection(C collection, Function<E, T> serializer, Function<T, E> deserializer) {
            this.collection = collection;
            this.serializer = serializer;
            this.deserializer = deserializer;
        }

        public NBTTagList serializeNBT() {
            NBTTagList list = new NBTTagList();
            for (Object e : this.collection) {
                list.func_74742_a((NBTBase)this.serializer.apply(e));
            }
            return list;
        }

        public void deserializeNBT(NBTTagList nbt) {
            this.collection.clear();
            for (int i = 0; i < nbt.func_74745_c(); ++i) {
                NBTBase base = nbt.func_179238_g(i);
                E e = this.deserializer.apply(base);
                this.collection.add(e);
            }
        }
    }

    public static class NBTMutableBlockPos
    extends BlockPos.MutableBlockPos
    implements INBTSerializable<NBTTagLong>,
    IPacketSerializable {
        public NBTMutableBlockPos() {
        }

        public NBTMutableBlockPos(BlockPos pos) {
            super(pos);
        }

        public NBTMutableBlockPos(int x_, int y_, int z_) {
            super(x_, y_, z_);
        }

        public NBTTagLong serializeNBT() {
            return new NBTTagLong(this.func_177986_g());
        }

        public void deserializeNBT(NBTTagLong nbt) {
            this.func_189533_g((Vec3i)BlockPos.func_177969_a((long)nbt.func_150291_c()));
        }

        public void setPosX(int x) {
            this.field_177997_b = x;
        }

        public void setPosY(int y) {
            this.field_177998_c = y;
        }

        public void setPosZ(int z) {
            this.field_177996_d = z;
        }

        @Override
        public void writeToPacket(XUPacketBuffer t) {
            t.writeBlockPos((BlockPos)this);
        }

        @Override
        public void readFromPacket(XUPacketBuffer t) {
            this.func_189533_g((Vec3i)t.readBlockPos());
        }
    }

    public static abstract class NBTObject<V, V_NBT extends NBTBase>
    implements INBTSerializable<V_NBT> {
        public V value;

        public NBTObject(V value) {
            this.value = value;
        }

        public V_NBT serializeNBT() {
            return this.serialize(this.value);
        }

        protected abstract V_NBT serialize(V var1);

        public void deserializeNBT(V_NBT nbt) {
            this.value = this.deserialize(nbt);
        }

        protected abstract V deserialize(V_NBT var1);
    }

    public static class Vec
    implements INBTSerializable<NBTTagCompound>,
    IPacketSerializable {
        public double x;
        public double y;
        public double z;

        public void set(Vec3d vec) {
            this.x = vec.field_72450_a;
            this.y = vec.field_72448_b;
            this.z = vec.field_72449_c;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74780_a("x", this.x);
            tag.func_74780_a("y", this.y);
            tag.func_74780_a("z", this.z);
            return tag;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.x = nbt.func_74769_h("x");
            this.y = nbt.func_74769_h("y");
            this.z = nbt.func_74769_h("z");
        }

        @Override
        public void writeToPacket(XUPacketBuffer buffer) {
            buffer.writeDouble(this.x);
            buffer.writeDouble(this.y);
            buffer.writeDouble(this.z);
        }

        @Override
        public void readFromPacket(XUPacketBuffer buffer) {
            this.x = buffer.readDouble();
            this.y = buffer.readDouble();
            this.z = buffer.readDouble();
        }
    }

    public static class NBTArrayListSerializable<V, V_NBT extends NBTBase>
    implements INBTSerializable<NBTTagList> {
        public final ArrayList<V> list = new ArrayList();
        private final Function<V, V_NBT> serializer;
        private final Function<V_NBT, V> deserializer;

        public NBTArrayListSerializable(Function<V, V_NBT> serializer, Function<V_NBT, V> deserializer) {
            this.serializer = serializer;
            this.deserializer = deserializer;
        }

        public NBTTagList serializeNBT() {
            NBTTagList nbtTagList = new NBTTagList();
            for (V v : this.list) {
                nbtTagList.func_74742_a((NBTBase)this.serializer.apply(v));
            }
            return nbtTagList;
        }

        public void deserializeNBT(NBTTagList nbt) {
            this.list.clear();
            for (int i = 0; i < nbt.func_74745_c(); ++i) {
                this.list.add(this.deserializer.apply(nbt.func_179238_g(i)));
            }
        }
    }

    public static class NBTImmutableListSerializable<V extends INBTSerializable<V_NBT>, V_NBT extends NBTBase>
    implements INBTSerializable<NBTTagList> {
        final ImmutableList<V> list;

        public NBTImmutableListSerializable(ImmutableList<V> list) {
            this.list = list;
        }

        public NBTTagList serializeNBT() {
            NBTTagList nbtTagList = new NBTTagList();
            for (INBTSerializable v : this.list) {
                nbtTagList.func_74742_a(v.serializeNBT());
            }
            return null;
        }

        public void deserializeNBT(NBTTagList nbt) {
            for (int i = 0; i < this.list.size(); ++i) {
                ((INBTSerializable)this.list.get(i)).deserializeNBT(nbt.func_179238_g(i));
            }
        }
    }

    public static class NBTIntArray
    implements INBTSerializable<NBTTagIntArray> {
        @Nonnull
        public int[] array;

        public NBTIntArray(@Nonnull int[] array) {
            this.array = array;
        }

        public NBTTagIntArray serializeNBT() {
            return new NBTTagIntArray(this.array);
        }

        public void deserializeNBT(NBTTagIntArray nbt) {
            this.array = nbt.func_150302_c();
        }
    }

    public static class NBTByteArray
    implements INBTSerializable<NBTTagByteArray> {
        @Nonnull
        public byte[] array;

        public NBTByteArray(@Nonnull byte[] array) {
            this.array = array;
        }

        public NBTTagByteArray serializeNBT() {
            return new NBTTagByteArray(this.array);
        }

        public void deserializeNBT(NBTTagByteArray nbt) {
            this.array = nbt.func_150292_c();
        }
    }

    public static class NBTResourceLocationSerializable
    implements INBTSerializable<NBTTagString>,
    IPacketSerializable {
        ResourceLocation location;

        public NBTResourceLocationSerializable(ResourceLocation location) {
            this.location = location;
        }

        @Nonnull
        public static NBTTagString serialize(ResourceLocation location) {
            return location != null ? new NBTTagString(location.toString()) : new NBTTagString();
        }

        @Nullable
        public static ResourceLocation deserialize(NBTTagString nbt) {
            String s = nbt.func_150285_a_();
            return !s.isEmpty() ? new ResourceLocation(s) : null;
        }

        public NBTTagString serializeNBT() {
            return NBTResourceLocationSerializable.serialize(this.location);
        }

        public void deserializeNBT(NBTTagString nbt) {
            this.location = NBTResourceLocationSerializable.deserialize(nbt);
        }

        @Override
        public void writeToPacket(XUPacketBuffer t) {
            t.writeString(this.location.toString());
        }

        @Override
        public void readFromPacket(XUPacketBuffer t) {
            this.location = new ResourceLocation(t.readString());
        }
    }

    public static class HashMapSerializable<K, V, V_NBT extends NBTBase>
    implements INBTSerializable<NBTTagCompound> {
        public final HashMap<K, V> map = new HashMap();
        private final Function<V, V_NBT> val_serializer;
        private final Function<V_NBT, V> val_deserializer;
        private final Function<K, String> key_serializer;
        private final Function<String, K> key_deserializer;

        public HashMapSerializable(Function<K, String> key_serializer, Function<String, K> key_deserializer, Function<V, V_NBT> val_serializer, Function<V_NBT, V> val_deserializer) {
            this.val_serializer = val_serializer;
            this.val_deserializer = val_deserializer;
            this.key_serializer = key_serializer;
            this.key_deserializer = key_deserializer;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            for (Map.Entry<K, V> entry2 : this.map.entrySet()) {
                nbt.func_74782_a(this.key_serializer.apply(entry2.getKey()), (NBTBase)this.val_serializer.apply(entry2.getValue()));
            }
            return nbt;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.map.clear();
            for (String s : nbt.func_150296_c()) {
                this.map.put(this.key_deserializer.apply(s), this.val_deserializer.apply(nbt.func_74781_a(s)));
            }
        }
    }

    public static class MapSerializable<K, V, K_NBT extends NBTBase, V_NBT extends NBTBase>
    implements INBTSerializable<NBTTagList> {
        private final Function<V, V_NBT> val_serializer;
        private final Function<V_NBT, V> val_deserializer;
        private final Function<K, K_NBT> key_serializer;
        private final Function<K_NBT, K> key_deserializer;
        public Map<K, V> map;

        public MapSerializable(Map<K, V> map, Function<K, K_NBT> key_serializer, Function<K_NBT, K> key_deserializer, Function<V, V_NBT> val_serializer, Function<V_NBT, V> val_deserializer) {
            this.map = map;
            this.val_serializer = val_serializer;
            this.val_deserializer = val_deserializer;
            this.key_serializer = key_serializer;
            this.key_deserializer = key_deserializer;
        }

        public NBTTagList serializeNBT() {
            NBTTagList list = new NBTTagList();
            for (Map.Entry<K, V> entry2 : this.map.entrySet()) {
                if (entry2.getKey() == null || entry2.getValue() == null) continue;
                NBTBase k = (NBTBase)this.key_serializer.apply(entry2.getKey());
                NBTBase v = (NBTBase)this.val_serializer.apply(entry2.getValue());
                if (k == null || v == null) continue;
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74782_a("k", k);
                nbt.func_74782_a("v", v);
                list.func_74742_a((NBTBase)nbt);
            }
            return list;
        }

        public void deserializeNBT(NBTTagList nbt) {
            this.map.clear();
            for (NBTTagCompound compound : NBTHelper.iterateNBTTagList(nbt)) {
                K k = this.key_deserializer.apply(compound.func_74781_a("k"));
                V v = this.val_deserializer.apply(compound.func_74781_a("v"));
                if (v == null) continue;
                this.map.put(k, v);
            }
        }
    }

    public static abstract class NBTNullable<T extends INBTSerializable<K> & IPacketSerializable, K extends NBTBase>
    implements INBTSerializable<NBTBase>,
    IPacketSerializable {
        T value;

        public NBTBase serializeNBT() {
            if (this.value == null) {
                return new NBTTagByte(0);
            }
            return this.value.serializeNBT();
        }

        public void deserializeNBT(NBTBase nbt) {
            if (nbt.func_74732_a() == 1) {
                this.value = null;
            } else {
                this.value = this.newBlankValue();
                this.value.deserializeNBT(nbt);
            }
        }

        public abstract T newBlankValue();

        @Override
        public void writeToPacket(XUPacketBuffer t) {
            if (this.value == null) {
                t.writeBoolean(false);
            } else {
                t.writeBoolean(true);
                ((IPacketSerializable)this.value).writeToPacket(t);
            }
        }

        @Override
        public void readFromPacket(XUPacketBuffer t) {
            if (t.readBoolean()) {
                this.value = this.newBlankValue();
                ((IPacketSerializable)this.value).readFromPacket(t);
            }
        }
    }

    public static class NBTStack
    implements INBTSerializable<NBTBase>,
    IPacketSerializable {
        ItemStack value = StackHelper.empty();

        public void setStackRaw(ItemStack other) {
            this.value = other;
        }

        public void setStackCopy(ItemStack other) {
            this.value = StackHelper.safeCopy(other);
        }

        public NBTBase serializeNBT() {
            if (StackHelper.isNull(this.value)) {
                return new NBTTagByte(0);
            }
            return this.value.serializeNBT();
        }

        public void deserializeNBT(NBTBase nbt) {
            this.value = nbt.func_74732_a() == 10 ? StackHelper.loadFromNBT((NBTTagCompound)nbt) : StackHelper.empty();
        }

        public ItemStack getRaw() {
            return this.value;
        }

        public ItemStack getCopy() {
            return StackHelper.safeCopy(this.value);
        }

        public ItemStack getCopy(int amount) {
            return ItemHandlerHelper.copyStackWithSize((ItemStack)this.value, (int)amount);
        }

        public boolean isNull() {
            return StackHelper.isNull(this.value);
        }

        @Override
        public void writeToPacket(XUPacketBuffer t) {
            t.writeItemStack(this.value);
        }

        @Override
        public void readFromPacket(XUPacketBuffer t) {
            this.value = t.readItemStack();
        }
    }

    public static class NBTEnum<T extends Enum<T>>
    implements INBTSerializable<NBTTagShort>,
    IPacketSerializable {
        @Nonnull
        public T value;

        public NBTEnum(@Nonnull T value) {
            this.value = value;
        }

        public NBTTagShort serializeNBT() {
            return new NBTTagShort((short)((Enum)this.value).ordinal());
        }

        public void deserializeNBT(NBTTagShort nbt) {
            Class aClass = ((Enum)this.value).getDeclaringClass();
            Enum[] enumConstants = (Enum[])aClass.getEnumConstants();
            short i = nbt.func_150289_e();
            if (enumConstants == null) {
                throw new NullPointerException();
            }
            this.value = enumConstants[i];
        }

        @Override
        public void writeToPacket(XUPacketBuffer t) {
            t.writeShort(((Enum)this.value).ordinal());
        }

        @Override
        public void readFromPacket(XUPacketBuffer t) {
            this.value = ((Enum[])((Enum)this.value).getDeclaringClass().getEnumConstants())[t.readShort()];
        }
    }

    public static class NBTEnumNullable<T extends Enum<T>>
    implements INBTSerializable<NBTTagShort>,
    IPacketSerializable {
        private final Class<T> clazz;
        public T value = null;

        public NBTEnumNullable(Class<T> clazz) {
            this.clazz = clazz;
        }

        public NBTTagShort serializeNBT() {
            return new NBTTagShort(this.value == null ? (short)-1 : (short)((Enum)this.value).ordinal());
        }

        public void deserializeNBT(NBTTagShort nbt) {
            short i = nbt.func_150289_e();
            this.value = i != -1 ? ((Enum[])this.clazz.getEnumConstants())[i] : null;
        }

        @Override
        public void writeToPacket(XUPacketBuffer t) {
            t.writeShort((short)(this.value == null ? -1 : (short)((Enum)this.value).ordinal()));
        }

        @Override
        public void readFromPacket(XUPacketBuffer t) {
            short i = t.readShort();
            this.value = i != -1 ? ((Enum[])this.clazz.getEnumConstants())[i] : null;
        }
    }

    public static class NBTBoolean
    implements INBTSerializable<NBTTagByte>,
    IPacketSerializable {
        public boolean value;

        public NBTBoolean() {
            this(false);
        }

        public NBTBoolean(boolean value) {
            this.value = value;
        }

        public NBTTagByte serializeNBT() {
            return new NBTTagByte(this.value ? (byte)1 : 0);
        }

        public void deserializeNBT(NBTTagByte nbt) {
            this.value = nbt.func_150290_f() != 0;
        }

        @Override
        public void writeToPacket(XUPacketBuffer t) {
            t.writeBoolean(this.value);
        }

        @Override
        public void readFromPacket(XUPacketBuffer t) {
            this.value = t.readBoolean();
        }
    }

    public static class NBTDouble
    implements INBTSerializable<NBTTagDouble>,
    IPacketSerializable {
        public double value;

        public NBTDouble(double value) {
            this.value = value;
        }

        public NBTTagDouble serializeNBT() {
            return new NBTTagDouble(this.value);
        }

        public void deserializeNBT(NBTTagDouble nbt) {
            this.value = nbt.func_150286_g();
        }

        @Override
        public void writeToPacket(XUPacketBuffer t) {
            t.writeDouble(this.value);
        }

        @Override
        public void readFromPacket(XUPacketBuffer t) {
            this.value = t.readDouble();
        }
    }

    public static class Float
    implements INBTSerializable<NBTTagFloat>,
    IPacketSerializable {
        public float value;

        public Float() {
        }

        public Float(float value) {
            this.value = value;
        }

        public NBTTagFloat serializeNBT() {
            return new NBTTagFloat(this.value);
        }

        public void deserializeNBT(NBTTagFloat nbt) {
            this.value = nbt.func_150288_h();
        }

        @Override
        public void writeToPacket(XUPacketBuffer t) {
            t.writeFloat(this.value);
        }

        @Override
        public void readFromPacket(XUPacketBuffer t) {
            this.value = t.readFloat();
        }
    }

    public static class Int
    implements INBTSerializable<NBTTagInt>,
    IPacketSerializable {
        public int value;

        public Int(int value) {
            this.value = value;
        }

        public Int() {
        }

        @Nonnull
        public static NBTTagInt serialize(int value) {
            return new NBTTagInt(value);
        }

        public static int deserialize(NBTTagInt nbt) {
            return nbt.func_150287_d();
        }

        public NBTTagInt serializeNBT() {
            return Int.serialize(this.value);
        }

        public void deserializeNBT(NBTTagInt nbt) {
            this.value = Int.deserialize(nbt);
        }

        @Override
        public void writeToPacket(XUPacketBuffer t) {
            t.writeInt(this.value);
        }

        @Override
        public void readFromPacket(XUPacketBuffer t) {
            this.value = t.readInt();
        }
    }

    public static class BitsLong
    implements INBTSerializable<NBTPrimitive>,
    ISimpleBitSet,
    IPacketSerializable {
        long bitSet;

        public NBTPrimitive serializeNBT() {
            return NBTSerializable.getLowestNeeded(this.bitSet);
        }

        public void deserializeNBT(NBTPrimitive nbt) {
            this.bitSet = nbt.func_150291_c();
        }

        @Override
        public boolean get(int bitIndex) {
            return (this.bitSet & 1L << bitIndex) != 0L;
        }

        @Override
        public void flip(int bitIndex) {
            this.bitSet ^= 1L << bitIndex;
        }

        @Override
        public void set(int bitIndex) {
            this.bitSet |= 1L << bitIndex;
        }

        @Override
        public void set(int bitIndex, boolean value) {
            if (value) {
                this.set(bitIndex);
            } else {
                this.clear(bitIndex);
            }
        }

        @Override
        public void clear(int bitIndex) {
            this.bitSet &= 1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL;
        }

        @Override
        public boolean isEmpty() {
            return this.bitSet != 0L;
        }

        @Override
        public void writeToPacket(XUPacketBuffer t) {
            t.writeLong(this.bitSet);
        }

        @Override
        public void readFromPacket(XUPacketBuffer t) {
            this.bitSet = t.readLong();
        }
    }

    public static class BitsSmall
    implements INBTSerializable<NBTTagByte>,
    ISimpleBitSet,
    IPacketSerializable {
        byte bitSet;

        public BitsSmall(byte b) {
            this.bitSet = b;
        }

        public NBTTagByte serializeNBT() {
            return new NBTTagByte(this.bitSet);
        }

        public void deserializeNBT(NBTTagByte nbt) {
            this.bitSet = nbt.func_150290_f();
        }

        @Override
        public boolean get(int bitIndex) {
            return ((long)this.bitSet & 1L << bitIndex) != 0L;
        }

        @Override
        public void flip(int bitIndex) {
            this.bitSet = (byte)((long)this.bitSet ^ 1L << bitIndex);
        }

        @Override
        public void set(int bitIndex) {
            this.bitSet = (byte)((long)this.bitSet | 1L << bitIndex);
        }

        @Override
        public void set(int bitIndex, boolean value) {
            if (value) {
                this.set(bitIndex);
            } else {
                this.clear(bitIndex);
            }
        }

        @Override
        public void clear(int bitIndex) {
            this.bitSet = (byte)((long)this.bitSet & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL));
        }

        @Override
        public boolean isEmpty() {
            return this.bitSet != 0;
        }

        @Override
        public void writeToPacket(XUPacketBuffer t) {
            t.writeByte(this.bitSet);
        }

        @Override
        public void readFromPacket(XUPacketBuffer t) {
            this.bitSet = t.readByte();
        }
    }

    public static class Long
    implements INBTSerializable<NBTTagLong>,
    IPacketSerializable {
        public long value;

        public NBTTagLong serializeNBT() {
            return new NBTTagLong(this.value);
        }

        public void deserializeNBT(NBTTagLong nbt) {
            this.value = nbt.func_150291_c();
        }

        @Override
        public void writeToPacket(XUPacketBuffer t) {
            t.writeLong(this.value);
        }

        @Override
        public void readFromPacket(XUPacketBuffer t) {
            this.value = t.readLong();
        }
    }

    public static class Text
    implements INBTSerializable<NBTTagString>,
    IPacketSerializable {
        @Nonnull
        String s;

        public Text(@Nonnull String s) {
            this.s = s;
        }

        @Nonnull
        public static NBTTagString serialize(String s) {
            return new NBTTagString(s);
        }

        public NBTTagString serializeNBT() {
            return Text.serialize(this.s);
        }

        public void deserializeNBT(NBTTagString nbt) {
            this.s = this.deserialize(nbt);
        }

        @Nonnull
        public String deserialize(NBTTagString nbt) {
            return nbt.func_150285_a_();
        }

        @Override
        public void writeToPacket(XUPacketBuffer t) {
            t.writeString(this.s);
        }

        @Override
        public void readFromPacket(XUPacketBuffer t) {
            this.s = t.readString();
        }
    }
}

