/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.helpers;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.utils.LogHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TraceHelper {
    final String name;
    public HashMap<List<StackTraceElement>, Integer> elements = new HashMap();
    int n = 0;

    public TraceHelper(String name) {
        this.name = name;
    }

    public void log() {
        RuntimeException runtimeException = new RuntimeException();
        this.log(runtimeException);
    }

    public void log(Throwable err) {
        this.log(err.getStackTrace());
    }

    public void log(StackTraceElement[] stackTrace) {
        ArrayList stackTraceElements = Lists.newArrayList((Object[])stackTrace);
        this.elements.merge(stackTraceElements, 1, (integer, integer2) -> integer + integer2);
        ++this.n;
        if (this.n % 1024 == 0) {
            this.report();
        }
    }

    public void report() {
        LogHelper.info("\n" + this.name + "\n\n" + this.elements.entrySet().stream().flatMap(e -> Stream.concat(Stream.of("\n", ((Integer)e.getValue()).toString(), ""), ((List)e.getKey()).stream().map(Object::toString))).collect(Collectors.joining("\n")), new Object[0]);
    }
}

