/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.core;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.handlers.MiningScheduler;
import oreexcavation.undo.RestoreResult;

public class CommandUndoForced
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "undo_excavation_forced";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "/undo_excavation_forced <player>";
    }

    public int func_82362_a() {
        return 4;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandUndoForced.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        return Collections.emptyList();
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (args.length != 1 || !(sender instanceof EntityPlayer)) {
            throw new CommandException(this.func_71518_a(sender), new Object[0]);
        }
        if (ExcavationSettings.maxUndos <= 0) {
            throw new CommandException("oreexcavation.undo.failed.disabled", new Object[0]);
        }
        EntityPlayerMP player = CommandUndoForced.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        RestoreResult result = MiningScheduler.INSTANCE.attemptUndo((EntityPlayer)player, true);
        switch (result) {
            case INVALID_XP: {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("oreexcavation.undo.failed.xp", new Object[0]));
                break;
            }
            case INVALID_ITEMS: {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("oreexcavation.undo.failed.items", new Object[0]));
                break;
            }
            case NO_UNDO_HISTORY: {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("oreexcavation.undo.failed.no_history", new Object[0]));
                break;
            }
            case OBSTRUCTED: {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("oreexcavation.undo.failed.obstructed", new Object[0]));
                break;
            }
            case SUCCESS: {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("oreexcavation.undo.success", new Object[0]));
            }
        }
    }
}

