/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.stone.limestone;

import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.blocks.stone.limestone.tileentity.furnace.TileEntityLimestoneFurnace;
import com.teammetallurgy.atum.init.AtumBlocks;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLimestoneFurnace
extends BlockContainer {
    private static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private final boolean isBurning;
    private static boolean keepInventory;

    public BlockLimestoneFurnace(boolean isBurning) {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.isBurning = isBurning;
        this.func_149711_c(3.5f);
        this.func_149672_a(SoundType.field_185851_d);
        if (isBurning) {
            this.func_149715_a(0.875f);
        }
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)AtumBlocks.LIMESTONE_FURNACE);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(world, pos, state);
    }

    private void setDefaultFacing(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            IBlockState stateNorth = world.func_180495_p(pos.func_177978_c());
            IBlockState stateSouth = world.func_180495_p(pos.func_177968_d());
            IBlockState stateWest = world.func_180495_p(pos.func_177976_e());
            IBlockState stateEast = world.func_180495_p(pos.func_177974_f());
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (facing == EnumFacing.NORTH && stateNorth.func_185913_b() && !stateSouth.func_185913_b()) {
                facing = EnumFacing.SOUTH;
            } else if (facing == EnumFacing.SOUTH && stateSouth.func_185913_b() && !stateNorth.func_185913_b()) {
                facing = EnumFacing.NORTH;
            } else if (facing == EnumFacing.WEST && stateWest.func_185913_b() && !stateEast.func_185913_b()) {
                facing = EnumFacing.EAST;
            } else if (facing == EnumFacing.EAST && stateEast.func_185913_b() && !stateWest.func_185913_b()) {
                facing = EnumFacing.WEST;
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)facing), 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isBurning) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d3 = 0.52;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            if (rand.nextDouble() < 0.1) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            switch (facing) {
                case WEST: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case EAST: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case NORTH: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case SOUTH: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityLimestoneFurnace) {
            player.openGui((Object)Atum.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            player.func_71029_a(StatList.field_188061_aa);
        }
        return true;
    }

    public static void setState(boolean active, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        keepInventory = true;
        if (active) {
            world.func_180501_a(pos, AtumBlocks.LIMESTONE_FURNACE_LIT.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)), 3);
            world.func_180501_a(pos, AtumBlocks.LIMESTONE_FURNACE_LIT.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)), 3);
        } else {
            world.func_180501_a(pos, AtumBlocks.LIMESTONE_FURNACE.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)), 3);
            world.func_180501_a(pos, AtumBlocks.LIMESTONE_FURNACE.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)), 3);
        }
        keepInventory = false;
        if (te != null) {
            te.func_145829_t();
            world.func_175690_a(pos, te);
        }
    }

    public TileEntity func_149915_a(@Nonnull World world, int meta) {
        return new TileEntityLimestoneFurnace();
    }

    @Nonnull
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        if (stack.func_82837_s() && (tileentity = world.func_175625_s(pos)) instanceof TileEntityLimestoneFurnace) {
            ((TileEntityLimestoneFurnace)tileentity).func_145951_a(stack.func_82833_r());
        }
    }

    public void func_180663_b(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity tileentity;
        if (!keepInventory && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityLimestoneFurnace) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileEntityLimestoneFurnace)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return new ItemStack(AtumBlocks.LIMESTONE_FURNACE);
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    @Nonnull
    public IBlockState func_185499_a(@Nonnull IBlockState state, Rotation rotation) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rotation.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    public IBlockState func_185471_a(@Nonnull IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }
}

