/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.stone.limestone.chest.tileentity;

import com.teammetallurgy.atum.blocks.base.tileentity.TileEntityChestBase;
import com.teammetallurgy.atum.blocks.stone.limestone.chest.BlockSarcophagus;
import com.teammetallurgy.atum.entity.undead.EntityPharaoh;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumSounds;
import com.teammetallurgy.atum.utils.AtumUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.DifficultyInstance;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntitySarcophagus
extends TileEntityChestBase {
    public static final String SARCOPHAGUS_CONTAINER = "atum.container.sarcophagus";
    public boolean hasSpawned = false;
    public boolean isOpenable = false;

    public TileEntitySarcophagus() {
        super(false, true, AtumBlocks.SARCOPHAGUS);
    }

    @Nonnull
    public String func_70005_c_() {
        return this.func_145818_k_() ? this.field_190577_o : SARCOPHAGUS_CONTAINER;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        super.onDataPacket(manager, packet);
        this.func_145839_a(packet.func_148857_g());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.hasSpawned = compound.func_74767_n("spawned");
        this.isOpenable = compound.func_74767_n("openable");
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("spawned", this.hasSpawned);
        compound.func_74757_a("openable", this.isOpenable);
        return compound;
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return this.isOpenable && super.func_70300_a(player);
    }

    public void setOpenable() {
        this.isOpenable = true;
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public void spawn(EntityPlayer player, DifficultyInstance difficulty) {
        if (!this.field_145850_b.field_72995_K) {
            EntityPharaoh pharaoh = new EntityPharaoh(this.field_145850_b);
            pharaoh.func_180482_a(difficulty, null);
            EnumFacing blockFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockSarcophagus.field_176459_a);
            pharaoh.func_70012_b(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p(), blockFacing.func_185119_l() + 90.0f, 0.0f);
            pharaoh.field_70759_as = blockFacing.func_185119_l() + 90.0f;
            pharaoh.setSarcophagusPos(this.field_174879_c);
            this.field_145850_b.func_72838_d((Entity)pharaoh);
            pharaoh.spawnGuards(pharaoh.func_180425_c().func_177967_a(blockFacing, 1).func_177977_b());
            pharaoh.func_70656_aK();
            this.hasSpawned = true;
            for (EntityPlayerMP playerMP : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
                playerMP.func_145747_a((ITextComponent)new TextComponentString(EntityPharaoh.God.getGod(pharaoh.getVariant()).getColor() + pharaoh.func_70005_c_() + " " + AtumUtils.format("chat.atum.summonPharaoh") + " " + player.func_146103_bH().getName()));
            }
        }
        this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), AtumSounds.PHARAOH_SPAWN, SoundCategory.HOSTILE, 0.8f, 1.0f, true);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.isOpenable && super.func_94041_b(index, stack);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        return this.isOpenable ? super.func_70298_a(index, count) : ItemStack.field_190927_a;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.isOpenable && super.hasCapability(capability, facing);
    }
}

