/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.vegetation;

import com.teammetallurgy.atum.init.AtumBiomes;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumItems;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStem;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class BlockFertileSoil
extends Block
implements IGrowable {
    public BlockFertileSoil() {
        super(Material.field_151577_b);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149675_a(true);
        this.func_149713_g(255);
    }

    @Nonnull
    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return MapColor.field_151661_c;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (!world.field_72995_K) {
            if (!world.func_175697_a(pos, 3)) {
                return;
            }
            if (!this.hasWater(world, pos)) {
                if (world.func_180494_b(pos) != AtumBiomes.OASIS) {
                    world.func_180501_a(pos, AtumBlocks.SAND.func_176223_P(), 2);
                }
            } else if (world.func_180495_p(pos.func_177984_a()).isSideSolid((IBlockAccess)world, pos, EnumFacing.DOWN)) {
                if (world.field_73012_v.nextDouble() >= 0.5) {
                    world.func_180501_a(pos, AtumBlocks.SAND.func_176223_P(), 2);
                }
            } else if (world.func_175671_l(pos.func_177984_a()) >= 9) {
                for (int i = 0; i < 4; ++i) {
                    BlockPos posGrow = pos.func_177982_a(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                    if (posGrow.func_177956_o() >= 0 && posGrow.func_177956_o() < 256 && !world.func_175667_e(posGrow) || !this.hasWater(world, posGrow)) {
                        return;
                    }
                    IBlockState stateUp = world.func_180495_p(posGrow.func_177984_a());
                    IBlockState stateGrow = world.func_180495_p(posGrow);
                    if (stateGrow.func_177230_c() != AtumBlocks.SAND || world.func_175671_l(posGrow.func_177984_a()) < 4 || stateUp.getLightOpacity((IBlockAccess)world, pos.func_177984_a()) > 2) continue;
                    world.func_175656_a(posGrow, AtumBlocks.FERTILE_SOIL.func_176223_P());
                }
            }
        }
    }

    private boolean hasWater(World world, BlockPos pos) {
        for (BlockPos.MutableBlockPos mutableBlockPos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-6, -1, -6), (BlockPos)pos.func_177982_a(6, 4, 6))) {
            if (world.func_180495_p((BlockPos)mutableBlockPos).func_185904_a() != Material.field_151586_h) continue;
            return true;
        }
        return false;
    }

    public boolean canSustainPlant(@Nonnull IBlockState state, @Nonnull IBlockAccess world, BlockPos pos, @Nonnull EnumFacing direction, IPlantable plantable) {
        IBlockState plant = plantable.getPlant(world, pos.func_177972_a(direction));
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177984_a());
        boolean hasWater = world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
        switch (plantType) {
            case Plains: {
                return true;
            }
            case Beach: {
                return hasWater;
            }
            case Crop: {
                return plant.func_177230_c() instanceof BlockStem;
            }
        }
        return super.canSustainPlant(state, world, pos, direction, plantable);
    }

    protected boolean func_149700_E() {
        return true;
    }

    @Nonnull
    protected ItemStack func_180643_i(@Nonnull IBlockState state) {
        return new ItemStack(AtumBlocks.FERTILE_SOIL);
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return AtumItems.FERTILE_SOIL_PILE;
    }

    public int func_149745_a(Random random) {
        return MathHelper.func_76136_a((Random)random, (int)3, (int)5);
    }

    public boolean func_176473_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return true;
    }

    public void func_176474_b(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        BlockPos posUp = pos.func_177984_a();
        block0: for (int amount = 0; amount < 36; ++amount) {
            BlockPos up = posUp;
            int amountCheck = 0;
            while (true) {
                if (amountCheck >= amount / 16) {
                    IBlockState grassState;
                    if (!world.func_175623_d(up) || !(rand.nextDouble() <= 75.0) || !AtumBlocks.OASIS_GRASS.func_180671_f(world, up, grassState = AtumBlocks.OASIS_GRASS.func_176223_P())) continue block0;
                    world.func_180501_a(up, grassState, 3);
                    continue block0;
                }
                if (world.func_180495_p((up = up.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).func_177977_b()).func_177230_c() != AtumBlocks.FERTILE_SOIL || world.func_180495_p(up).func_185915_l()) continue block0;
                ++amountCheck;
            }
        }
    }
}

