/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.animal;

import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.entity.ai.AIBeg;
import com.teammetallurgy.atum.entity.ai.AIFollowOwnerWithoutSaddle;
import com.teammetallurgy.atum.entity.ai.AISitWithCheck;
import com.teammetallurgy.atum.entity.animal.EntityCamel;
import com.teammetallurgy.atum.entity.undead.EntityUndeadBase;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.init.AtumLootTables;
import com.teammetallurgy.atum.network.NetworkHandler;
import com.teammetallurgy.atum.network.packet.PacketOpenWolfGui;
import com.teammetallurgy.atum.utils.AtumUtils;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemSaddle;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

@Mod.EventBusSubscriber(modid="atum")
public class EntityDesertWolf
extends EntityTameable
implements IJumpingMount,
IInventoryChangedListener {
    private static final DataParameter<Float> DATA_HEALTH_ID = EntityDataManager.func_187226_a(EntityDesertWolf.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> BEGGING = EntityDataManager.func_187226_a(EntityDesertWolf.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> COLLAR_COLOR = EntityDataManager.func_187226_a(EntityDesertWolf.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(EntityDesertWolf.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<ItemStack> ARMOR_STACK = EntityDataManager.func_187226_a(EntityDesertWolf.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("0b3da7ef-52bf-47c9-9829-862ffa35b418");
    private String texturePath;
    private InventoryBasic desertWolfInventory;
    private float headRotationCourse;
    private float headRotationCourseWild;
    private boolean isWet;
    private boolean isShaking;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;
    private int angryTimer;
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityDesertWolf.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final IAttribute JUMP_STRENGTH = new RangedAttribute(null, "wolf.jumpStrength", 0.7, 0.0, 2.0).func_111117_a("Jump Strength").func_111112_a(true);
    private boolean isWolfJumping;
    private float jumpPower;
    private static long lastAlphaTime = 0L;
    private IItemHandler itemHandler = null;

    public EntityDesertWolf(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.8f);
        this.setAngry(true);
        this.func_70903_f(false);
        this.field_70728_aV = 6;
        this.field_70138_W = 1.1f;
        this.initInventory();
    }

    protected void func_184651_r() {
        this.field_70911_d = new AISitWithCheck(this, !this.isAlpha());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityDesertWolf.class, avoid -> avoid != null && avoid.isAlpha() && !this.isAlpha() && this.func_70909_n(), 8.0f, 0.6, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityLlama.class, 24.0f, 0.6, 1.2));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityCamel.class, avoid -> avoid != null && !this.isAlpha(), 24.0f, 0.6, 1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIFollowOwnerWithoutSaddle(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.4));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new AIBeg(this, 8.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, false, false, target -> !this.func_70909_n()));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityUndeadBase.class, 10, false, false, target -> !this.func_70909_n()));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntityAnimal.class, false, entity -> entity instanceof EntitySheep || entity instanceof EntityRabbit));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, AbstractSkeleton.class, 10, false, false, target -> !this.func_70909_n()));
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (this.field_70170_p.field_73012_v.nextDouble() <= 0.25 && System.currentTimeMillis() > lastAlphaTime + 100L) {
            this.setVariant(1);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getWolfMaxHealth());
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.getWolfAttack());
            this.func_70606_j(this.getWolfMaxHealth());
            this.field_70728_aV = 12;
            lastAlphaTime = System.currentTimeMillis();
            this.field_70911_d = null;
        } else {
            this.setVariant(0);
        }
        return livingdata;
    }

    @Nonnull
    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        String s = EntityList.func_75621_b((Entity)this);
        if (s == null) {
            s = "generic";
        }
        if (this.isAlpha()) {
            s = s + ".alpha";
        }
        return AtumUtils.format("entity." + s + ".name");
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(JUMP_STRENGTH);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getWolfMaxHealth());
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(this.getWolfAttack());
    }

    public void func_70624_b(@Nullable EntityLivingBase livingBase) {
        super.func_70624_b(livingBase);
        if (livingBase == null) {
            this.setAngry(false);
        } else if (!this.func_70909_n()) {
            this.setAngry(true);
        }
    }

    protected void func_70619_bc() {
        this.field_70180_af.func_187227_b(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
        this.field_70180_af.func_187214_a(BEGGING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(COLLAR_COLOR, (Object)EnumDyeColor.GREEN.func_176767_b());
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(SADDLED, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(ARMOR_STACK, (Object)ItemStack.field_190927_a);
    }

    public boolean func_70601_bi() {
        BlockPos pos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (pos.func_177956_o() <= 62 || !this.field_70170_p.func_82736_K().func_82766_b("doMobSpawning")) {
            return false;
        }
        return this.field_70170_p.func_180495_p(pos.func_177977_b()) == AtumBlocks.SAND.func_176223_P() && this.field_70170_p.func_175699_k(pos) > 8 && this.field_70170_p.func_175710_j(pos) && this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    protected SoundEvent func_184639_G() {
        if (this.isAngry()) {
            return SoundEvents.field_187861_gG;
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            return this.func_70909_n() && ((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue() < 10.0f ? SoundEvents.field_187871_gL : SoundEvents.field_187865_gI;
        }
        return SoundEvents.field_187857_gE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        if (this.isAlpha()) {
            return AtumLootTables.DESERT_WOLF_ALPHA;
        }
        return AtumLootTables.DESERT_WOLF;
    }

    public void func_70645_a(@Nonnull DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.desertWolfInventory != null) {
            for (int i = 0; i < this.desertWolfInventory.func_70302_i_(); ++i) {
                ItemStack slotStack = this.desertWolfInventory.func_70301_a(i);
                if (slotStack.func_190926_b()) continue;
                this.func_70099_a(slotStack, 0.0f);
            }
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.isWet && !this.isShaking && !this.func_70781_l() && this.field_70122_E) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.field_70180_af.func_187230_e();
            this.texturePath = null;
        }
        this.headRotationCourseWild = this.headRotationCourse;
        if (this.angryTimer > 0) {
            this.setAngry(false);
            if (this.func_70638_az() instanceof EntityPlayer) {
                this.func_70624_b(null);
                this.func_70604_c(null);
            }
            if (!this.isAngry()) {
                --this.angryTimer;
            }
            if (this.func_70909_n()) {
                this.angryTimer = 0;
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL && !this.func_70909_n()) {
            this.func_70106_y();
        }
        this.headRotationCourse = this.isBegging() ? (this.headRotationCourse += (1.0f - this.headRotationCourse) * 0.4f) : (this.headRotationCourse += (0.0f - this.headRotationCourse) * 0.4f);
        if (this.func_70026_G()) {
            this.isWet = true;
            this.isShaking = false;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else if ((this.isWet || this.isShaking) && this.isShaking) {
            if (this.timeWolfIsShaking == 0.0f) {
                this.func_184185_a(SoundEvents.field_187867_gJ, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
            this.timeWolfIsShaking += 0.05f;
            if (this.prevTimeWolfIsShaking >= 2.0f) {
                this.isWet = false;
                this.isShaking = false;
                this.prevTimeWolfIsShaking = 0.0f;
                this.timeWolfIsShaking = 0.0f;
            }
            if (this.timeWolfIsShaking > 0.4f) {
                float y = (float)this.func_174813_aQ().field_72338_b;
                int shakingTime = (int)(MathHelper.func_76126_a((float)((this.timeWolfIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
                for (int j = 0; j < shakingTime; ++j) {
                    float f1 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    float f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, this.field_70165_t + (double)f1, (double)(y + 0.8f), this.field_70161_v + (double)f2, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getTexture() {
        if (this.texturePath == null) {
            this.texturePath = this.isAngry() ? "angry" : "tamed";
            ItemStack armor = this.getArmor();
            if (!armor.func_190926_b()) {
                ArmorType armorType = ArmorType.getByItemStack(armor);
                this.texturePath = this.texturePath + "_" + armorType.getName();
            }
            if (this.isSaddled()) {
                this.texturePath = this.texturePath + "_saddled";
            }
        }
        return this.texturePath;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isWolfWet() {
        return this.isWet;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadingWhileWet(float shading) {
        return 0.75f + (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * shading) / 2.0f * 0.25f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShakeAngle(float p_70923_1_, float p_70923_2_) {
        float f = (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * p_70923_1_ + p_70923_2_) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return MathHelper.func_76126_a((float)(f * (float)Math.PI)) * MathHelper.func_76126_a((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    @SideOnly(value=Side.CLIENT)
    public float getInterestedAngle(float angle) {
        return (this.headRotationCourseWild + (this.headRotationCourse - this.headRotationCourseWild) * angle) * 0.15f * (float)Math.PI;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public void func_98054_a(boolean child) {
        if (this.isAlpha()) {
            this.func_98055_j(1.6f);
        } else {
            super.func_98054_a(child);
        }
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(@Nonnull Entity entity) {
        boolean shouldAttack = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (shouldAttack) {
            this.func_174815_a((EntityLivingBase)this, entity);
        }
        return shouldAttack;
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getWolfMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.getWolfAttack());
    }

    public boolean func_184645_a(EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (this.func_70909_n()) {
            if (!heldStack.func_190926_b()) {
                boolean holdsSaddle;
                EnumDyeColor color;
                if (heldStack.func_77973_b() instanceof ItemFood) {
                    ItemFood food = (ItemFood)heldStack.func_77973_b();
                    if (food.func_77845_h() && ((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue() < this.func_110138_aP()) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            heldStack.func_190918_g(1);
                        }
                        this.func_70691_i(food.func_150905_g(heldStack));
                        return true;
                    }
                } else if (heldStack.func_77973_b() instanceof ItemDye && (color = EnumDyeColor.func_176766_a((int)heldStack.func_77960_j())) != this.getCollarColor()) {
                    this.setCollarColor(color);
                    if (!player.field_71075_bZ.field_75098_d) {
                        heldStack.func_190918_g(1);
                    }
                    return true;
                }
                boolean holdsArmor = ArmorType.isArmor(heldStack);
                boolean bl = holdsSaddle = !this.func_70631_g_() && !this.isSaddled() && heldStack.func_77973_b() instanceof ItemSaddle;
                if (holdsArmor || holdsSaddle) {
                    this.openGUI(player);
                    return true;
                }
            }
            if (!this.func_70631_g_()) {
                if (player.func_70093_af()) {
                    this.openGUI(player);
                    return true;
                }
                if (this.func_184207_aI()) {
                    return super.func_184645_a(player, hand);
                }
            }
            if (!(this.field_70170_p.field_72995_K || this.func_70877_b(heldStack) && !(this.func_110143_aJ() >= this.func_110138_aP()))) {
                if (this.isAlpha() && !this.func_184207_aI()) {
                    this.mountTo(player);
                    return true;
                }
                if (!this.isAlpha() && this.func_152114_e((EntityLivingBase)player)) {
                    this.field_70911_d.func_75270_a(!this.func_70906_o());
                    this.field_70703_bu = false;
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    return true;
                }
            }
        } else if (heldStack.func_77973_b() == Items.field_151103_aS || heldStack.func_77973_b() == AtumItems.DUSTY_BONE || heldStack.func_77973_b() == Items.field_179558_bo || heldStack.func_77973_b() == Items.field_179559_bp) {
            if (!player.field_71075_bZ.field_75098_d) {
                heldStack.func_190918_g(1);
            }
            if (this.isAngry() && !this.field_70170_p.field_72995_K) {
                this.angryTimer = this.isAlpha() && this.field_70146_Z.nextDouble() <= 0.5 || !this.isAlpha() ? 200 : 0;
            } else if (!this.isAngry() && this.angryTimer > 0 && !this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(2) == 0 && !ForgeEventFactory.onAnimalTame((EntityAnimal)this, (EntityPlayer)player)) {
                    this.func_193101_c(player);
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    if (!this.isAlpha()) {
                        this.field_70911_d.func_75270_a(true);
                    }
                    this.func_70606_j(40.0f);
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return this.func_70909_n() && super.func_184645_a(player, hand);
    }

    public boolean func_70906_o() {
        if (this.isAlpha()) {
            return false;
        }
        return super.func_70906_o();
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() && this.func_184207_aI() && this.isSaddled();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void openInventoryOverride(GuiOpenEvent event) {
        EntityPlayerSP player;
        if (event.getGui() instanceof GuiInventory && (player = Minecraft.func_71410_x().field_71439_g).func_184187_bx() instanceof EntityDesertWolf) {
            EntityDesertWolf desertWolf = (EntityDesertWolf)player.func_184187_bx();
            if (player.func_110124_au() == player.func_110124_au() && desertWolf.isAlpha() && desertWolf.func_184207_aI()) {
                NetworkHandler.WRAPPER.sendToServer((IMessage)new PacketOpenWolfGui(desertWolf.func_145782_y()));
                event.setCanceled(true);
            }
        }
    }

    private void openGUI(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && (!this.func_184207_aI() || this.func_184196_w((Entity)player)) && this.func_70909_n()) {
            this.desertWolfInventory.func_110133_a(this.func_70005_c_());
            player.openGui((Object)Atum.instance, 4, this.field_70170_p, this.func_145782_y(), 0, 0);
        }
    }

    public InventoryBasic getInventory() {
        return this.desertWolfInventory;
    }

    private void initInventory() {
        InventoryBasic inventory = this.desertWolfInventory;
        this.desertWolfInventory = new InventoryBasic("DesertWolfInventory", true, 2);
        this.desertWolfInventory.func_110133_a(this.func_70005_c_());
        if (inventory != null) {
            inventory.func_110132_b((IInventoryChangedListener)this);
            for (int j = 0; j < 2; ++j) {
                ItemStack slotStack = inventory.func_70301_a(j);
                if (slotStack.func_190926_b()) continue;
                this.desertWolfInventory.func_70299_a(j, slotStack.func_77946_l());
            }
        }
        this.desertWolfInventory.func_110134_a((IInventoryChangedListener)this);
        this.updateSlots();
        this.itemHandler = new InvWrapper((IInventory)this.desertWolfInventory);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 8) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getTailRotation() {
        if (this.isAngry()) {
            return 1.5393804f;
        }
        if (!this.func_184207_aI()) {
            return this.func_70909_n() ? (0.55f - (this.func_110138_aP() - ((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue()) * 0.02f) * (float)Math.PI : 0.62831855f;
        }
        return 1.5f;
    }

    public boolean func_70877_b(@Nonnull ItemStack stack) {
        return stack.func_77973_b() instanceof ItemFood && ((ItemFood)stack.func_77973_b()).func_77845_h();
    }

    public int func_70641_bl() {
        return 6;
    }

    public boolean isAngry() {
        return ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 2) != 0;
    }

    private void setAngry(boolean angry) {
        byte tamed = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        if (angry) {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(tamed | 2)));
        } else {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(tamed & 0xFFFFFFFD)));
        }
    }

    public EnumDyeColor getCollarColor() {
        return EnumDyeColor.func_176766_a((int)((Integer)this.field_70180_af.func_187225_a(COLLAR_COLOR) & 0xF));
    }

    private void setCollarColor(EnumDyeColor color) {
        this.field_70180_af.func_187227_b(COLLAR_COLOR, (Object)color.func_176767_b());
    }

    public boolean isSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLED);
    }

    private void setSaddled(boolean saddled) {
        if (saddled) {
            this.field_70180_af.func_187227_b(SADDLED, (Object)Boolean.TRUE);
        } else {
            this.field_70180_af.func_187227_b(SADDLED, (Object)Boolean.FALSE);
        }
    }

    public EntityDesertWolf createChild(@Nonnull EntityAgeable ageable) {
        EntityDesertWolf desertWolf = new EntityDesertWolf(this.field_70170_p);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            desertWolf.func_184754_b(uuid);
            desertWolf.func_70903_f(true);
            desertWolf.setAngry(false);
            desertWolf.func_70691_i(8.0f);
        }
        return desertWolf;
    }

    public void setBegging(boolean beg) {
        this.field_70180_af.func_187227_b(BEGGING, (Object)beg);
    }

    private boolean isBegging() {
        return (Boolean)this.field_70180_af.func_187225_a(BEGGING);
    }

    public boolean func_70878_b(@Nonnull EntityAnimal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(otherAnimal instanceof EntityDesertWolf)) {
            return false;
        }
        EntityDesertWolf desertWolf = (EntityDesertWolf)otherAnimal;
        if (!desertWolf.func_70909_n()) {
            return false;
        }
        if (desertWolf.func_70906_o()) {
            return false;
        }
        return this.func_70880_s() && desertWolf.func_70880_s();
    }

    public boolean func_142018_a(EntityLivingBase target, EntityLivingBase owner) {
        if (!(target instanceof EntityCreeper) && !(target instanceof EntityGhast)) {
            EntityDesertWolf desertWolf;
            if (target instanceof EntityDesertWolf && (desertWolf = (EntityDesertWolf)target).func_70909_n() && desertWolf.func_70902_q() == owner) {
                return false;
            }
            if (target instanceof EntityPlayer && owner instanceof EntityPlayer && !((EntityPlayer)owner).func_96122_a((EntityPlayer)target)) {
                return false;
            }
            return !(target instanceof AbstractHorse) || !((AbstractHorse)target).func_110248_bS();
        }
        return false;
    }

    @SubscribeEvent
    public void onTarget(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof EntityDesertWolf && event.getEntityLiving() instanceof EntityDesertWolf && ((EntityDesertWolf)event.getTarget()).func_70909_n() && ((EntityDesertWolf)event.getEntityLiving()).func_70909_n()) {
            ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
        }
    }

    public boolean func_184652_a(EntityPlayer player) {
        return !this.isAngry() && super.func_184652_a(player);
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("Variant", this.getVariant());
        super.func_70014_b(compound);
        compound.func_74757_a("Angry", this.isAngry());
        compound.func_74774_a("CollarColor", (byte)this.getCollarColor().func_176767_b());
        compound.func_74757_a("Saddle", this.isSaddled());
        if (this.angryTimer > 0) {
            compound.func_74768_a("AngryTimer", this.angryTimer);
        }
        if (!this.desertWolfInventory.func_70301_a(0).func_190926_b()) {
            compound.func_74782_a("SaddleItem", (NBTBase)this.desertWolfInventory.func_70301_a(0).func_77955_b(new NBTTagCompound()));
        }
        if (!this.desertWolfInventory.func_70301_a(1).func_190926_b()) {
            compound.func_74782_a("ArmorItem", (NBTBase)this.desertWolfInventory.func_70301_a(1).func_77955_b(new NBTTagCompound()));
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        ItemStack armorStack;
        ItemStack saddleStack;
        this.setVariant(compound.func_74762_e("Variant"));
        super.func_70037_a(compound);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getWolfMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.getWolfAttack());
        this.setAngry(compound.func_74767_n("Angry"));
        this.setSaddled(compound.func_74767_n("Saddle"));
        this.angryTimer = compound.func_74762_e("AngryTimer");
        if (compound.func_150297_b("CollarColor", 99)) {
            this.setCollarColor(EnumDyeColor.func_176766_a((int)compound.func_74771_c("CollarColor")));
        }
        if (compound.func_150297_b("SaddleItem", 10) && (saddleStack = new ItemStack(compound.func_74775_l("SaddleItem"))).func_77973_b() instanceof ItemSaddle) {
            this.desertWolfInventory.func_70299_a(0, saddleStack);
        }
        if (compound.func_150297_b("ArmorItem", 10) && !(armorStack = new ItemStack(compound.func_74775_l("ArmorItem"))).func_190926_b() && this.isArmor(armorStack)) {
            this.desertWolfInventory.func_70299_a(1, armorStack);
        }
        this.updateSlots();
    }

    private void updateSlots() {
        this.setArmorStack(this.desertWolfInventory.func_70301_a(1));
        if (!this.field_70170_p.field_72995_K) {
            this.setSaddled(!this.desertWolfInventory.func_70301_a(0).func_190926_b());
        }
    }

    private void setArmorStack(@Nonnull ItemStack stack) {
        ArmorType armorType = ArmorType.getByItemStack(stack);
        this.field_70180_af.func_187227_b(ARMOR_STACK, (Object)stack);
        if (!this.field_70170_p.field_72995_K) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_188479_b(ARMOR_MODIFIER_UUID);
            int protection = armorType.getProtection();
            if (protection != 0) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(new AttributeModifier(ARMOR_MODIFIER_UUID, "Desert wolf armor bonus", (double)protection, 0).func_111168_a(false));
            }
        }
    }

    @Nonnull
    public ItemStack getArmor() {
        return (ItemStack)this.field_70180_af.func_187225_a(ARMOR_STACK);
    }

    public void func_76316_a(@Nonnull IInventory invBasic) {
        this.updateSlots();
    }

    public boolean func_174820_d(int inventorySlot, @Nonnull ItemStack stack) {
        int slot = inventorySlot - 400;
        if (slot >= 0 && slot < 2 && slot < this.desertWolfInventory.func_70302_i_()) {
            if (slot == 0 && !(stack.func_77973_b() instanceof ItemSaddle)) {
                return false;
            }
            if (slot != 1 || this.isArmor(stack)) {
                this.desertWolfInventory.func_70299_a(slot, stack);
                this.updateSlots();
                return true;
            }
            return false;
        }
        return false;
    }

    private void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
        this.texturePath = null;
    }

    private int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        return true;
    }

    public double func_70042_X() {
        return super.func_70042_X() + 0.07;
    }

    public void func_184232_k(@Nonnull Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float cos = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float sin = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            passenger.func_70107_b(this.field_70165_t + (double)(0.4f * sin), this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v - (double)(0.4f * cos));
        }
    }

    private void mountTo(EntityPlayer player) {
        player.field_70177_z = this.field_70177_z;
        player.field_70125_A = this.field_70125_A;
        if (!this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
        }
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_184207_aI() && this.func_82171_bF() && this.isSaddled()) {
            EntityLivingBase livingBase = (EntityLivingBase)this.func_184179_bs();
            if (livingBase != null) {
                this.field_70126_B = this.field_70177_z = livingBase.field_70177_z;
                this.field_70125_A = livingBase.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                strafe = livingBase.field_70702_br * 0.5f;
                forward = livingBase.field_191988_bg;
                if (forward <= 0.0f) {
                    forward *= 0.25f;
                }
                if (this.jumpPower > 0.0f && !this.isJumping() && this.field_70122_E) {
                    PotionEffect jumpBoost;
                    this.field_70181_x = this.getWolfJumpStrength() * (double)this.jumpPower;
                    if (this.func_70644_a(MobEffects.field_76430_j) && (jumpBoost = this.func_70660_b(MobEffects.field_76430_j)) != null) {
                        this.field_70181_x += (double)((float)(jumpBoost.func_76458_c() + 1) * 0.1f);
                    }
                    this.setWolfJumping(true);
                    this.field_70160_al = true;
                    if (forward > 0.0f) {
                        float f = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        float f1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        this.field_70159_w += (double)(-0.4f * f * this.jumpPower);
                        this.field_70179_y += (double)(0.4f * f1 * this.jumpPower);
                        this.func_184185_a(SoundEvents.field_187720_cs, 0.4f, 1.0f);
                    }
                    this.jumpPower = 0.0f;
                }
                this.field_70747_aH = this.func_70689_ay() * 0.1f;
                if (this.func_184186_bw()) {
                    this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.8f);
                    super.func_191986_a(strafe, vertical, forward);
                } else if (livingBase instanceof EntityPlayer) {
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                }
                if (this.field_70122_E) {
                    this.jumpPower = 0.0f;
                    this.setWolfJumping(false);
                }
            }
        } else {
            this.field_70747_aH = 0.02f;
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.isAlpha() && distance > 5.0f) {
            super.func_180430_e(distance, damageMultiplier);
        } else if (!this.isAlpha() && distance > 2.5f) {
            super.func_180430_e(distance, damageMultiplier);
        }
    }

    private boolean isJumping() {
        return this.isWolfJumping;
    }

    private void setWolfJumping(boolean jumping) {
        this.isWolfJumping = jumping;
    }

    private double getWolfJumpStrength() {
        return this.func_110148_a(JUMP_STRENGTH).func_111126_e();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_110206_u(int jumpPower) {
        if (this.isAlpha()) {
            if (jumpPower < 0) {
                jumpPower = 0;
            }
            this.jumpPower = jumpPower >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPower / 90.0f;
        }
    }

    public boolean func_184776_b() {
        return this.isSaddled();
    }

    public void func_184775_b(int jumpPower) {
    }

    public void func_184777_r_() {
    }

    public boolean isAlpha() {
        return this.getVariant() == 1;
    }

    private float getWolfMaxHealth() {
        if (this.func_70909_n()) {
            if (this.isAlpha()) {
                return 36.0f;
            }
            return 20.0f;
        }
        if (this.isAlpha()) {
            return 24.0f;
        }
        return 12.0f;
    }

    private double getWolfAttack() {
        if (this.isAlpha()) {
            return 8.0;
        }
        return 4.0;
    }

    public boolean isArmor(ItemStack stack) {
        return ArmorType.isArmor(stack);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public static enum ArmorType {
        NONE(0),
        IRON(5, "iron"),
        GOLD(7, "gold"),
        DIAMOND(11, "diamond");

        private final String textureName;
        private final String typeName;
        private final int protection;

        private ArmorType(int armorStrength) {
            this.protection = armorStrength;
            this.typeName = null;
            this.textureName = null;
        }

        private ArmorType(int armorStrength, String typeName) {
            this.protection = armorStrength;
            this.typeName = typeName;
            this.textureName = new ResourceLocation("atum", "textures/entity/armor/desert_wolf_armor_" + typeName + ".png").toString();
        }

        public int getProtection() {
            return this.protection;
        }

        public String getName() {
            return this.typeName;
        }

        public String getTextureName() {
            return this.textureName;
        }

        public static ArmorType getByItemStack(@Nonnull ItemStack stack) {
            Item item = stack.func_77973_b();
            if (item == AtumItems.DESERT_WOLF_IRON_ARMOR) {
                return IRON;
            }
            if (item == AtumItems.DESERT_WOLF_GOLD_ARMOR) {
                return GOLD;
            }
            if (item == AtumItems.DESERT_WOLF_DIAMOND_ARMOR) {
                return DIAMOND;
            }
            return NONE;
        }

        public static boolean isArmor(@Nonnull ItemStack stack) {
            return ArmorType.getByItemStack(stack) != NONE;
        }
    }
}

