/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.efreet;

import com.teammetallurgy.atum.blocks.wood.BlockAtumPlank;
import com.teammetallurgy.atum.blocks.wood.BlockAtumSapling;
import com.teammetallurgy.atum.entity.efreet.EntityEfreetBase;
import com.teammetallurgy.atum.entity.undead.EntityPharaoh;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.init.AtumLootTables;
import com.teammetallurgy.atum.items.ItemLoot;
import com.teammetallurgy.atum.items.tools.ItemScepter;
import com.teammetallurgy.atum.utils.StackHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySunspeaker
extends EntityEfreetBase
implements IMerchant {
    @Nullable
    private EntityPlayer buyingPlayer;
    @Nullable
    private MerchantRecipeList buyingList;
    private int timeUntilReset;
    private boolean needsInitilization;
    private int wealth;
    private int tradeLevel;
    private static final List<EntityVillager.ITradeList[]> TRADES = Arrays.asList({new ItemsForCoins(32, Item.func_150898_a((Block)BlockAtumSapling.getSapling(BlockAtumPlank.WoodType.PALM)), new EntityVillager.PriceInfo(4, 5)), new ItemsForCoins(16, Item.func_150898_a((Block)Blocks.field_150398_cm), new EntityVillager.PriceInfo(1, 2)), new ItemsForCoins(24, AtumItems.DATE, new EntityVillager.PriceInfo(14, 16)), new ItemsForCoins(24, AtumItems.EMMER_BREAD, new EntityVillager.PriceInfo(3, 4))}, {new ItemsForCoins(36, AtumItems.LINEN_CLOTH, new EntityVillager.PriceInfo(5, 10)), new ItemsForCoins(48, AtumItems.CAMEL_RAW, new EntityVillager.PriceInfo(13, 18)), new ItemsForCoins(48, AtumItems.SCROLL, new EntityVillager.PriceInfo(9, 12)), new ItemsForCoins(32, AtumItems.ANPUTS_FINGERS_SPORES, new EntityVillager.PriceInfo(8, 10))}, {new ItemsForCoins(48, Item.func_150898_a((Block)Blocks.field_150426_aN), new EntityVillager.PriceInfo(3, 4)), new ItemsForCoins(48, Items.field_151057_cb, new EntityVillager.PriceInfo(1, 2)), new ItemsForCoins(64, Items.field_151067_bt, new EntityVillager.PriceInfo(1, 1)), new ItemsForCoins(36, Items.field_151065_br, new EntityVillager.PriceInfo(4, 5))}, {new ItemsForCoins(48, Items.field_151141_av, new EntityVillager.PriceInfo(1, 1)), new ItemsForCoins(48, AtumItems.GRAVEROBBERS_MAP, new EntityVillager.PriceInfo(1, 1)), new ItemsForCoins(64, AtumItems.ENCHANTED_GOLDEN_DATE, new EntityVillager.PriceInfo(1, 2)), new ItemsForCoins(48, Items.field_151079_bi, new EntityVillager.PriceInfo(3, 4)), new ItemsForCoins(64, AtumItems.DISENCHANTING_SCROLL, new EntityVillager.PriceInfo(1, 1))});

    public EntitySunspeaker(World world) {
        super(world);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new ILookAtTradePlayer(this));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)ItemScepter.getScepter(EntityPharaoh.God.RA)));
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return AtumLootTables.SUNSPEAKER;
    }

    @Nullable
    public EntityAgeable func_90011_a(@Nonnull EntityAgeable ageable) {
        EntitySunspeaker sunspeaker = new EntitySunspeaker(this.field_70170_p);
        sunspeaker.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)sunspeaker)), null);
        return sunspeaker;
    }

    @Override
    protected void func_70619_bc() {
        if (!this.isTrading() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.needsInitilization && this.buyingList != null) {
                    for (MerchantRecipe merchantrecipe : this.buyingList) {
                        if (!merchantrecipe.func_82784_g()) continue;
                        merchantrecipe.func_82783_a(this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6) + 2);
                    }
                    this.populateBuyingList();
                    this.needsInitilization = false;
                }
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 0));
            }
        }
        super.func_70619_bc();
    }

    private void populateBuyingList() {
        int level;
        this.tradeLevel = this.tradeLevel != 0 ? ++this.tradeLevel : 1;
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
        }
        if ((level = this.tradeLevel - 1) < TRADES.size()) {
            EntityVillager.ITradeList[] tradeArray = TRADES.get(level);
            EntityVillager.ITradeList tradeList = tradeArray[this.field_70146_Z.nextInt(tradeArray.length)];
            tradeList.func_190888_a((IMerchant)this, this.buyingList, this.field_70146_Z);
        }
    }

    public void func_70932_a_(@Nullable EntityPlayer player) {
        this.buyingPlayer = player;
    }

    @Nullable
    public EntityPlayer func_70931_l_() {
        return this.buyingPlayer;
    }

    private boolean isTrading() {
        return this.buyingPlayer != null;
    }

    @Nullable
    public MerchantRecipeList func_70934_b(@Nonnull EntityPlayer player) {
        if (this.buyingList == null) {
            this.populateBuyingList();
        }
        return this.buyingList;
    }

    public void func_70933_a(@Nonnull MerchantRecipe recipe) {
        recipe.func_77399_f();
        this.field_70757_a = -this.func_70627_aG();
        this.func_184185_a(SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
        int i = 3 + this.field_70146_Z.nextInt(4);
        if (recipe.func_180321_e() == 1 || this.field_70146_Z.nextInt(5) == 0) {
            this.timeUntilReset = 40;
            this.needsInitilization = true;
            i += 5;
        }
        if (recipe.func_77394_a().func_77973_b() == AtumItems.GOLD_COIN) {
            this.wealth += recipe.func_77394_a().func_190916_E();
        }
        if (recipe.func_180322_j()) {
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, i));
        }
    }

    public void func_110297_a_(@Nonnull ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(stack.func_190926_b() ? SoundEvents.field_187913_gm : SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70930_a(@Nullable MerchantRecipeList recipeList) {
    }

    @Nonnull
    public World func_190670_t_() {
        return this.field_70170_p;
    }

    @Nonnull
    public BlockPos func_190671_u_() {
        return new BlockPos((Entity)this);
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean func_184645_a(EntityPlayer player, @Nonnull EnumHand hand) {
        boolean nameTag;
        ItemStack heldStack = player.func_184586_b(hand);
        boolean bl = nameTag = heldStack.func_77973_b() == Items.field_151057_cb;
        if (nameTag) {
            heldStack.func_111282_a(player, (EntityLivingBase)this, hand);
            return true;
        }
        if (heldStack.func_77973_b() instanceof ItemLoot) {
            ItemLoot.Type type = ItemLoot.getType(heldStack.func_77973_b());
            ItemLoot.Quality quality = ItemLoot.getQuality(heldStack.func_77973_b());
            if (quality != ItemLoot.Quality.DIRTY) {
                double modifier = 1.0;
                if (type == ItemLoot.Type.NECKLACE) {
                    modifier = 2.0;
                } else if (type == ItemLoot.Type.BROACH) {
                    modifier = 2.5;
                } else if (type == ItemLoot.Type.SCEPTER) {
                    modifier = 3.0;
                } else if (type == ItemLoot.Type.IDOL) {
                    modifier = 5.0;
                }
                if (!player.func_184812_l_()) {
                    heldStack.func_190918_g(1);
                }
                this.handleRelicTrade(player, hand, modifier, quality);
                return true;
            }
            return super.func_184645_a(player, hand);
        }
        if (!(this.func_190669_a(heldStack, ((Object)((Object)this)).getClass()) || !this.func_70089_S() || this.isTrading() || this.func_70631_g_() || player.func_70093_af())) {
            if (this.buyingList == null) {
                this.populateBuyingList();
            }
            if (!this.field_70170_p.field_72995_K && !this.buyingList.isEmpty()) {
                this.func_70932_a_(player);
                player.func_180472_a((IMerchant)this);
            } else if (this.buyingList.isEmpty()) {
                return super.func_184645_a(player, hand);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    private void handleRelicTrade(EntityPlayer player, EnumHand hand, double modifier, ItemLoot.Quality quality) {
        int amount = 0;
        if (quality == ItemLoot.Quality.SILVER) {
            amount = (int)((double)amount + modifier);
        } else if (quality == ItemLoot.Quality.GOLD) {
            amount = (int)((double)amount + modifier * 2.0);
        } else if (quality == ItemLoot.Quality.SAPPHIRE) {
            amount = (int)((double)amount + modifier * 3.0);
        } else if (quality == ItemLoot.Quality.RUBY) {
            amount = (int)((double)amount + modifier * 4.0);
        } else if (quality == ItemLoot.Quality.EMERALD) {
            amount = (int)((double)amount + modifier * 5.0);
        } else if (quality == ItemLoot.Quality.DIAMOND) {
            amount = (int)((double)amount + modifier * 10.0);
        }
        if (amount > 0) {
            if (this.field_70170_p.field_72995_K) {
                this.spawnParticles(EnumParticleTypes.VILLAGER_HAPPY);
                this.func_184185_a(SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_184185_a(SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
                StackHelper.giveItem(player, hand, new ItemStack(AtumItems.GOLD_COIN, amount));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(EnumParticleTypes particleType) {
        for (int amount = 0; amount < 5; ++amount) {
            double x = this.field_70146_Z.nextGaussian() * 0.02;
            double y = this.field_70146_Z.nextGaussian() * 0.02;
            double z = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 1.0 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, x, y, z, new int[0]);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Riches", this.wealth);
        compound.func_74768_a("TradeLevel", this.tradeLevel);
        if (this.buyingList != null) {
            compound.func_74782_a("Offers", (NBTBase)this.buyingList.func_77202_a());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.wealth = compound.func_74762_e("Riches");
        this.tradeLevel = compound.func_74762_e("TradeLevel");
        if (compound.func_150297_b("Offers", 10)) {
            NBTTagCompound nbttagcompound = compound.func_74775_l("Offers");
            this.buyingList = new MerchantRecipeList(nbttagcompound);
        }
    }

    static class ILookAtTradePlayer
    extends EntityAIWatchClosest {
        private final EntitySunspeaker sunspeaker;

        ILookAtTradePlayer(EntitySunspeaker sunspeaker) {
            super((EntityLiving)sunspeaker, EntityPlayer.class, 8.0f);
            this.sunspeaker = sunspeaker;
        }

        public boolean func_75250_a() {
            if (this.sunspeaker.isTrading()) {
                this.field_75334_a = this.sunspeaker.func_70931_l_();
                return true;
            }
            return false;
        }
    }

    static class ItemsForCoins
    implements EntityVillager.ITradeList {
        int price;
        Item buyingItem;
        EntityVillager.PriceInfo buyingAmount;

        ItemsForCoins(int price, Item item, EntityVillager.PriceInfo buyingAmount) {
            this.buyingItem = item;
            this.price = price;
            this.buyingAmount = buyingAmount;
        }

        public void func_190888_a(@Nonnull IMerchant merchant, @Nonnull MerchantRecipeList recipeList, @Nonnull Random random) {
            int buyingAmount = 1;
            if (this.buyingAmount != null) {
                buyingAmount = this.buyingAmount.func_179412_a(random);
            }
            recipeList.add((Object)new MerchantRecipe(new ItemStack(AtumItems.GOLD_COIN, this.price), new ItemStack(this.buyingItem, buyingAmount)));
        }
    }
}

