/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.undead;

import com.teammetallurgy.atum.entity.undead.EntityUndeadBase;
import com.teammetallurgy.atum.init.AtumLootTables;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityWraith
extends EntityUndeadBase {
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityWraith.class, (DataSerializer)DataSerializers.field_187191_a);
    private int cycleHeight;
    private int cycleTime;

    public EntityWraith(World world) {
        super(world);
        this.field_70728_aV = 6;
        this.func_98053_h(false);
        this.cycleTime = (int)(Math.random() * 40.0 + 80.0);
        this.cycleHeight = (int)(Math.random() * (double)this.cycleTime);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIWraithAttack(this));
    }

    @Override
    protected void func_175456_n() {
        super.func_175456_n();
        this.field_70715_bh.func_75776_a(1, new AIWraithTarget<EntityPlayer>(this, EntityPlayer.class));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(30.0);
    }

    @Nonnull
    protected PathNavigate func_175447_b(@Nonnull World world) {
        return new PathNavigateClimber((EntityLiving)this, world);
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_190022_cI;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_190024_cK;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190023_cJ;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    @Override
    public void func_70636_d() {
        this.cycleHeight = (this.cycleHeight + 1) % this.cycleTime;
        super.func_70636_d();
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return AtumLootTables.WRAITH;
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    private boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    private void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public boolean func_70652_k(Entity entity) {
        EntityLivingBase livingBase;
        if (!super.func_70652_k(entity)) {
            return false;
        }
        if (this.field_70146_Z.nextDouble() <= 0.175 && entity instanceof EntityLivingBase && !(livingBase = (EntityLivingBase)entity).func_70644_a(MobEffects.field_76421_d)) {
            livingBase.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 80, 1));
        }
        return true;
    }

    private static class AIWraithTarget<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        AIWraithTarget(EntityWraith wraith, Class<T> classTarget) {
            super((EntityCreature)wraith, classTarget, true);
        }

        public boolean func_75250_a() {
            float f = this.field_75299_d.func_70013_c();
            return f < 0.5f && super.func_75250_a();
        }
    }

    private static class AIWraithAttack
    extends EntityAIAttackMelee {
        AIWraithAttack(EntityWraith wraith) {
            super((EntityCreature)wraith, 1.0, true);
        }

        public boolean func_75253_b() {
            float f = this.field_75441_b.func_70013_c();
            if (f >= 0.5f && this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b(null);
                return false;
            }
            return super.func_75253_b();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }
}

