/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.items.tools;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import gnu.trove.map.TObjectFloatMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectFloatHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSword;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemHammer
extends ItemSword {
    private static final AttributeModifier STUN = new AttributeModifier(UUID.fromString("b4ebf092-fe62-4250-b945-7dc45b2f1036"), "Hammer stun", -1000.0, 0);
    private static final TObjectFloatMap<EntityPlayer> cooldown = new TObjectFloatHashMap();
    protected static final TObjectIntMap<EntityLivingBase> stun = new TObjectIntHashMap();
    private final float damage;

    protected ItemHammer(Item.ToolMaterial material) {
        super(material);
        this.damage = material.func_78000_c() + 17.0f;
    }

    @SubscribeEvent
    public void onHurt(LivingHurtEvent event) {
        Entity trueSource = event.getSource().func_76346_g();
        if (trueSource instanceof EntityPlayer && cooldown.containsKey((Object)trueSource)) {
            EntityLivingBase target;
            ModifiableAttributeInstance attribute;
            if (cooldown.get((Object)trueSource) == 1.0f && !(attribute = (ModifiableAttributeInstance)(target = event.getEntityLiving()).func_110148_a(SharedMonsterAttributes.field_111263_d)).func_180374_a(STUN)) {
                attribute.func_111121_a(STUN);
                this.onStun(target);
            }
            cooldown.remove((Object)trueSource);
        }
    }

    protected void onStun(EntityLivingBase target) {
        stun.put((Object)target, 40);
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (stun.isEmpty() || !stun.containsKey((Object)event.getEntityLiving())) {
            return;
        }
        ModifiableAttributeInstance attribute = (ModifiableAttributeInstance)event.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (attribute.func_180374_a(STUN)) {
            EntityLivingBase entity = event.getEntityLiving();
            int stunTime = stun.get((Object)entity);
            if (stunTime <= 1) {
                stun.remove((Object)entity);
                attribute.func_111124_b(STUN);
            } else {
                stun.put((Object)entity, stunTime - 1);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onAttack(AttackEntityEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (event.getTarget() instanceof EntityLivingBase && player.func_184614_ca().func_77973_b() instanceof ItemHammer) {
            cooldown.put((Object)player, player.func_184825_o(0.5f));
        }
    }

    @Nonnull
    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot slot) {
        HashMultimap map = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.damage, 0));
            map.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -3.55, 0));
        }
        return map;
    }
}

