/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.utils.event;

import com.teammetallurgy.atum.blocks.BlockPortal;
import com.teammetallurgy.atum.blocks.vegetation.BlockFertileSoil;
import com.teammetallurgy.atum.blocks.vegetation.BlockFertileSoilTilled;
import com.teammetallurgy.atum.entity.bandit.EntityBanditBase;
import com.teammetallurgy.atum.entity.stone.EntityStoneBase;
import com.teammetallurgy.atum.entity.undead.EntityPharaoh;
import com.teammetallurgy.atum.entity.undead.EntityUndeadBase;
import com.teammetallurgy.atum.entity.undead.EntityWraith;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.init.AtumLootTables;
import com.teammetallurgy.atum.items.ItemTexturedArmor;
import com.teammetallurgy.atum.items.artifacts.atum.ItemAtumsBounty;
import com.teammetallurgy.atum.utils.AtumConfig;
import com.teammetallurgy.atum.world.teleporter.AtumStartTeleporter;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockMycelium;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="atum")
public class AtumEventListener {
    private static final String TAG_ATUM_START = "atum_start";

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        NBTTagCompound tag = event.player.getEntityData();
        NBTTagCompound persistedTag = tag.func_74775_l("PlayerPersisted");
        boolean shouldStartInAtum = AtumConfig.START_IN_ATUM && !persistedTag.func_74767_n(TAG_ATUM_START);
        persistedTag.func_74757_a(TAG_ATUM_START, true);
        tag.func_74782_a("PlayerPersisted", (NBTBase)persistedTag);
        if (shouldStartInAtum && event.player instanceof EntityPlayerMP && event.player.field_70170_p instanceof WorldServer) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            WorldServer world = (WorldServer)player.field_70170_p;
            BlockPortal.changeDimension((World)world, player, AtumConfig.DIMENSION_ID, new AtumStartTeleporter());
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (!world.field_72995_K && AtumConfig.ALLOW_CREATION && event.phase == TickEvent.Phase.END && player.field_70173_aa % 20 == 0 && (world.field_73011_w.getDimension() == 0 || world.field_73011_w.getDimension() == AtumConfig.DIMENSION_ID)) {
            for (EntityItem entityItem : world.func_72872_a(EntityItem.class, player.func_174813_aQ().func_72314_b(10.0, 1.0, 10.0))) {
                IBlockState state = world.func_180495_p(entityItem.func_180425_c());
                if (entityItem.func_92059_d().func_77973_b() != AtumItems.SCARAB || state.func_177230_c() != Blocks.field_150355_j && state != AtumBlocks.PORTAL.func_176223_P() || !AtumBlocks.PORTAL.trySpawnPortal(world, entityItem.func_180425_c())) continue;
                entityItem.func_70106_y();
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onPlace(BlockEvent.PlaceEvent event) {
        Block block = event.getPlacedBlock().func_177230_c();
        if (event.getPlayer().field_70170_p.field_73011_w.getDimension() == AtumConfig.DIMENSION_ID && (block instanceof BlockDirt || block instanceof BlockGrass || block instanceof BlockMycelium || block instanceof BlockFarmland && block != AtumBlocks.FERTILE_SOIL_TILLED)) {
            event.getWorld().func_175656_a(event.getPos(), AtumBlocks.SAND.func_176223_P());
        }
    }

    @SubscribeEvent
    public static void onArmorClean(PlayerInteractEvent.RightClickBlock event) {
        try {
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            EntityPlayer player = event.getEntityPlayer();
            ItemStack stack = player.func_184614_ca();
            IFluidHandler tank = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (EnumFacing)event.getFace());
            if (stack.func_77973_b() instanceof ItemTexturedArmor && ((ItemTexturedArmor)stack.func_77973_b()).func_82816_b_(stack)) {
                FluidTank fluidTank;
                IBlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() instanceof BlockCauldron) {
                    int level = (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a);
                    if (level > 0) {
                        if (!world.field_72995_K) {
                            ((ItemTexturedArmor)stack.func_77973_b()).func_82815_c(stack);
                            player.func_71029_a(StatList.field_188079_M);
                            ((BlockCauldron)state.func_177230_c()).func_176590_a(world, pos, state, level - 1);
                        }
                        player.func_184185_a(SoundEvents.field_187609_F, 0.16f, 0.66f);
                        event.setUseItem(Event.Result.DENY);
                    }
                } else if (tank instanceof FluidTank && (fluidTank = (FluidTank)tank).getFluid() != null && fluidTank.getFluid().getFluid() == FluidRegistry.WATER && fluidTank.getFluidAmount() >= 250) {
                    if (!world.field_72995_K) {
                        ((ItemTexturedArmor)stack.func_77973_b()).func_82815_c(stack);
                        player.func_71029_a(StatList.field_188079_M);
                        tank.drain(250, true);
                    }
                    player.func_184185_a(SoundEvents.field_187609_F, 0.16f, 0.66f);
                    event.setUseItem(Event.Result.ALLOW);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onSeedUse(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = event.getWorld();
        if (player.field_70170_p.field_73011_w.getDimension() == AtumConfig.DIMENSION_ID && player.func_184586_b(event.getHand()).func_77973_b() == Items.field_151014_N && world.func_180495_p(event.getPos()).func_177230_c() instanceof BlockFarmland) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onFallDamage(LivingFallEvent event) {
        if (event.getEntity() instanceof EntityWraith || event.getEntity() instanceof EntityPharaoh) {
            event.setDistance(0.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (event.getSource().func_76355_l().equals("drown") && (event.getEntity() instanceof EntityUndeadBase || event.getEntity() instanceof EntityStoneBase)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onFishLoot(ItemFishedEvent event) {
        World world = event.getEntityPlayer().field_70170_p;
        EntityFishHook fishHook = event.getHookEntity();
        EntityPlayer angler = fishHook.func_190619_l();
        ItemStack heldStack = angler.func_184586_b(angler.func_184600_cs());
        LootContext.Builder builder = new LootContext.Builder((WorldServer)world);
        builder.func_186469_a((float)EnchantmentHelper.func_191529_b((ItemStack)heldStack) + angler.func_184817_da()).func_186470_a(angler).func_186472_a((Entity)fishHook);
        if (world.field_73011_w.getDimension() == AtumConfig.DIMENSION_ID) {
            event.setCanceled(true);
            if (heldStack.func_77973_b() instanceof ItemAtumsBounty) {
                AtumEventListener.catchFish(world, angler, fishHook, builder, AtumLootTables.ATUMS_BOUNTY);
                angler.field_70170_p.func_72838_d((Entity)new EntityXPOrb(angler.field_70170_p, angler.field_70165_t, angler.field_70163_u + 0.5, angler.field_70161_v + 0.5, world.field_73012_v.nextInt(6) + 1));
            } else {
                AtumEventListener.catchFish(world, angler, fishHook, builder, AtumLootTables.FISHING);
            }
        }
    }

    private static void catchFish(World world, EntityPlayer angler, EntityFishHook fishHook, LootContext.Builder builder, ResourceLocation lootTable) {
        List loots = world.func_184146_ak().func_186521_a(lootTable).func_186462_a(world.field_73012_v, builder.func_186471_a());
        for (ItemStack loot : loots) {
            EntityItem fish = new EntityItem(fishHook.field_70170_p, fishHook.field_70165_t, fishHook.field_70163_u, fishHook.field_70161_v, loot);
            double x = angler.field_70165_t - fishHook.field_70165_t;
            double y = angler.field_70163_u - fishHook.field_70163_u;
            double z = angler.field_70161_v - fishHook.field_70161_v;
            double swush = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
            fish.field_70159_w = x * 0.1;
            fish.field_70181_x = y * 0.1 + (double)MathHelper.func_76133_a((double)swush) * 0.08;
            fish.field_70179_y = z * 0.1;
            world.func_72838_d((Entity)fish);
        }
    }

    @SubscribeEvent
    public static void onHoeEvent(UseHoeEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        boolean result = false;
        if (state.func_177230_c() instanceof BlockFertileSoil) {
            if (event.getCurrent().func_77973_b() == AtumItems.TEFNUTS_BLESSING) {
                world.func_175656_a(pos, AtumBlocks.FERTILE_SOIL_TILLED.func_176223_P().func_177226_a((IProperty)BlockFertileSoilTilled.field_176531_a, (Comparable)Integer.valueOf(7)).func_177226_a((IProperty)BlockFertileSoilTilled.BLESSED, (Comparable)Boolean.valueOf(true)));
            } else {
                world.func_175656_a(pos, AtumBlocks.FERTILE_SOIL_TILLED.func_176223_P());
            }
            result = true;
        }
        if (result) {
            event.setResult(Event.Result.ALLOW);
            world.func_184133_a(null, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onSpawn(LivingSpawnEvent.CheckSpawn event) {
        EntityLivingBase livingBase = event.getEntityLiving();
        if (event.isSpawner() && (livingBase instanceof EntityUndeadBase || livingBase instanceof EntityBanditBase)) {
            EntityBanditBase banditBase;
            EntityMob mob = (EntityMob)livingBase;
            if (mob instanceof EntityUndeadBase) {
                EntityUndeadBase undeadBase = (EntityUndeadBase)mob;
                if (undeadBase.canSpawnNoHeightCheck(true)) {
                    event.setResult(Event.Result.ALLOW);
                }
            } else if (mob instanceof EntityBanditBase && (banditBase = (EntityBanditBase)mob).canSpawnNoHeightCheck(true)) {
                event.setResult(Event.Result.ALLOW);
            }
        }
    }
}

