/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.utils.recipe;

import com.teammetallurgy.atum.init.AtumItems;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="atum")
public class RecipeMapExtendingScroll
extends ShapedRecipes {
    public RecipeMapExtendingScroll() {
        super("", 3, 3, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193368_a((Item[])new Item[]{AtumItems.SCROLL}), Ingredient.func_193368_a((Item[])new Item[]{AtumItems.SCROLL}), Ingredient.func_193368_a((Item[])new Item[]{AtumItems.SCROLL}), Ingredient.func_193368_a((Item[])new Item[]{AtumItems.SCROLL}), Ingredient.func_193367_a((Item)Items.field_151098_aY), Ingredient.func_193368_a((Item[])new Item[]{AtumItems.SCROLL}), Ingredient.func_193368_a((Item[])new Item[]{AtumItems.SCROLL}), Ingredient.func_193368_a((Item[])new Item[]{AtumItems.SCROLL}), Ingredient.func_193368_a((Item[])new Item[]{AtumItems.SCROLL})}), new ItemStack((Item)Items.field_151148_bJ));
        this.setRegistryName(new ResourceLocation("atum", "map_extending_scroll"));
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        if (!super.func_77569_a(inv, world)) {
            return false;
        }
        ItemStack stack = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_() && stack.func_190926_b(); ++i) {
            ItemStack slotStack = inv.func_70301_a(i);
            if (slotStack.func_77973_b() != Items.field_151098_aY) continue;
            stack = slotStack;
        }
        if (stack.func_190926_b()) {
            return false;
        }
        MapData mapdata = Items.field_151098_aY.func_77873_a(stack, world);
        if (mapdata == null) {
            return false;
        }
        if (this.isExplorationMap(mapdata)) {
            return false;
        }
        return mapdata.field_76197_d < 4;
    }

    private boolean isExplorationMap(MapData mapData) {
        if (mapData.field_76203_h != null) {
            for (MapDecoration decoration : mapData.field_76203_h.values()) {
                if (decoration.func_191179_b() != MapDecoration.Type.MANSION && decoration.func_191179_b() != MapDecoration.Type.MONUMENT) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack stack = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_() && stack.func_190926_b(); ++i) {
            ItemStack slotStack = inv.func_70301_a(i);
            if (slotStack.func_77973_b() != Items.field_151098_aY) continue;
            stack = slotStack;
        }
        stack = stack.func_77946_l();
        stack.func_190920_e(1);
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("map_scale_direction", 1);
        return stack;
    }

    public boolean func_192399_d() {
        return true;
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        event.getRegistry().register((IForgeRegistryEntry)new RecipeMapExtendingScroll());
    }
}

