/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.biome;

import com.teammetallurgy.atum.entity.animal.EntityDesertWolf;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.world.biome.base.AtumBiome;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BiomeLimestoneCrags
extends AtumBiome {
    private WorldGenerator genSpikes = new WorldGenLimestoneSpike();

    public BiomeLimestoneCrags(AtumBiome.AtumBiomeProperties properties) {
        super(properties);
        this.deadwoodRarity = 0.12;
        this.addDefaultSpawns();
    }

    @Override
    protected void addDefaultSpawns() {
        super.addDefaultSpawns();
        this.addSpawn(EntityDesertWolf.class, 5, 2, 4, EnumCreatureType.CREATURE);
    }

    @Override
    public void func_180624_a(@Nonnull World world, @Nonnull Random random, @Nonnull BlockPos pos) {
        for (int i = 0; i < 3; ++i) {
            int j = random.nextInt(16) + 8;
            int k = random.nextInt(16) + 8;
            this.genSpikes.func_180709_b(world, random, world.func_175645_m(pos.func_177982_a(j, 0, k)));
        }
        super.func_180624_a(world, random, pos);
    }

    public class WorldGenLimestoneSpike
    extends WorldGenerator {
        private final Block spikeBlock = AtumBlocks.LIMESTONE;
        private final Block groundBlock = AtumBlocks.SAND;

        public boolean func_180709_b(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos) {
            while (world.func_175623_d(pos) && pos.func_177956_o() > 1 || world.func_175623_d(pos.func_177977_b())) {
                pos = pos.func_177977_b();
            }
            if (world.func_180495_p(pos).func_177230_c() != this.groundBlock) {
                return false;
            }
            int i = rand.nextInt(4) + 7;
            int j = i / 4 + rand.nextInt(2);
            for (int k = 0; k < i; ++k) {
                float f = (1.0f - (float)k / (float)i) * (float)j;
                int l = MathHelper.func_76123_f((float)f);
                for (int i1 = -l; i1 <= l; ++i1) {
                    float f1 = (float)MathHelper.func_76130_a((int)i1) - 0.25f;
                    for (int j1 = -l; j1 <= l; ++j1) {
                        float f2 = (float)MathHelper.func_76130_a((int)j1) - 0.25f;
                        if ((i1 != 0 || j1 != 0) && !(f1 * f1 + f2 * f2 <= f * f) || (i1 == -l || i1 == l || j1 == -l || j1 == l) && !(rand.nextFloat() <= 0.75f)) continue;
                        IBlockState state = world.func_180495_p(pos.func_177982_a(i1, k, j1));
                        Block block = state.func_177230_c();
                        if (block.isAir(state, (IBlockAccess)world, pos.func_177982_a(i1, k, j1)) || block == this.groundBlock) {
                            this.func_175903_a(world, pos.func_177982_a(i1, k, j1), this.spikeBlock.func_176223_P());
                        }
                        if (k == 0 || l <= 1 || !(block = (state = world.func_180495_p(pos.func_177982_a(i1, -k, j1))).func_177230_c()).isAir(state, (IBlockAccess)world, pos.func_177982_a(i1, -k, j1)) && block != this.groundBlock) continue;
                        this.func_175903_a(world, pos.func_177982_a(i1, -k, j1), this.spikeBlock.func_176223_P());
                    }
                }
            }
            int k1 = j - 1;
            if (k1 < 0) {
                k1 = 0;
            } else if (k1 > 1) {
                k1 = 1;
            }
            for (int l1 = -k1; l1 <= k1; ++l1) {
                block5: for (int i2 = -k1; i2 <= k1; ++i2) {
                    BlockPos pos1 = pos.func_177982_a(l1, -1, i2);
                    int j2 = 50;
                    if (Math.abs(l1) == 1 && Math.abs(i2) == 1) {
                        j2 = rand.nextInt(5);
                    }
                    while (pos1.func_177956_o() > 50) {
                        IBlockState state = world.func_180495_p(pos1);
                        Block block1 = state.func_177230_c();
                        if (!state.func_177230_c().isAir(state, (IBlockAccess)world, pos1) && block1 != this.groundBlock) continue block5;
                        this.func_175903_a(world, pos1, this.spikeBlock.func_176223_P());
                        pos1 = pos1.func_177977_b();
                        if (--j2 > 0) continue;
                        pos1 = pos1.func_177979_c(rand.nextInt(5) + 1);
                        j2 = rand.nextInt(5);
                    }
                }
            }
            return true;
        }
    }
}

