/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.structure.pyramid;

import com.teammetallurgy.atum.init.AtumBiomes;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.world.ChunkGeneratorAtum;
import com.teammetallurgy.atum.world.gen.structure.pyramid.PyramidPieces;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenPyramid
extends MapGenStructure {
    private static final List<Biome> ALLOWED_BIOMES = Arrays.asList(new Biome[]{AtumBiomes.SAND_PLAINS, AtumBiomes.SAND_DUNES, AtumBiomes.LIMESTONE_CRAGS, AtumBiomes.DEADWOOD_FOREST});
    private final ChunkGeneratorAtum chunkGenerator;
    private int seed = 10387404;
    private int spacing = 18;
    private int separation = 8;

    public MapGenPyramid(ChunkGeneratorAtum chunkGenerator) {
        this.chunkGenerator = chunkGenerator;
    }

    public boolean isPyramidInChunk(int chunkX, int chunkZ) {
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                if (!this.field_75053_d.containsKey(ChunkPos.func_77272_a((int)(chunkX + dx), (int)(chunkZ + dz)))) continue;
                StructureStart pyramid = (StructureStart)this.field_75053_d.get(ChunkPos.func_77272_a((int)(chunkX + dx), (int)(chunkZ + dz)));
                ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
                if (pyramid.func_75071_a() == null || !pyramid.func_75071_a().func_78885_a(chunkPos.func_180334_c(), chunkPos.func_180333_d(), chunkPos.func_180332_e(), chunkPos.func_180330_f())) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public String func_143025_a() {
        return String.valueOf(PyramidPieces.PYRAMID);
    }

    @Nullable
    public BlockPos func_180706_b(@Nonnull World world, @Nonnull BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = world;
        return MapGenPyramid.func_191069_a((World)world, (MapGenStructure)this, (BlockPos)pos, (int)this.spacing, (int)this.separation, (int)this.seed, (boolean)true, (int)100, (boolean)findUnexplored);
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        int x = chunkX;
        int z = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.spacing - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.spacing - 1;
        }
        int xSpacing = chunkX / this.spacing;
        int zSpacing = chunkZ / this.spacing;
        Random random = this.field_75039_c.func_72843_D(xSpacing, zSpacing, this.seed);
        xSpacing *= this.spacing;
        zSpacing *= this.spacing;
        if (x == (xSpacing += (random.nextInt(this.spacing - this.separation) + random.nextInt(this.spacing - this.separation)) / 2) && z == (zSpacing += (random.nextInt(this.spacing - this.separation) + random.nextInt(this.spacing - this.separation)) / 2)) {
            return this.field_75039_c.func_72959_q().func_76940_a(x * 16 + 8, z * 16 + 8, 16, ALLOWED_BIOMES);
        }
        return false;
    }

    @Nonnull
    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.chunkGenerator, this.field_75038_b, chunkX, chunkZ);
    }

    public static class Start
    extends StructureStart {
        private boolean isValid;

        public Start() {
        }

        Start(World world, ChunkGeneratorAtum chunkGenerator, Random random, int x, int z) {
            super(x, z);
            this.create(world, chunkGenerator, random, x, z);
        }

        private void create(World world, ChunkGeneratorAtum chunkGenerator, Random random, int chunkX, int chunkZ) {
            Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
            ChunkPrimer chunkPrimer = new ChunkPrimer();
            chunkGenerator.setBlocksInChunk(chunkX, chunkZ, chunkPrimer);
            int x = 5;
            int z = 5;
            if (rotation == Rotation.CLOCKWISE_90) {
                x = -5;
            } else if (rotation == Rotation.CLOCKWISE_180) {
                x = -5;
                z = -5;
            } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                z = -5;
            }
            int ground = chunkPrimer.func_186138_a(7, 7);
            int groundZ = chunkPrimer.func_186138_a(7, 7 + z);
            int groundX = chunkPrimer.func_186138_a(7 + x, 7);
            int groundXZ = chunkPrimer.func_186138_a(7 + x, 7 + z);
            int y = Math.min(Math.min(ground, groundZ), Math.min(groundX, groundXZ));
            if (y < 53) {
                this.isValid = false;
            } else {
                int yChance = MathHelper.func_76136_a((Random)random, (int)10, (int)16);
                BlockPos pos = new BlockPos(chunkX * 16 + 8, y - yChance, chunkZ * 16 + 8);
                List<StructureComponent> components = PyramidPieces.getComponents(world.func_72860_G().func_186340_h(), pos, rotation, random);
                this.field_75075_a.addAll(components);
                this.func_75072_c();
                this.isValid = true;
            }
        }

        public void func_75068_a(@Nonnull World world, @Nonnull Random rand, @Nonnull StructureBoundingBox box) {
            super.func_75068_a(world, rand, box);
            int y = this.field_75074_b.field_78895_b;
            for (int x = box.field_78897_a; x <= box.field_78893_d; ++x) {
                for (int z = box.field_78896_c; z <= box.field_78892_f; ++z) {
                    BlockPos pyramidPos;
                    BlockPos pos = new BlockPos(x, y, z);
                    if (world.func_175623_d(pos) || !this.field_75074_b.func_175898_b((Vec3i)pos)) continue;
                    boolean isVecInside = false;
                    for (StructureComponent component : this.field_75075_a) {
                        if (!component.func_74874_b().func_175898_b((Vec3i)pos)) continue;
                        component.func_74875_a(world, rand, box);
                        isVecInside = true;
                        break;
                    }
                    if (!isVecInside) continue;
                    for (int pyramidY = y - 1; pyramidY > 1 && (world.func_175623_d(pyramidPos = new BlockPos(x, pyramidY, z)) || world.func_180495_p(pyramidPos).func_185904_a().func_76224_d()); --pyramidY) {
                        world.func_180501_a(pyramidPos, AtumBlocks.LIMESTONE.func_176223_P(), 2);
                    }
                }
            }
        }

        public boolean func_75069_d() {
            return this.isValid;
        }
    }
}

