/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.block.cable.link;

import com.google.common.collect.Lists;
import java.io.IOException;
import mrriegel.storagenetwork.block.cable.GuiCable;
import mrriegel.storagenetwork.block.cable.GuiCableButton;
import mrriegel.storagenetwork.block.cable.link.ContainerCableLink;
import mrriegel.storagenetwork.gui.ItemSlotNetwork;
import mrriegel.storagenetwork.network.CableDataMessage;
import mrriegel.storagenetwork.registry.PacketRegistry;
import mrriegel.storagenetwork.util.inventory.FilterItemStackHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiCableLink
extends GuiCable {
    protected GuiCableButton btnInputOutputStorage;
    ContainerCableLink containerCableLink;

    public GuiCableLink(ContainerCableLink containerCableLink) {
        super(containerCableLink);
        this.containerCableLink = containerCableLink;
    }

    @Override
    public FilterItemStackHandler getFilterHandler() {
        return this.containerCableLink.link.filters;
    }

    @Override
    public void importSlotsButtonPressed() {
        super.importSlotsButtonPressed();
        int targetSlot = 0;
        for (ItemStack filterSuggestion : this.containerCableLink.link.getStoredStacks()) {
            if (this.containerCableLink.link.filters.isStackFiltered(filterSuggestion)) continue;
            this.containerCableLink.link.filters.setStackInSlot(targetSlot, filterSuggestion.func_77946_l());
            if (++targetSlot < this.containerCableLink.link.filters.getSlots()) continue;
            break;
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.btnWhite.setCustomDrawMethod(guiCableButton -> {
            if (this.containerCableLink.link.filters.isWhitelist) {
                this.func_73729_b(guiCableButton.field_146128_h + 1, guiCableButton.field_146129_i + 3, 176, 83, 13, 10);
            } else {
                this.func_73729_b(guiCableButton.field_146128_h + 1, guiCableButton.field_146129_i + 3, 190, 83, 13, 10);
            }
        });
        this.btnInputOutputStorage = new GuiCableButton(CableDataMessage.CableMessageType.TOGGLE_WAY, this.field_147003_i + 115, this.field_147009_r + 5, "");
        this.btnInputOutputStorage.setCustomDrawMethod(guiCableButton -> this.func_73729_b(guiCableButton.field_146128_h + 2, guiCableButton.field_146129_i + 2, 176 + this.containerCableLink.link.filterDirection.ordinal() * 12, 114, 12, 12));
        this.func_189646_b(this.btnInputOutputStorage);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        if (this.containerCableLink == null || this.containerCableLink.link == null) {
            return;
        }
        this.checkOreBtn.setIsChecked(this.containerCableLink.link.filters.ores);
        this.checkMetaBtn.setIsChecked(this.containerCableLink.link.filters.meta);
        this.checkNbtBtn.setIsChecked(this.containerCableLink.link.filters.nbt);
        this.field_146289_q.func_78276_b(String.valueOf(this.containerCableLink.link.getPriority()), this.field_147003_i + 30 - this.field_146289_q.func_78256_a(String.valueOf(this.containerCableLink.link.getPriority())) / 2, 5 + this.btnMinus.field_146129_i, 0x404040);
        this.itemSlotsGhost = Lists.newArrayList();
        int rows = 2;
        int cols = 9;
        int index = 0;
        int y = 26;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                ItemStack stack = this.containerCableLink.link.filters.getStackInSlot(index);
                int x = 8 + col * 18;
                this.itemSlotsGhost.add(new ItemSlotNetwork(this, stack, this.field_147003_i + x, this.field_147009_r + y, stack.func_190916_E(), this.field_147003_i, this.field_147009_r, true));
                ++index;
            }
            y += 18;
        }
        for (ItemSlotNetwork s : this.itemSlotsGhost) {
            s.drawSlot(mouseX, mouseY);
        }
    }

    @Override
    protected void drawTooltips(int mouseX, int mouseY) {
        super.drawTooltips(mouseX, mouseY);
        if (this.containerCableLink == null || this.containerCableLink.link == null) {
            return;
        }
        if (this.btnInputOutputStorage != null && this.btnInputOutputStorage.func_146115_a()) {
            this.func_146283_a(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)("gui.storagenetwork.fil.tooltip_" + this.containerCableLink.link.filterDirection.toString()), (Object[])new Object[0])}), mouseX, mouseY);
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (this.containerCableLink == null || this.containerCableLink.link == null) {
            return;
        }
        if (button.field_146127_k == this.btnMinus.field_146127_k) {
            --this.containerCableLink.link.priority;
            PacketRegistry.INSTANCE.sendToServer((IMessage)new CableDataMessage(button.field_146127_k));
        } else if (button.field_146127_k == this.btnPlus.field_146127_k) {
            ++this.containerCableLink.link.priority;
            PacketRegistry.INSTANCE.sendToServer((IMessage)new CableDataMessage(button.field_146127_k));
        } else if (button.field_146127_k == this.btnInputOutputStorage.field_146127_k) {
            this.containerCableLink.link.filterDirection = this.containerCableLink.link.filterDirection.next();
            PacketRegistry.INSTANCE.sendToServer((IMessage)new CableDataMessage(button.field_146127_k));
        }
    }
}

