/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.block.cable.processing;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mrriegel.storagenetwork.block.cable.TileCableWithFacing;
import mrriegel.storagenetwork.block.cable.processing.ProcessRequestModel;
import mrriegel.storagenetwork.block.master.TileMaster;
import mrriegel.storagenetwork.data.ItemStackMatcher;
import mrriegel.storagenetwork.util.UtilInventory;
import mrriegel.storagenetwork.util.inventory.ProcessingItemStackHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileCableProcess
extends TileCableWithFacing {
    private ProcessRequestModel processModel = new ProcessRequestModel();
    public EnumFacing processingTop = EnumFacing.UP;
    public EnumFacing processingBottom = EnumFacing.DOWN;
    public ProcessingItemStackHandler filters = new ProcessingItemStackHandler();

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.processingTop = EnumFacing.values()[compound.func_74762_e("processingTop")];
        this.processingBottom = EnumFacing.values()[compound.func_74762_e("processingBottom")];
        ProcessRequestModel pm = new ProcessRequestModel();
        pm.readFromNBT(compound);
        this.setProcessModel(pm);
        NBTTagCompound filters = compound.func_74775_l("filters");
        this.filters.deserializeNBT(filters);
        super.func_145839_a(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.processModel.writeToNBT(compound);
        compound.func_74768_a("processingBottom", this.processingBottom.ordinal());
        compound.func_74768_a("processingTop", this.processingTop.ordinal());
        NBTTagCompound filters = this.filters.serializeNBT();
        compound.func_74782_a("filters", (NBTBase)filters);
        return compound;
    }

    public void run() {
        ProcessRequestModel processRequest = this.getRequest();
        if (processRequest == null) {
            return;
        }
        if (!processRequest.isAlwaysActive() && processRequest.getCount() <= 0) {
            return;
        }
        if (this.getMaster() == null || this.getMaster().getTileEntity(TileMaster.class) == null) {
            return;
        }
        if (!this.hasDirection()) {
            return;
        }
        TileMaster master = this.getMaster().getTileEntity(TileMaster.class);
        List<ItemStack> ingredients = this.getProcessIngredients();
        List<ItemStack> outputs = this.getProcessOutputs();
        IItemHandler inventoryLinked = UtilInventory.getItemHandler(this.field_145850_b.func_175625_s(this.getFacingPosition()), this.getDirection().func_176734_d());
        if (processRequest.getStatus() == ProcessRequestModel.ProcessStatus.EXPORTING && ingredients.size() > 0) {
            ItemStack requestedFromNetwork;
            boolean simulate = true;
            int numSatisfiedIngredients = 0;
            for (ItemStack ingred : ingredients) {
                inventoryLinked = UtilInventory.getItemHandler(this.field_145850_b.func_175625_s(this.getFacingPosition()), this.getFacingTopRow());
                requestedFromNetwork = master.request(new ItemStackMatcher(ingred.func_77946_l(), this.filters.meta, this.filters.ores, this.filters.nbt), ingred.func_190916_E(), simulate);
                int found = requestedFromNetwork.func_190916_E();
                ItemStack remain = ItemHandlerHelper.insertItemStacked((IItemHandler)inventoryLinked, (ItemStack)requestedFromNetwork, (boolean)simulate);
                if (!remain.func_190926_b() || found < ingred.func_190916_E()) continue;
                ++numSatisfiedIngredients;
            }
            if (numSatisfiedIngredients == ingredients.size()) {
                simulate = false;
                for (ItemStack ingred : ingredients) {
                    requestedFromNetwork = master.request(new ItemStackMatcher(ingred), ingred.func_190916_E(), simulate);
                    ItemHandlerHelper.insertItemStacked((IItemHandler)inventoryLinked, (ItemStack)requestedFromNetwork, (boolean)simulate);
                }
                processRequest.setStatus(ProcessRequestModel.ProcessStatus.IMPORTING);
                this.setRequest(processRequest);
            }
        } else if (processRequest.getStatus() == ProcessRequestModel.ProcessStatus.IMPORTING && outputs.size() > 0) {
            for (ItemStack out : outputs) {
                inventoryLinked = UtilInventory.getItemHandler(this.field_145850_b.func_175625_s(this.getFacingPosition()), this.getFacingBottomRow());
                boolean simulate = true;
                int targetStillNeeds = UtilInventory.containsAtLeastHowManyNeeded(inventoryLinked, out, out.func_190916_E());
                ItemStack stackToMove = out.func_77946_l();
                stackToMove.func_190920_e(out.func_190916_E());
                int countNotInserted = master.insertStack(stackToMove, simulate);
                if (countNotInserted != 0 || targetStillNeeds != 0) continue;
                simulate = false;
                ItemStack extracted = UtilInventory.extractItem(inventoryLinked, new ItemStackMatcher(out), out.func_190916_E(), simulate);
                countNotInserted = master.insertStack(stackToMove, simulate);
                processRequest.setStatus(ProcessRequestModel.ProcessStatus.EXPORTING);
                this.setRequest(processRequest);
                if (processRequest.isAlwaysActive()) continue;
                processRequest.reduceCount();
            }
        }
        this.setRequest(processRequest);
        this.func_70296_d();
    }

    public List<ItemStack> getProcessIngredients() {
        return this.filters.getInputs().stream().map(stack -> stack.func_77946_l()).collect(Collectors.toList());
    }

    public List<ItemStack> getProcessOutputs() {
        return this.filters.getOutputs().stream().map(stack -> stack.func_77946_l()).collect(Collectors.toList());
    }

    @Nonnull
    public ItemStack getFirstRecipeOut() {
        if (this.filters.isOutputEmpty()) {
            return ItemStack.field_190927_a;
        }
        return this.filters.getOutputs().get(0);
    }

    public EnumFacing getFacingBottomRow() {
        return this.processingBottom;
    }

    public EnumFacing getFacingTopRow() {
        return this.processingTop;
    }

    public ProcessRequestModel getProcessModel() {
        return this.processModel;
    }

    public void setProcessModel(ProcessRequestModel processModel) {
        this.processModel = processModel;
    }

    public ProcessRequestModel getRequest() {
        return this.getProcessModel();
    }

    public void setRequest(ProcessRequestModel request) {
        this.setProcessModel(request);
    }
}

