/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.block.master;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mrriegel.storagenetwork.CreativeTab;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.api.capability.IConnectable;
import mrriegel.storagenetwork.api.data.DimPos;
import mrriegel.storagenetwork.block.BaseBlock;
import mrriegel.storagenetwork.block.master.TileMaster;
import mrriegel.storagenetwork.capabilities.StorageNetworkCapabilities;
import mrriegel.storagenetwork.util.UtilTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockMaster
extends BaseBlock {
    public BlockMaster(String registryName) {
        super(Material.field_151573_f, registryName);
        this.func_149711_c(3.0f);
        this.func_149647_a(CreativeTab.tab);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileMaster();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        DimPos masterPos = null;
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntity tileHere = null;
        IConnectable connect = null;
        for (BlockPos p : UtilTileEntity.getSides(pos)) {
            tileHere = worldIn.func_175625_s(p);
            if (tileHere == null || !tileHere.hasCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null) || (connect = (IConnectable)tileHere.getCapability(StorageNetworkCapabilities.CONNECTABLE_CAPABILITY, null)) == null || connect.getMasterPos() == null || !connect.getMasterPos().equals(worldIn, pos)) continue;
            masterPos = connect.getMasterPos();
            break;
        }
        if (masterPos != null) {
            worldIn.func_175698_g(pos);
            Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
        } else {
            TileEntity tileAtPos = worldIn.func_175625_s(pos);
            if (tileAtPos != null) {
                ((TileMaster)tileAtPos).refreshNetwork();
            }
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity tileHere = worldIn.func_175625_s(pos);
        if (!(tileHere instanceof TileMaster)) {
            return false;
        }
        TileMaster tileMaster = (TileMaster)tileHere;
        playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.LIGHT_PURPLE + StorageNetwork.lang("chat.master.emptyslots") + tileMaster.emptySlots()));
        playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_AQUA + StorageNetwork.lang("chat.master.connectables") + tileMaster.getConnectablePositions().size()));
        HashMap<String, Integer> mapNamesToCount = new HashMap<String, Integer>();
        for (DimPos p : tileMaster.getConnectablePositions()) {
            String block;
            mapNamesToCount.put(block, mapNamesToCount.get(block = p.getBlockState().func_177230_c().func_149732_F()) != null ? (Integer)mapNamesToCount.get(block) + 1 : 1);
        }
        ArrayList listDisplayStrings = Lists.newArrayList();
        for (Map.Entry e : mapNamesToCount.entrySet()) {
            listDisplayStrings.add(e);
        }
        Collections.sort(listDisplayStrings, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return Integer.compare(o2.getValue(), o1.getValue());
            }
        });
        for (Map.Entry e : listDisplayStrings) {
            playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "    " + (String)e.getKey() + ": " + e.getValue()));
        }
        return false;
    }

    public void func_190948_a(ItemStack stack, @Nullable World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, playerIn, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"tooltip.storagenetwork.master", (Object[])new Object[0]));
    }
}

