/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.network;

import io.netty.buffer.ByteBuf;
import mrriegel.storagenetwork.block.cable.ContainerCable;
import mrriegel.storagenetwork.block.cable.TileCable;
import mrriegel.storagenetwork.block.cable.io.ContainerCableIO;
import mrriegel.storagenetwork.block.cable.link.ContainerCableLink;
import mrriegel.storagenetwork.block.cable.processing.ContainerCableProcessing;
import mrriegel.storagenetwork.block.cable.processing.TileCableProcess;
import mrriegel.storagenetwork.util.UtilTileEntity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CableFilterMessage
implements IMessage,
IMessageHandler<CableFilterMessage, IMessage> {
    private int index;
    private ItemStack stack;
    private boolean ore;
    private boolean meta;
    private boolean nbt;

    public CableFilterMessage() {
    }

    public CableFilterMessage(int index, ItemStack stack, boolean ore, boolean meta, boolean nbt) {
        this.index = index;
        this.stack = stack;
        this.ore = ore;
        this.meta = meta;
        this.nbt = nbt;
    }

    public IMessage onMessage(CableFilterMessage message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        WorldServer mainThread = (WorldServer)player.field_70170_p;
        mainThread.func_152344_a(() -> {
            ContainerCable con;
            TileCable tileCable;
            if (player.field_71070_bA instanceof ContainerCable && (tileCable = ((ContainerCable)player.field_71070_bA).tile) instanceof TileCableProcess) {
                TileCableProcess processCable = (TileCableProcess)tileCable;
                processCable.filters.ores = message.ore;
                processCable.filters.meta = message.meta;
                processCable.filters.nbt = message.nbt;
                processCable.func_70296_d();
            }
            if (player.field_71070_bA instanceof ContainerCableLink) {
                con = (ContainerCableLink)player.field_71070_bA;
                if (con == null || con.link == null) {
                    return;
                }
                if (message.stack != null && message.index >= 0) {
                    con.link.filters.setStackInSlot(message.index, message.stack);
                }
                con.link.filters.ores = message.ore;
                con.link.filters.meta = message.meta;
                con.link.filters.nbt = message.nbt;
                con.tile.func_70296_d();
            }
            if (player.field_71070_bA instanceof ContainerCableIO) {
                con = (ContainerCableIO)player.field_71070_bA;
                if (con == null || ((ContainerCableIO)con).cap == null) {
                    return;
                }
                if (message.stack != null && message.index >= 0) {
                    ((ContainerCableIO)con).cap.filters.setStackInSlot(message.index, message.stack);
                }
                ((ContainerCableIO)con).cap.filters.ores = message.ore;
                ((ContainerCableIO)con).cap.filters.meta = message.meta;
                ((ContainerCableIO)con).cap.filters.nbt = message.nbt;
                ((ContainerCableIO)con).tile.func_70296_d();
                UtilTileEntity.updateTile(((ContainerCableIO)con).tile.func_145831_w(), ((ContainerCableIO)con).tile.func_174877_v());
            }
            if (player.field_71070_bA instanceof ContainerCableProcessing) {
                con = (ContainerCableProcessing)player.field_71070_bA;
                if (!(((ContainerCableProcessing)con).tile instanceof TileCableProcess)) {
                    return;
                }
                TileCableProcess tileCable2 = (TileCableProcess)((ContainerCableProcessing)con).tile;
                if (message.stack != null && message.index >= 0) {
                    tileCable2.filters.setStackInSlot(message.index, message.stack);
                }
                tileCable2.filters.ores = message.ore;
                tileCable2.filters.meta = message.meta;
                tileCable2.filters.nbt = message.nbt;
                tileCable2.func_70296_d();
            }
        });
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.index = buf.readInt();
        this.ore = buf.readBoolean();
        this.meta = buf.readBoolean();
        this.nbt = buf.readBoolean();
        this.stack = new ItemStack(ByteBufUtils.readTag((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.index);
        buf.writeBoolean(this.ore);
        buf.writeBoolean(this.meta);
        buf.writeBoolean(this.nbt);
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.stack != null) {
            nbt = this.stack.serializeNBT();
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt);
    }
}

