/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.integration;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IIconStyle;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.providers.DefaultProbeInfoProvider;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.config.Config;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.StringUtils;
import p455w0rd.danknull.api.DankNullItemModes;
import p455w0rd.danknull.api.IDankNullHandler;
import p455w0rd.danknull.blocks.tiles.TileDankNullDock;
import p455w0rd.danknull.init.ModBlocks;
import p455w0rd.danknull.init.ModConfig;
import p455w0rd.danknull.init.ModGlobals;
import p455w0rd.danknull.init.ModLogger;
import p455w0rd.danknull.inventory.cap.CapabilityDankNull;
import p455w0rd.danknull.items.ItemDankNull;
import p455w0rdslib.LibGlobals;
import p455w0rdslib.util.TextUtils;

public class TOP {
    private static boolean registered;

    public static void init() {
        if (registered) {
            return;
        }
        ModLogger.info(LibGlobals.Mods.TOP.getName() + " Integation: Enabled");
        registered = true;
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"p455w0rd.danknull.integration.TOP$GetTheOneProbe");
    }

    public static class DockInfoTools {
        static void showDockInfo(ProbeMode mode, IProbeInfo probeInfo, World world, BlockPos pos, IProbeConfig config) {
            List<ItemStack> stacks;
            if (world.func_175625_s(pos) instanceof TileDankNullDock && !((TileDankNullDock)world.func_175625_s(pos)).getDankNull().func_190926_b() && !(stacks = DockInfoTools.getDockContents(world, pos)).isEmpty()) {
                boolean showDetailed = Tools.show((ProbeMode)mode, (IProbeConfig.ConfigMode)IProbeConfig.ConfigMode.EXTENDED);
                DockInfoTools.showDockContents(((TileDankNullDock)world.func_175625_s(pos)).getDankNull(), probeInfo, stacks, showDetailed);
            }
        }

        private static void addItemStack(List<ItemStack> stacks, Set<Item> foundItems, @Nonnull ItemStack stack) {
            if (stack.func_190926_b()) {
                return;
            }
            if (foundItems != null && foundItems.contains(stack.func_77973_b())) {
                for (ItemStack s : stacks) {
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)stack)) continue;
                    s.func_190917_f(stack.func_190916_E());
                    return;
                }
            }
            stacks.add(stack.func_77946_l());
            if (foundItems != null) {
                foundItems.add(stack.func_77973_b());
            }
        }

        private static void showDockContents(ItemStack dankNull, IProbeInfo probeInfo, List<ItemStack> stacks, boolean detailed) {
            IProbeInfo vertical = null;
            IProbeInfo horizontal = null;
            int idx = 0;
            vertical = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(Config.chestContentsBorderColor)).spacing(0));
            if (detailed) {
                for (ItemStack stackInSlot : stacks) {
                    horizontal = vertical.horizontal(new LayoutStyle().spacing(10).alignment(ElementAlignment.ALIGN_CENTER));
                    if (ItemDankNull.isDankNull(dankNull)) {
                        IDankNullHandler dankNullHandler = (IDankNullHandler)dankNull.getCapability(CapabilityDankNull.DANK_NULL_CAPABILITY, null);
                        ItemStack tmpStack = stackInSlot.func_77946_l();
                        int extractable = stackInSlot.func_190916_E() - dankNullHandler.getExtractionMode(stackInSlot).getNumberToKeep();
                        if (dankNullHandler.getExtractionMode(stackInSlot) == DankNullItemModes.ItemExtractionMode.KEEP_ALL) {
                            extractable = 0;
                        }
                        horizontal.item(tmpStack, new ItemStyle().width(16).height(16)).text(TextStyleClass.INFO + stackInSlot.func_82833_r() + " (" + extractable + " extractable)");
                        continue;
                    }
                    horizontal.item(stackInSlot, new ItemStyle().width(16).height(16)).text(TextStyleClass.INFO + stackInSlot.func_82833_r());
                }
            } else {
                for (ItemStack stackInSlot : stacks) {
                    if (idx % 10 == 0) {
                        horizontal = vertical.horizontal((ILayoutStyle)new LayoutStyle().spacing(0));
                    }
                    horizontal.item(stackInSlot);
                    ++idx;
                }
            }
        }

        private static List<ItemStack> getDockContents(World world, BlockPos pos) {
            HashSet<Item> foundItems;
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            TileEntity te = world.func_175625_s(pos);
            HashSet<Item> hashSet = foundItems = Config.compactEqualStacks ? new HashSet<Item>() : null;
            if (te instanceof TileDankNullDock && te.hasCapability(CapabilityDankNull.DANK_NULL_CAPABILITY, null)) {
                IDankNullHandler handler = (IDankNullHandler)te.getCapability(CapabilityDankNull.DANK_NULL_CAPABILITY, null);
                for (int i = 0; i < handler.getSlots(); ++i) {
                    DockInfoTools.addItemStack(stacks, foundItems, handler.getFullStackInSlot(i));
                }
            }
            return stacks;
        }
    }

    public static class HarvestInfoTools {
        private static final ResourceLocation ICONS = new ResourceLocation("theoneprobe", "textures/gui/icons.png");
        private static String[] harvestLevels = new String[]{"stone", "iron", "diamond", "obsidian", "cobalt"};
        private static final HashMap<String, ItemStack> testTools = new HashMap();

        static void showHarvestLevel(IProbeInfo probeInfo, IBlockState blockState, Block block) {
            String harvestTool = block.getHarvestTool(blockState);
            if (harvestTool != null) {
                int harvestLevel = block.getHarvestLevel(blockState);
                String harvestName = harvestLevel >= harvestLevels.length ? Integer.toString(harvestLevel) : (harvestLevel < 0 ? Integer.toString(harvestLevel) : harvestLevels[harvestLevel]);
                probeInfo.text(TextStyleClass.LABEL + "Tool: " + TextStyleClass.INFO + harvestTool + " (level " + harvestName + ")");
            }
        }

        static void showCanBeHarvested(IProbeInfo probeInfo, World world, BlockPos pos, Block block, EntityPlayer player) {
            boolean harvestable;
            boolean bl = harvestable = block.canHarvestBlock((IBlockAccess)world, pos, player) && world.func_180495_p(pos).func_185887_b(world, pos) >= 0.0f;
            if (harvestable) {
                probeInfo.text(TextStyleClass.OK + "Harvestable");
            } else {
                probeInfo.text(TextStyleClass.WARNING + "Not harvestable");
            }
        }

        static void showHarvestInfo(IProbeInfo probeInfo, World world, BlockPos pos, Block block, IBlockState blockState, EntityPlayer player) {
            boolean v;
            float blockHardness;
            boolean harvestable = block.canHarvestBlock((IBlockAccess)world, pos, player) && world.func_180495_p(pos).func_185887_b(world, pos) >= 0.0f;
            String harvestTool = block.getHarvestTool(blockState);
            String harvestName = null;
            if (harvestTool == null && (blockHardness = blockState.func_185887_b(world, pos)) > 0.0f) {
                for (Map.Entry<String, ItemStack> testToolEntry : testTools.entrySet()) {
                    ItemStack testTool = testToolEntry.getValue();
                    if (testTool == null || !(testTool.func_77973_b() instanceof ItemTool)) continue;
                    ItemTool toolItem = (ItemTool)testTool.func_77973_b();
                    if (!(testTool.func_150997_a(blockState) >= toolItem.field_77862_b.func_77998_b())) continue;
                    harvestTool = testToolEntry.getKey();
                    break;
                }
            }
            if (harvestTool != null) {
                int harvestLevel = block.getHarvestLevel(blockState);
                if (harvestLevel >= 0 && harvestLevel < harvestLevels.length) {
                    harvestName = harvestLevels[harvestLevel];
                }
                harvestTool = StringUtils.capitalize((String)harvestTool);
            }
            int offs = (v = Config.harvestStyleVanilla) ? 16 : 0;
            int dim = v ? 13 : 16;
            ILayoutStyle alignment = probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER);
            IIconStyle iconStyle = probeInfo.defaultIconStyle().width(v ? 18 : 20).height(v ? 14 : 16).textureWidth(32).textureHeight(32);
            IProbeInfo horizontal = probeInfo.horizontal(alignment);
            if (harvestable) {
                horizontal.icon(ICONS, 0, offs, dim, dim, iconStyle).text(TextStyleClass.OK + (harvestTool != null ? harvestTool : "No tool"));
            } else if (harvestName == null || harvestName.isEmpty()) {
                horizontal.icon(ICONS, 16, offs, dim, dim, iconStyle).text(TextStyleClass.WARNING + (harvestTool != null ? harvestTool : "No tool"));
            } else {
                horizontal.icon(ICONS, 16, offs, dim, dim, iconStyle).text(TextStyleClass.WARNING + (harvestTool != null ? harvestTool : "No tool") + " (level " + harvestName + ")");
            }
        }

        static {
            testTools.put("shovel", new ItemStack(Items.field_151038_n));
            testTools.put("axe", new ItemStack(Items.field_151053_p));
            testTools.put("pickaxe", new ItemStack(Items.field_151039_o));
        }
    }

    public static class DankNullProbeInfoProvider
    implements IProbeInfoProvider {
        static final IProbeInfoProvider DEFAULT_PROVIDER = new DefaultProbeInfoProvider();

        public String getID() {
            return "theoneprobe:default";
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
            Block block = blockState.func_177230_c();
            BlockPos pos = data.getPos();
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileDankNullDock) {
                int power;
                TileDankNullDock dankDock = (TileDankNullDock)tile;
                ItemStack stack = new ItemStack((Block)ModBlocks.DANKNULL_DOCK);
                if (tile != null && tile instanceof TileDankNullDock) {
                    TileDankNullDock te = (TileDankNullDock)tile;
                    stack.func_77983_a("BlockEntityTag", (NBTBase)te.func_189515_b(new NBTTagCompound()));
                    String dankNull = "/d" + (ModConfig.Options.callItDevNull ? "ev" : "ank") + "/null";
                    String msg = TextUtils.translate((String)"dn.right_click_with.desc") + (te.getDankNull().func_190926_b() ? " " + dankNull : " " + TextUtils.translate((String)"dn.empty_hand_open.desc"));
                    ItemStack dockedDankNull = te.getDankNull().func_190926_b() ? ItemStack.field_190927_a : te.getDankNull();
                    IProbeInfo topTip = probeInfo.horizontal().item(stack).vertical().itemLabel(stack);
                    if (!dockedDankNull.func_190926_b()) {
                        IDankNullHandler dankNullHandler = dankDock.getCapability(CapabilityDankNull.DANK_NULL_CAPABILITY, null);
                        String dockedMsg = ModGlobals.Rarities.getRarityFromMeta(ItemDankNull.getTier(dockedDankNull).ordinal()).getColor() + "" + dockedDankNull.func_82833_r() + "" + TextFormatting.WHITE + " " + TextUtils.translate((String)"dn.docked.desc");
                        topTip.text(dockedMsg);
                        if (dankNullHandler.getSelected() < 0) {
                            return;
                        }
                        ItemStack selectedStack = dankNullHandler.getFullStackInSlot(dankNullHandler.getSelected());
                        if (!selectedStack.func_190926_b()) {
                            topTip.horizontal(new LayoutStyle().alignment(ElementAlignment.ALIGN_TOPLEFT).borderColor(Integer.valueOf(-65536)).spacing(-1)).item(selectedStack);
                            topTip.text(TextUtils.translate((String)"dn.extract_mode.desc") + ": " + dankNullHandler.getExtractionMode(selectedStack).getTooltip());
                        }
                    } else {
                        topTip.text(msg);
                    }
                    topTip.text(TextStyleClass.MODNAME.toString() + Tools.getModName((Block)blockState.func_177230_c()));
                }
                IProbeConfig config = Config.getRealConfig();
                boolean showHarvestLevel = Tools.show((ProbeMode)mode, (IProbeConfig.ConfigMode)config.getShowHarvestLevel());
                boolean showHarvested = Tools.show((ProbeMode)mode, (IProbeConfig.ConfigMode)config.getShowCanBeHarvested());
                if (showHarvested && showHarvestLevel) {
                    HarvestInfoTools.showHarvestInfo(probeInfo, world, pos, block, blockState, player);
                }
                if (Tools.show((ProbeMode)mode, (IProbeConfig.ConfigMode)config.getShowRedstone()) && (power = world.func_175651_c(data.getPos(), data.getSideHit().func_176734_d())) > 0) {
                    probeInfo.horizontal().item(new ItemStack(Items.field_151137_ax), probeInfo.defaultItemStyle().width(14).height(14)).text(TextStyleClass.LABEL + "Power: " + TextStyleClass.INFO + power);
                }
                DockInfoTools.showDockInfo(mode, probeInfo, world, pos, config);
            } else {
                DEFAULT_PROVIDER.addProbeInfo(mode, probeInfo, player, world, blockState, data);
            }
        }
    }

    public static class GetTheOneProbe
    implements Function<ITheOneProbe, Void> {
        @Nullable
        public Void apply(ITheOneProbe theOneProbe) {
            theOneProbe.registerProvider((IProbeInfoProvider)new DankNullProbeInfoProvider());
            return null;
        }
    }
}

