/*
 * Decompiled with CFR 0.152.
 */
package com.sosnitzka.taiga.traits;

import com.sosnitzka.taiga.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class TraitCursed
extends AbstractTrait {
    public TraitCursed() {
        super(TraitCursed.class.getSimpleName().toLowerCase().substring(5), TextFormatting.RED);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onUpdate(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
        NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
        Utils.GeneralNBTData data = Utils.GeneralNBTData.read(tag);
        int chance = 60000;
        if (random.nextInt((chance + data.curse) / (data.curse + 1)) == 1) {
            data.curse = isSelected ? (data.curse += 10) : ++data.curse;
            entity.func_70097_a(new DamageSource("Curse"), random.nextFloat() * ((EntityPlayer)entity).func_110143_aJ() / 2.0f);
        }
        data.write(tag);
        TagUtil.setExtraTag((ItemStack)tool, (NBTTagCompound)tag);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent e) {
        ItemStack tool = e.getItemStack();
        if (TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)tool), (String)this.identifier)) {
            NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
            Utils.GeneralNBTData data = Utils.GeneralNBTData.read(tag);
            if (data.curse != 0) {
                e.getToolTip().add(TextFormatting.DARK_PURPLE + "Curse: " + TextFormatting.WHITE + data.curse);
            }
        }
    }
}

