/*
 * Decompiled with CFR 0.152.
 */
package cf.terminator.laggoggles.mixinhelper.extended;

import java.lang.reflect.Field;
import java.util.ListIterator;
import org.spongepowered.asm.lib.Opcodes;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.FrameNode;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.LabelNode;
import org.spongepowered.asm.lib.tree.LineNumberNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;

public class Debugging {
    public static String printClassNodeMethods(ClassNode classNode) {
        StringBuilder builder = new StringBuilder();
        for (MethodNode method : classNode.methods) {
            builder.append("\n\n");
            builder.append(Debugging.getMethodName(method));
            builder.append(Debugging.getInstructions(method));
        }
        return builder.toString();
    }

    public static String getMethodName(MethodNode method) {
        return method.name + " " + method.desc;
    }

    public static String getInstructions(MethodNode method) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        ListIterator<AbstractInsnNode> it = method.instructions.iterator();
        while (it.hasNext()) {
            builder.append(Debugging.getInstructionText(it.next()));
            builder.append("\n");
        }
        return builder.toString();
    }

    public static String translateOpcode(int opcode) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        try {
            for (Field field : Opcodes.class.getFields()) {
                if (opcode != (Integer)field.get(null)) continue;
                if (builder.length() > 1) {
                    builder.append("/");
                }
                builder.append(field.getName());
            }
            builder.append(") (");
            builder.append(opcode);
            builder.append(")");
            return builder.toString();
        }
        catch (Exception e) {
            return "Unknown, error: " + e.getLocalizedMessage();
        }
    }

    public static String getInstructionText(AbstractInsnNode node) {
        String translation = Debugging.translateOpcode(node.getOpcode());
        if (node instanceof LabelNode) {
            return "label: " + ((LabelNode)node).getLabel() + " " + translation;
        }
        if (node instanceof FrameNode) {
            return "\tframe: L:" + ((FrameNode)node).local + " S:" + ((FrameNode)node).stack + " " + translation;
        }
        if (node instanceof LineNumberNode) {
            return "\tline number: " + ((LineNumberNode)node).line + " " + translation;
        }
        if (node instanceof InsnNode) {
            return "\tinsn: " + translation;
        }
        if (node instanceof JumpInsnNode) {
            return "\tjump: " + ((JumpInsnNode)node).label.getLabel() + " " + translation;
        }
        if (node instanceof FieldInsnNode) {
            return "\tfield: " + ((FieldInsnNode)node).name + " " + translation;
        }
        if (node instanceof VarInsnNode) {
            return "\tvar: " + ((VarInsnNode)node).var + " " + translation;
        }
        if (node instanceof MethodInsnNode) {
            return "\tmethod: " + ((MethodInsnNode)node).owner + "#" + ((MethodInsnNode)node).name + " " + ((MethodInsnNode)node).desc + " " + translation;
        }
        return "\tUnknown: " + node.toString() + node.getClass().toGenericString();
    }
}

